/*
 * Decompiled with CFR 0.152.
 */
package zephyr.iwanami.koujien;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DicBody {
    private final ArrayList<String> lemmaList = new ArrayList();
    private final HashSet<String> lemmaSet = new HashSet();
    private final ArrayList<String> ddList = new ArrayList();
    private final HashMap<String, String> kana2hyokiMap = new HashMap(250000);
    private final HashMap<String, String> hyoki2kanaMap = new HashMap(250000);
    private static final Pattern DT = Pattern.compile("<dt[^<>]*>(.+)</dt><dd><p>(.+)</p></dd>");
    private static final Pattern LEMMA5_KANA1 = Pattern.compile("(([^\u2010]+?)\u2010[^\u2010]+?\u3010)\u2015(.+?\u3011)");
    private static final Pattern LEMMA5_KANA2 = Pattern.compile("([^\u2010]+?\u2010([^\u2010]+?)\u3010[^\u2010]+?)\u2015(\u3011)");
    private static final String MULTI = "MULTI";

    public DicBody(String string) throws Exception {
        this.load(string);
    }

    private static String normalizeLemma(String string) {
        string = string.replaceAll("<sub>[^<>]+</sub>", "");
        return string;
    }

    private static String normalizeLemma5(String string) {
        int n;
        Matcher matcher = LEMMA5_KANA1.matcher(string);
        if (matcher.find()) {
            string = matcher.group(1) + matcher.group(2) + matcher.group(3);
        }
        if ((matcher = LEMMA5_KANA2.matcher(string)).find()) {
            string = matcher.group(1) + matcher.group(2) + matcher.group(3);
        }
        if ((n = string.indexOf(12304)) > 0) {
            string = string.substring(0, n) + string.substring(n).replace('\u2010', '-');
        }
        string = string.replaceFirst("(\u3010[\\x00-\\x7F]+[\\x21-\\x7F])([\\x80-\\uFFFF]+\u3011)", "$1 $2");
        return string;
    }

    private void put(String string, String string2, HashMap<String, String> hashMap) {
        if (!hashMap.containsKey(string)) {
            hashMap.put(string, string2);
        } else {
            hashMap.put(string, MULTI);
        }
    }

    private void load(String string) throws Exception {
        String string2;
        File file = new File(string);
        if (!file.canRead()) {
            System.err.println("cannot find/read " + string);
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        while ((string2 = bufferedReader.readLine()) != null) {
            Matcher matcher = DT.matcher(string2);
            if (!matcher.find()) continue;
            String string3 = DicBody.normalizeLemma5(DicBody.normalizeLemma(matcher.group(1)));
            this.lemmaList.add(string3);
            this.lemmaSet.add(string3);
            this.ddList.add(matcher.group(2));
            int n = string3.indexOf(12304);
            if (n <= 0) continue;
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n + 1, string3.length() - 1);
            this.put(string4, string5, this.kana2hyokiMap);
            this.put(string5, string4, this.hyoki2kanaMap);
        }
        bufferedReader.close();
        System.err.println("load " + this.lemmaList.size() + " lemmas from " + string);
    }

    public ArrayList<String> getLemmas() {
        return this.lemmaList;
    }

    public ArrayList<String> getDD() {
        return this.ddList;
    }

    public boolean hasLemma(String string) {
        return this.lemmaSet.contains(string);
    }

    public String getHyoki(String string) {
        String string2 = this.kana2hyokiMap.get(string);
        if (string2 != null && string2 != MULTI) {
            return string2;
        }
        return null;
    }

    public String getKana(String string) {
        String string2 = this.hyoki2kanaMap.get(string);
        if (string2 != null && string2 != MULTI) {
            return string2;
        }
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println(DicBody.normalizeLemma5("\u30a2\u30fc\u30af\u2010\u3068\u3046\u3010\u2015\u706f\u3011"));
        System.out.println(DicBody.normalizeLemma5("\u30a2\u30fc\u30b5\u30fc\u304a\u3046\u2010\u3082\u306e\u304c\u305f\u308a\u3010\u2015\u738b\u7269\u8a9e\u3011"));
        System.out.println(DicBody.normalizeLemma5("\u30a2\u30fc\u30c8\u30de\u30f3\u3010&#xA126;tman\u68b5\u3011"));
        System.out.println(DicBody.normalizeLemma5("\u30a2\u30fc\u30c8\u30de\u30f3\u3010&#xA126;tman \u68b5\u3011"));
        System.out.println(DicBody.normalizeLemma5("\u30a2\u30f4\u30a1\u30f3\u2010\u30ae\u30e3\u30eb\u30c9\u3010avant-garde\u30d5\u30e9\u30f3\u30b9\u3011"));
        System.out.println(DicBody.normalizeLemma5("\u3042\u304b\u2010\u30af\u30ed\u30fc\u30d0\u30fc\u3010\u8d64\u2015\u3011"));
    }
}

