/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.awt.image.BufferedImage;
import org.apache.pdfbox.rendering.ImageType;
import zephyr.util.PDF2Jpeg;

public class PDF2MonoBMP
extends PDF2Jpeg {
    private final double WHITE_RATIO = Double.parseDouble(System.getProperty("whiteRatio", "0.01"));

    PDF2MonoBMP() {
        super(ImageType.BINARY, ".bmp", "bmp", false);
        this.TRIM_MARGIN = Integer.parseInt(System.getProperty("margin", "20"));
    }

    @Override
    protected boolean isWhiteHorizon(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        int n3 = 0;
        int n4 = (int)(this.WHITE_RATIO * (double)n2);
        for (int i = 0; i < n2; ++i) {
            if (bufferedImage.getRGB(i, n) == -1) continue;
            ++n3;
        }
        return n3 <= n4;
    }

    @Override
    protected boolean isWhiteVertical(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getHeight();
        int n3 = 0;
        int n4 = (int)(this.WHITE_RATIO * (double)n2);
        for (int i = 0; i < n2; ++i) {
            if (bufferedImage.getRGB(n, i) == -1) continue;
            ++n3;
        }
        return n3 <= n4;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("Usage: java PDF2MonoBMP sample.pdf outDir [dpi] [startPage] [endPage] [prefix] [startIdx]");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        int n = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : 200;
        int n2 = stringArray.length > 3 ? Integer.parseInt(stringArray[3]) : 1;
        int n3 = stringArray.length > 4 ? Integer.parseInt(stringArray[4]) : Integer.MAX_VALUE;
        String string3 = stringArray.length > 5 && !stringArray[5].equals("null") ? stringArray[5] : null;
        int n4 = stringArray.length > 6 ? Integer.parseInt(stringArray[6]) : 1;
        PDF2MonoBMP pDF2MonoBMP = new PDF2MonoBMP();
        pDF2MonoBMP.convert(string, string2, string3, n4, n, n2, n3);
    }
}

