/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PDF2Jpeg {
    protected int TRIM_MARGIN = 10;
    private final ImageType IMAGE_TYPE;
    private final String FILE_POSTFIX;
    protected final String OUTPUT_TYPE;
    private final boolean ADD_FILENAME_PREFIX;
    protected static final int WHITE = -1;

    protected PDF2Jpeg() {
        this.IMAGE_TYPE = ImageType.RGB;
        this.FILE_POSTFIX = ".jpg";
        this.OUTPUT_TYPE = "jpeg";
        this.ADD_FILENAME_PREFIX = true;
    }

    protected PDF2Jpeg(ImageType imageType, String filePostfix, String outputType, boolean addFilenamePrefix) {
        this.IMAGE_TYPE = imageType;
        this.FILE_POSTFIX = filePostfix;
        this.OUTPUT_TYPE = outputType;
        this.ADD_FILENAME_PREFIX = addFilenamePrefix;
        System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
    }

    protected void convert(String pdfname, String outDirname, String outPrefix, int startIdx, int dpi, int startPage, int endPage) throws Exception {
        File outDir;
        File sourceFile = new File(pdfname);
        if (!sourceFile.exists()) {
            System.err.println(String.valueOf(pdfname) + " \u304c\u3042\u308a\u307e\u305b\u3093");
            return;
        }
        if (this.ADD_FILENAME_PREFIX) {
            if (outPrefix == null) {
                outPrefix = sourceFile.getName();
                outPrefix = outPrefix.substring(0, outPrefix.length() - 4);
            }
        } else if (outPrefix == null) {
            outPrefix = "";
        }
        if (!(outDir = new File(outDirname)).exists()) {
            outDir.mkdirs();
        }
        System.out.println(String.valueOf(pdfname) + " \u5909\u63db\u958b\u59cb");
        PDDocument document = PDDocument.load((File)sourceFile);
        PDFRenderer pdfRenderer = new PDFRenderer(document);
        int pageNo = startIdx;
        int i = startPage - 1;
        while (i < document.getNumberOfPages() && i < endPage) {
            BufferedImage bim = pdfRenderer.renderImageWithDPI(i, (float)dpi, this.IMAGE_TYPE);
            String outname = startIdx < 0 && document.getNumberOfPages() <= 1 ? String.valueOf(outPrefix) + this.FILE_POSTFIX : String.valueOf(outPrefix) + pageNo + this.FILE_POSTFIX;
            File outputfile = new File(outDir, outname);
            bim = this.trim(bim, this.TRIM_MARGIN);
            this.write(bim, this.OUTPUT_TYPE, outputfile);
            ++pageNo;
            ++i;
        }
        document.close();
        System.out.println();
        System.out.println(String.valueOf(pdfname) + " \u5909\u63db\u7d42\u4e86");
    }

    protected void write(BufferedImage bim, String type, File outputfile) throws Exception {
        ImageIO.write((RenderedImage)bim, this.OUTPUT_TYPE, outputfile);
        System.out.print(String.valueOf(outputfile.getName()) + " ");
    }

    protected void convert(String pdfname, String outDirname, String outPrefix, int startIdx, int dpi) throws Exception {
        this.convert(pdfname, outDirname, outPrefix, startIdx, dpi, 1, Integer.MAX_VALUE);
    }

    public BufferedImage trim(BufferedImage bim, int margin) {
        int width = bim.getWidth();
        int height = bim.getHeight();
        int minY = 0;
        while (minY < height) {
            if (!this.isWhiteHorizon(bim, minY)) {
                if ((minY -= margin) >= 0) break;
                minY = 0;
                break;
            }
            ++minY;
        }
        int maxY = height - 1;
        while (maxY > minY) {
            if (!this.isWhiteHorizon(bim, maxY)) {
                if ((maxY += margin) <= height) break;
                maxY = height;
                break;
            }
            --maxY;
        }
        int minX = 0;
        while (minX < width) {
            if (!this.isWhiteVertical(bim, minX)) {
                if ((minX -= margin) >= 0) break;
                minX = 0;
                break;
            }
            ++minX;
        }
        int maxX = width - 1;
        while (maxX > minX) {
            if (!this.isWhiteVertical(bim, maxX)) {
                if ((maxX += margin) <= width) break;
                maxX = width;
                break;
            }
            --maxX;
        }
        return bim.getSubimage(minX, minY, maxX - minX, maxY - minY);
    }

    public BufferedImage trim(BufferedImage bim) {
        return this.trim(bim, this.TRIM_MARGIN);
    }

    protected boolean isWhiteHorizon(BufferedImage bim, int y) {
        int width = bim.getWidth();
        int x = 0;
        while (x < width) {
            if (bim.getRGB(x, y) != -1) {
                return false;
            }
            ++x;
        }
        return true;
    }

    protected boolean isWhiteVertical(BufferedImage bim, int x) {
        int height = bim.getHeight();
        int y = 0;
        while (y < height) {
            if (bim.getRGB(x, y) != -1) {
                return false;
            }
            ++y;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: java PDF2Jpeg sample.pdf outDir [dpi] [startIdx] [outputPrefix]");
            return;
        }
        String pdfname = args[0];
        String outDir = args[1];
        int dpi = args.length > 2 ? Integer.parseInt(args[2]) : 200;
        int startIdx = args.length > 3 ? Integer.parseInt(args[3]) : -1;
        String outPrefix = args.length > 4 ? args[4] : null;
        PDF2Jpeg app = new PDF2Jpeg();
        app.convert(pdfname, outDir, outPrefix, startIdx, dpi);
    }
}

