/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class ImageConverter {
    private final String inExt;
    private final String outExt;
    private final String inDotExt;
    private final String outDotExt;
    private final String DOT_EXT = ".";
    private final int scaling;
    private final boolean toUpper;
    private final boolean toLower;

    public ImageConverter(String inExt, String outExt) {
        this(inExt, outExt, 100);
    }

    public ImageConverter(String inExt, String outExt, int scaling) {
        this.inExt = this.dropDot(inExt).toLowerCase();
        this.outExt = this.dropDot(outExt).toLowerCase();
        this.inDotExt = "." + inExt;
        this.outDotExt = "." + outExt;
        this.scaling = scaling;
        this.toUpper = "true".equals(System.getProperty("upperName"));
        this.toLower = "true".equals(System.getProperty("lowerName"));
    }

    private String dropDot(String txt) {
        if (txt.startsWith(".")) {
            return txt.substring(".".length());
        }
        return txt;
    }

    public static BufferedImage resize(BufferedImage image, int width, int height) {
        BufferedImage thumb = new BufferedImage(width, height, image.getType());
        thumb.getGraphics().drawImage(image.getScaledInstance(width, height, 16), 0, 0, width, height, null);
        return thumb;
    }

    private void convert(File inFile, File outDir) throws Exception {
        String filename = inFile.getName();
        System.err.print(String.valueOf(filename) + " ");
        filename = String.valueOf(filename.substring(0, filename.length() - this.inDotExt.length())) + this.outDotExt;
        if (this.toUpper) {
            filename = filename.toUpperCase();
        } else if (this.toLower) {
            filename = filename.toLowerCase();
        }
        File outFile = new File(outDir, filename);
        BufferedImage inImage = ImageIO.read(inFile);
        BufferedImage outImage = new BufferedImage(inImage.getWidth(), inImage.getHeight(), 1);
        Graphics2D off = outImage.createGraphics();
        off.drawImage(inImage, 0, 0, Color.WHITE, null);
        if (this.scaling != 100) {
            int width = this.scaling * outImage.getWidth() / 100;
            int height = this.scaling * outImage.getHeight() / 100;
            outImage = ImageConverter.resize(outImage, width, height);
        }
        ImageIO.write((RenderedImage)outImage, this.outExt, outFile);
    }

    private void convertDir(File inDir, File outDir) throws Exception {
        System.err.println("\u5909\u63db\u5143\uff1a" + inDir.getAbsolutePath() + "\t" + this.inExt);
        System.err.println("\u5909\u63db\u5148\uff1a" + outDir.getAbsolutePath() + "\t" + this.outExt);
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        Object[] files = inDir.list();
        Arrays.sort(files);
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            if (((String)file).toLowerCase().endsWith(this.inDotExt)) {
                this.convert(new File(inDir, (String)file), outDir);
            }
            ++n2;
        }
        System.err.println();
    }

    public void convertDir(String inDirName, String outDirName) throws Exception {
        File inDir = new File(inDirName);
        File outDir = new File(outDirName);
        this.convertDir(inDir, outDir);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.err.println("Usage: java ImageConverter inDir inExt outDir outExt [scalling%]");
            return;
        }
        ImageConverter conv = args.length < 5 ? new ImageConverter(args[1], args[3]) : new ImageConverter(args[1], args[3], Integer.parseInt(args[4]));
        conv.convertDir(args[0], args[2]);
    }
}

