/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import zephyr.util.MultiTreeMap;

public class Counter<E> {
    private final HashMap<E, Integer> map = new HashMap();

    public void add(E key) {
        Integer v = this.map.get(key);
        if (v != null) {
            this.map.put(key, v + 1);
        } else {
            this.map.put(key, 1);
        }
    }

    public HashMap<E, Integer> map() {
        return this.map;
    }

    public MultiTreeMap<Integer, E> sort() {
        MultiTreeMap<Integer, E> sorted = new MultiTreeMap<Integer, E>(new ReverseComp());
        for (Map.Entry<E, Integer> e : this.map.entrySet()) {
            sorted.put(e.getValue(), e.getKey());
        }
        return sorted;
    }

    public void dump() {
        this.dump(this.map.size() / 100);
    }

    public void dumpAll() {
        this.dump(0);
    }

    public void dump(int min) {
        MultiTreeMap<Integer, E> sortMap = this.sort();
        int max = sortMap.isEmpty() ? 0 : (Integer)sortMap.keySet().iterator().next();
        System.err.println("tags: max=" + max + ", size=" + this.map.size());
        for (Integer count : sortMap.keySet()) {
            if (count < min) break;
            System.err.print(count + "=" + sortMap.getList(count) + ", ");
        }
        System.err.println();
    }

    private static class ReverseComp
    implements Comparator<Integer> {
        private ReverseComp() {
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return o2 - o1;
        }
    }
}

