/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.kangorin;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.imageio.ImageIO;
import zephyr.util.ImageConverter;

public class MakeGaiji {
    private static final String RET = System.getProperty("line.separator");
    private static final int EBCODE_START = 41260;
    private static final int UNICODE_START = 57344;
    private int nextUnicode = 57344;
    private static final int GAIJI_SIZE = 16;

    private BufferedImage getImage(File file) throws Exception {
        BufferedImage inImage = ImageIO.read(file);
        return ImageConverter.resize(inImage, 16, 16);
    }

    private void load(File file, PrintWriter gaijiXml, PrintWriter gaijiMapXml) throws Exception {
        BufferedImage img = this.getImage(file);
        if (img.getWidth() != img.getHeight()) {
            return;
        }
        System.out.print(" " + file.getName());
        String code = file.getName().substring(0, 4).toUpperCase();
        StringBuilder sb = new StringBuilder();
        sb.append("<fontData ebcode=\"");
        sb.append(code);
        sb.append("\" unicode=\"");
        sb.append(String.format("%X", this.nextUnicode));
        sb.append("\">\n");
        int y = 0;
        while (y < 16) {
            int x = 0;
            while (x < 16) {
                boolean isBlack;
                boolean bl = isBlack = img.getRGB(x, y) != 0;
                if (isBlack) {
                    sb.append("#");
                } else {
                    sb.append(" ");
                }
                ++x;
            }
            sb.append(RET);
            ++y;
        }
        sb.append("</fontData>");
        gaijiXml.println(sb.toString());
        gaijiMapXml.printf("<gaijiMap unicode=\"#x%X\" ebcode=\"%s\"/>\n", this.nextUnicode, code);
        ++this.nextUnicode;
    }

    private void load(String dirName) throws Exception {
        File dir = new File(dirName);
        Object[] names = dir.list();
        Arrays.sort(names);
        PrintWriter gaijiXml = new PrintWriter("Gaiji.xml");
        gaijiXml.println("<?xml version=\"1.0\" encoding=\"Shift_JIS\"?>");
        gaijiXml.println("<gaijiData xml:space=\"preserve\">");
        gaijiXml.printf("<fontSet size=\"%dX%d\" start=\"%X\">\n", 16, 16, 41260);
        PrintWriter gaijiMapXml = new PrintWriter("GaijiMap.xml");
        gaijiMapXml.println("<?xml version=\"1.0\" encoding=\"Shift_JIS\"?>");
        gaijiMapXml.println("<gaijiSet>");
        Object[] objectArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            Object name = objectArray[n2];
            if (((String)name).matches("[ABCabc][0-9A-Fa-f]{3}\\.[Pp][Nn][Gg]")) {
                this.load(new File(dir, (String)name), gaijiXml, gaijiMapXml);
            }
            ++n2;
        }
        gaijiXml.println("</fontSet>");
        gaijiXml.println("</gaijiData>");
        gaijiXml.close();
        gaijiMapXml.println("</gaijiSet>");
        gaijiMapXml.close();
    }

    public static void main(String[] args) throws Exception {
        String dirName = args.length > 0 ? args[0] : "C:\\Program Files\\LogoVista\\LVEDBRSR\\DIC\\NKGORIN2\\Gaijitemp";
        MakeGaiji app = new MakeGaiji();
        app.load(dirName);
    }
}

