/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.daikanwa;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.taishukan.daikanwa.DKWWords;
import zephyr.taishukan.daikanwa.GetSVG;
import zephyr.taishukan.daikanwa.Jukugo;
import zephyr.util.MultiHashMap;
import zephyr.util.MultiLinkedHashMap;
import zephyr.util.MultiTreeMap;
import zephyr.util.ZephyrUtil;

public class MakeDKWHtml {
    private static final int UNKNOWN_BUSHUKAKU = 100000;
    private static final int UNKNOWN_SOUKAKU = 200000;
    private final MultiHashMap<String, String> uni2dkwMap = new MultiHashMap();
    private final HashMap<String, DKWEntry> dkwMap = new HashMap();
    static final int[] PAGE_OFFSET;
    private static final int LAST_PAGE_VOL12 = 13757;
    private final LinkedList<String> urlList = new LinkedList();
    private final HashMap<Integer, String> bushuKanaMap = new HashMap();
    private final HashMap<String, String> uni2kakuMap = new HashMap();
    private static final Pattern SOUKAKU_LINE;
    private final HashMap<String, String> dkw2kakuMap = new HashMap();
    private static final Pattern JIKUN;
    private static final Pattern JIKUN_NO;
    private final MultiLinkedHashMap<String, String> jikun2dkwMap = new MultiLinkedHashMap();
    private final MultiHashMap<String, String> dkw2jikunMap = new MultiHashMap();
    private static final HashMap<Integer, String> bushuCharMap;
    private static final int MAX_SOUKAKU = 100;
    private final TreeMap<Integer, BushGroup> bushuGroupMap = new TreeMap();
    private DKWEntry prevEntry = null;

    static {
        int[] nArray = new int[13];
        nArray[0] = -1;
        nArray[2] = 1082;
        nArray[3] = 2274;
        nArray[4] = 3402;
        nArray[5] = 4638;
        nArray[6] = 5712;
        nArray[7] = 6908;
        nArray[8] = 8136;
        nArray[9] = 9354;
        nArray[10] = 10442;
        nArray[11] = 11542;
        nArray[12] = 12596;
        PAGE_OFFSET = nArray;
        SOUKAKU_LINE = Pattern.compile("^(DH?[0-9\\.]+)\t([0-9,]+)");
        JIKUN = Pattern.compile("^[\u3041-\u31ff\u30fb\u2026\uff08\uff09\uff5c]+");
        JIKUN_NO = Pattern.compile("^([0-9]+)(\\.[12])?");
        bushuCharMap = new HashMap();
        bushuCharMap.put(2, "\uff5c");
        bushuCharMap.put(43, "\u5c22");
        bushuCharMap.put(44, "\u5c38");
        bushuCharMap.put(45, "\u5c6e");
        bushuCharMap.put(58, "\u30e8");
        bushuCharMap.put(63, "\u6238");
        bushuCharMap.put(104, "\u75c5*");
        bushuCharMap.put(114, "\u79b9*");
        bushuCharMap.put(124, "\u7fbd");
        bushuCharMap.put(162, "\u8fb7*");
        bushuCharMap.put(174, "\u9752*");
        bushuCharMap.put(200, "\u9ebb");
        bushuCharMap.put(201, "\u9ec4*");
        bushuCharMap.put(203, "\u9ed2*");
    }

    private static File hasDkwImage(String no) {
        File svg = new File("s", String.valueOf(no) + ".bmp");
        if (svg.exists()) {
            return svg;
        }
        return null;
    }

    String dkwImage(String no) {
        File svg = MakeDKWHtml.hasDkwImage(no);
        if (svg != null) {
            return "<img src=\"s/" + svg.getName() + "\"/>";
        }
        return null;
    }

    private String shortenDNo(String no) {
        if (no.length() > 0) {
            return no.replaceFirst("D0*", "").replaceFirst("H0*", "H").replace(".0", "");
        }
        return no;
    }

    private LinkedList<Integer> ucss2codes(LinkedList<String> ucsList) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (String ucs : ucsList) {
            try {
                list.add(Integer.parseInt(ucs, 16));
            }
            catch (NumberFormatException e) {
                System.err.println(ucs);
            }
        }
        return list;
    }

    private String ucss2txt(LinkedList<String> ucsList, boolean withUnicode, boolean forDT, boolean withImgAlways) {
        if (ucsList.size() == 0) {
            return "[\u4e0d\u660e]";
        }
        StringBuilder sb = new StringBuilder();
        Iterator iterator = this.ucss2codes(ucsList).iterator();
        while (iterator.hasNext()) {
            boolean isJIS;
            int code = (Integer)iterator.next();
            if (sb.length() > 0) {
                sb.append(" / ");
            }
            if (forDT) {
                sb.append("\u3010<b>");
            }
            if ((isJIS = ZephyrUtil.isValidJISCode(code)) && !withImgAlways) {
                sb.append(Character.toChars(code));
            } else {
                File f = new File("i", String.format("%05X.bmp", code));
                if (f.exists()) {
                    sb.append("<img src=\"i/");
                    sb.append(f.getName());
                    sb.append("\"/>");
                } else {
                    sb.append("[\u753b\u50cf\u306a\u3057]");
                }
                if (isJIS && withImgAlways) {
                    sb.append("(");
                    sb.append(Character.toChars(code));
                    sb.append(")");
                }
            }
            if (forDT) {
                sb.append("</b>\u3011");
            }
            if (!withUnicode) continue;
            String uni = String.format("U+%05X", code);
            sb.append(" ");
            sb.append(uni);
            String stroke = this.uni2kakuMap.get(uni);
            if (stroke == null) continue;
            sb.append("(");
            sb.append(stroke);
            sb.append("\u753b)");
        }
        return sb.toString();
    }

    private String ucss2txt(LinkedList<String> ucsList, boolean withUnicode) {
        return this.ucss2txt(ucsList, withUnicode, false, false);
    }

    private String ucss2txt(LinkedList<String> ucsList) {
        return this.ucss2txt(ucsList, true, false, false);
    }

    private String list2txt(LinkedList<String> list) {
        if (list.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String txt : list) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(txt);
        }
        return sb.toString();
    }

    private int[] fullpage2volpage(int page) {
        if (page > 13757) {
            System.err.println("\u30da\u30fc\u30b8\u756a\u53f7\u7570\u5e38\uff1a" + page);
        }
        int vol = PAGE_OFFSET.length - 1;
        while (vol >= 1) {
            if (page >= PAGE_OFFSET[vol] + 1) {
                return new int[]{vol, page - PAGE_OFFSET[vol]};
            }
            --vol;
        }
        return new int[]{-1, -1};
    }

    private int[] dkwNo2volNo(String no) {
        if (no.compareTo("D48903.0") >= 0) {
            int[] nArray = new int[2];
            nArray[0] = 13;
            return nArray;
        }
        if (no.compareTo("D42210.0") >= 0) {
            return new int[]{12, PAGE_OFFSET[12]};
        }
        if (no.compareTo("D38700.0") >= 0) {
            return new int[]{11, PAGE_OFFSET[11]};
        }
        if (no.compareTo("D32804.0") >= 0) {
            return new int[]{10, PAGE_OFFSET[10]};
        }
        if (no.compareTo("D28108.0") >= 0) {
            return new int[]{9, PAGE_OFFSET[9]};
        }
        if (no.compareTo("D22678.0") >= 0) {
            return new int[]{8, PAGE_OFFSET[8]};
        }
        if (no.compareTo("D17575.0") >= 0) {
            return new int[]{7, PAGE_OFFSET[7]};
        }
        if (no.compareTo("D14415.0") >= 0) {
            return new int[]{6, PAGE_OFFSET[6]};
        }
        if (no.compareTo("D11530.0") >= 0) {
            return new int[]{5, PAGE_OFFSET[5]};
        }
        if (no.compareTo("D07411.0") >= 0) {
            return new int[]{4, PAGE_OFFSET[4]};
        }
        if (no.compareTo("D04675.0") >= 0) {
            return new int[]{3, PAGE_OFFSET[3]};
        }
        if (no.compareTo("D01450.0") >= 0) {
            return new int[]{2, PAGE_OFFSET[2]};
        }
        if (no.compareTo("D00001.0") >= 0) {
            return new int[]{1, PAGE_OFFSET[1]};
        }
        System.err.println(no);
        System.exit(1);
        return new int[]{-1, -1};
    }

    private int[] dkwNo2volNo(DKWEntry entry) {
        if (entry.page.startsWith("DPH")) {
            int[] nArray = new int[2];
            nArray[0] = 15;
            return nArray;
        }
        if (entry.page.startsWith("DPX")) {
            int[] nArray = new int[2];
            nArray[0] = 13;
            return nArray;
        }
        if (entry.page.equals("DP?????")) {
            return new int[]{-1, -1};
        }
        return this.dkwNo2volNo(entry.no);
    }

    private String uni2jis(String txt, int myCode) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < txt.length()) {
            int code = txt.codePointAt(i);
            if (ZephyrUtil.isValidJISCode(code)) {
                sb.append(Character.toChars(code));
            } else {
                boolean directRef;
                LinkedList dkwNoList = this.uni2dkwMap.getWithoutNull(String.format("U+%05X", code));
                boolean bl = directRef = dkwNoList.size() == 1 && code != myCode;
                if (directRef) {
                    sb.append("<nobr><a href=\"#");
                    sb.append((String)dkwNoList.getFirst());
                    sb.append("\">\u2192");
                }
                sb.append("<img src=\"i/");
                sb.append(String.format("%05X.bmp", code));
                sb.append("\"/>");
                if (directRef) {
                    sb.append("</a></nobr>");
                } else if (dkwNoList.size() > 1) {
                    sb.append("[");
                    boolean bFirst = true;
                    for (String no : dkwNoList) {
                        if (bFirst) {
                            bFirst = false;
                        } else {
                            sb.append(", ");
                        }
                        sb.append("<a href=\"#");
                        sb.append(no);
                        sb.append("\">");
                        sb.append(this.shortenDNo(no));
                        sb.append("</a>");
                    }
                    sb.append("]");
                }
            }
            if (code >= 131072) {
                ++i;
            }
            ++i;
        }
        return sb.toString();
    }

    private String uni2jis(String txt) {
        return this.uni2jis(txt, -1);
    }

    private String linkToNo(String no) {
        String s = this.dkwImage(no);
        if (s != null) {
            return "<a href=\"#" + no + "\">" + this.shortenDNo(no) + s + "</a>";
        }
        DKWEntry entry = this.dkwMap.get(no);
        if (entry != null) {
            return "<a href=\"#" + no + "\">" + this.shortenDNo(no) + this.ucss2txt(entry.ucsList, false, false, true) + "</a>";
        }
        return "<a href=\"#" + no + "\">" + this.shortenDNo(no) + "</a>";
    }

    private String makeEntryKey(DKWEntry entry, DKWWords words) {
        StringBuilder sb = new StringBuilder();
        Iterator iterator = this.ucss2codes(entry.ucsList).iterator();
        while (iterator.hasNext()) {
            int code = (Integer)iterator.next();
            sb.append("<key>U+");
            sb.append(String.format("%05X", code));
            sb.append("</key>");
            if (!ZephyrUtil.isValidJISCode(code)) continue;
            sb.append("<key>");
            sb.append(Character.toChars(code));
            sb.append("</key>");
        }
        int[] v = this.dkwNo2volNo(entry);
        int prevPageNo = 0;
        if (v[0] > 0) {
            int page = Integer.parseInt(entry.page.replaceFirst("DP[XH0]*", ""));
            prevPageNo = page - v[1];
            sb.append("<key>");
            sb.append(v[0]);
            sb.append(".");
            sb.append(prevPageNo);
            sb.append("</key>");
        }
        for (Jukugo jukugo : words.getJukugo(entry.no)) {
            if (prevPageNo != jukugo.pageNo && jukugo.pageNo > 0 && (v = this.fullpage2volpage(jukugo.pageNo))[0] > 0) {
                sb.append("<key>");
                sb.append(v[0]);
                sb.append(".");
                if (v[1] != jukugo.pageNo) {
                    sb.append(v[1]);
                } else {
                    sb.append(jukugo.pageNo);
                }
                sb.append("</key>");
            }
            prevPageNo = jukugo.pageNo;
        }
        return sb.toString();
    }

    private void addJikun(StringBuilder sb, DKWEntry entry) {
        LinkedList list = this.dkw2jikunMap.getList(entry.no);
        if (list == null) {
            return;
        }
        sb.append("<p>\u5b57\u8a13\uff1a");
        boolean bFirst = true;
        for (String jikun : list) {
            if (!bFirst) {
                sb.append("\u3001");
            } else {
                bFirst = false;
            }
            sb.append(this.jikun2txt(jikun));
        }
        sb.append("</p>");
    }

    private void addGwLink(StringBuilder sb, DKWEntry entry) {
        this.urlList.clear();
        File f = MakeDKWHtml.hasDkwImage(entry.no);
        if (f != null) {
            this.urlList.add("http://glyphwiki.org/wiki/" + GetSVG.id2gwid(entry.no));
        }
        for (String ucs : entry.ucsList) {
            this.urlList.add("http://glyphwiki.org/wiki/u" + ucs.toLowerCase());
        }
        for (String url : this.urlList) {
            sb.append("<p>");
            sb.append(url);
            sb.append("</p>");
        }
    }

    private void output(BushGroup group, DKWEntry entry, DKWWords words) {
        int uni;
        boolean hasRel;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("<dt id=\"%s\">%s</dt>%s<dd>", entry.no, this.shortenDNo(entry.no), this.makeEntryKey(entry, words)));
        String s = this.dkwImage(entry.no);
        if (s != null) {
            sb.append("<p>\u3010");
            sb.append(s);
            sb.append("\u3011");
            if (entry.ucsList.size() > 0) {
                sb.append(String.format("\u3000%s", this.ucss2txt(entry.ucsList, true, true, true)));
            }
            sb.append("</p>");
        } else if (entry.ucsList.size() > 0) {
            sb.append(String.format("<p>%s</p>", this.ucss2txt(entry.ucsList, true, true, true)));
        }
        if (!entry.ids.isEmpty()) {
            sb.append(String.format("<p>IDS\uff1a %s</p>", this.uni2jis(entry.ids)));
        }
        String bushuTxt = "<a href=\"#DR" + group.bushu().bushuNo + "\">\u2192" + this.ucss2txt(group.bushu().ucsList, false) + "</a>";
        if (entry.bushuKaku < 100000) {
            sb.append(String.format("<p>\u90e8\u9996\uff1a%s\u3001\u90e8\u9996\u5185\u753b\u6570\uff1a<a href=\"#DR%d.%d\">%d</a>", bushuTxt, group.bushu().bushuNo, entry.bushuKaku, entry.bushuKaku));
        } else {
            sb.append(String.format("<p>\u90e8\u9996\uff1a%s", bushuTxt));
        }
        String kakuTxt = this.dkw2kakuMap.get(entry.no);
        if (kakuTxt != null) {
            sb.append("\u3001\u7dcf\u753b\u6570\uff1a");
            sb.append(kakuTxt);
            sb.append("\u753b");
        }
        sb.append("</p>");
        int[] v = this.dkwNo2volNo(entry);
        if (v[0] > 0) {
            int page = Integer.parseInt(entry.page.replaceFirst("DP[XH0]*", ""));
            sb.append("<p>");
            sb.append(v[0]);
            sb.append("\u5dfb\u3001");
            sb.append(page);
            if (v[1] > 0) {
                sb.append("\uff08");
                sb.append(page - v[1]);
                sb.append("\uff09");
            }
            sb.append("\u9801");
            sb.append("</p>");
        }
        this.addJikun(sb, entry);
        this.addGwLink(sb, entry);
        boolean hasDup = !entry.duplicateNo.isEmpty();
        boolean bl = hasRel = !entry.relNo.isEmpty();
        if (hasDup || hasRel) {
            sb.append("<p>");
            if (hasDup) {
                sb.append(String.format("\u91cd\u8907\uff1a %s", this.linkToNo(entry.duplicateNo)));
            }
            if (hasRel) {
                if (hasDup) {
                    sb.append("\u3001");
                }
                sb.append(String.format("\u95a2\u9023\uff1a%s", this.linkToNo(entry.relNo)));
            }
            sb.append("</p>");
        }
        if (entry.otherUcsList.size() > 0) {
            sb.append(String.format("<p>\u7570\u4f53\u5b57\uff1a%s</p>", this.ucss2txt(entry.otherUcsList)));
        }
        if (entry.otherInfo.size() > 0) {
            sb.append(String.format("<p>\u8ffd\u8a18\uff1a%s</p>", this.list2txt(entry.otherInfo)));
        }
        int myCode = -1;
        if (entry.ucsList.size() == 1 && this.uni2dkwMap.getWithoutNull(String.format("U+%05X", uni = Integer.parseInt(entry.ucsList.getFirst(), 16))).size() == 1) {
            myCode = uni;
        }
        int prevPageNo = 0;
        for (Jukugo jukugo : words.getJukugo(entry.no)) {
            boolean bNewPage = false;
            if (prevPageNo != jukugo.pageNo) {
                bNewPage = true;
                if (prevPageNo != 0) {
                    sb.append("</p>");
                }
                sb.append("<p><b>[");
                if (jukugo.pageNo > 0) {
                    v = this.fullpage2volpage(jukugo.pageNo);
                    if (v[0] > 0) {
                        sb.append(v[0]);
                        sb.append("\u5dfb\u3001");
                        sb.append(jukugo.pageNo);
                        if (v[1] != jukugo.pageNo) {
                            sb.append("\uff08");
                            sb.append(v[1]);
                            sb.append("\uff09");
                        }
                        sb.append("\u9801");
                    } else {
                        sb.append(jukugo.pageNo);
                        sb.append("\u9801");
                    }
                } else {
                    sb.append("\u88dc\u5dfb\u3001");
                    sb.append(-jukugo.pageNo);
                    sb.append("\u9801");
                }
                sb.append("]</b> ");
                prevPageNo = jukugo.pageNo;
            }
            if (jukugo.wordNo.contains("0.") || jukugo.wordNo.contains("5.")) {
                sb.append("\u3000<b>(");
                sb.append(jukugo.wordNo.replaceFirst("^H?0*", "").replace(".0", ""));
                sb.append(")</b>");
            } else if (!bNewPage) {
                sb.append("\u3000:");
            }
            sb.append("\u3000");
            String jisJukugo = this.uni2jis(jukugo.word, myCode);
            sb.append(jisJukugo);
            if (jisJukugo.contains("<")) continue;
            sb.append("<key>");
            sb.append(jisJukugo);
            sb.append("</key>");
        }
        if (prevPageNo != 0) {
            sb.append("</p>");
        }
        sb.append("</dd>");
        System.out.println(sb.toString());
    }

    private void loadBushuKana(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        while ((line = br.readLine()) != null) {
            String[] v = line.split("\t");
            int no = Integer.parseInt(v[0]);
            this.bushuKanaMap.put(no, v[2]);
        }
        br.close();
    }

    private String makeBushuKanaKey(String kana) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = kana.split("\u30fb");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            sb.append("<key type=\"\u304b\u306a\">");
            sb.append(key);
            sb.append("</key>");
            ++n2;
        }
        return sb.toString();
    }

    private void loadStrokes(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        while ((line = br.readLine()) != null) {
            String[] v = line.split("\t");
            if (!v[0].startsWith("U+")) continue;
            String uni = v[0].length() == 6 ? "U+0" + v[0].substring(2) : v[0];
            this.uni2kakuMap.put(uni, v[1]);
        }
        br.close();
    }

    private void loadDKWStrokes(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        while ((line = br.readLine()) != null) {
            Matcher m = SOUKAKU_LINE.matcher(line);
            if (!m.find()) continue;
            this.dkw2kakuMap.put(m.group(1), m.group(2));
        }
        br.close();
    }

    private void loadJikunSakuin(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        String jikun = "";
        String page = "";
        HashSet<String> noSet = new HashSet<String>();
        while ((line = br.readLine()) != null) {
            Matcher m = JIKUN.matcher(line);
            if (m.find()) {
                jikun = m.group();
                noSet.clear();
                continue;
            }
            m = JIKUN_NO.matcher(line);
            if (m.find()) {
                int no = Integer.parseInt(m.group(1));
                String dkwno = m.group(2) == null ? String.format("D%05d.0", no) : String.format("D%05d%s", no, m.group(2));
                if (noSet.contains(dkwno)) {
                    System.err.println("\u5b57\u8a13\u91cd\u8907\uff1a" + page + "\t" + jikun + "\t" + m.group());
                }
                this.jikun2dkwMap.put(jikun, dkwno);
                this.dkw2jikunMap.put(dkwno, jikun);
                noSet.add(dkwno);
                continue;
            }
            if (!line.startsWith("\uff20")) continue;
            page = line;
        }
        br.close();
        System.err.println("load " + this.jikun2dkwMap.keySet().size() + " jikun, " + this.jikun2dkwMap.size() + " entries");
    }

    private String bushuMenu(BushGroup group) {
        String s = bushuCharMap.get(group.bushu().bushuNo);
        if (s != null) {
            return "(" + s + ")";
        }
        s = this.ucss2txt(group.bushu().ucsList, false).replaceFirst(" /.+", "");
        if (s.contains(".bmp")) {
            System.err.println("\u90e8\u9996" + group.bushu().bushuNo + " \t" + s);
        }
        return s;
    }

    private void makeDKWLinkList(StringBuilder sb, Collection<DKWEntry> list, boolean withSoukaku) {
        boolean bFirst = true;
        int curSoukaku = 0;
        for (DKWEntry entry : list) {
            LinkedList<Integer> soukakuList;
            if (bFirst) {
                bFirst = false;
            } else {
                sb.append("\u3000");
            }
            if (withSoukaku && (soukakuList = this.getSoukakuList(entry)).size() > 0 && soukakuList.getFirst() > curSoukaku) {
                curSoukaku = soukakuList.getFirst();
                sb.append("<b>[");
                sb.append(curSoukaku);
                sb.append("\u753b]</b>\u3000");
            }
            sb.append("<nobr><a href=\"#");
            sb.append(entry.no);
            sb.append("\">\u2192");
            String s = this.dkwImage(entry.no);
            if (s != null) {
                sb.append(s);
            } else {
                sb.append(this.ucss2txt(entry.ucsList, false, false, true));
            }
            sb.append("</a></nobr>");
        }
    }

    private void makeDKWLinkList(StringBuilder sb, Collection<DKWEntry> list) {
        this.makeDKWLinkList(sb, list, false);
    }

    private void output(BushGroup group, DKWWords words) {
        String bushuKanji = this.bushuMenu(group);
        String bushuKana = this.bushuKanaMap.get(group.bushu().bushuNo);
        System.out.println("<h1 id=\"DR" + group.bushu().bushuNo + "\">" + bushuKanji + "\u3010" + bushuKana + "\u3011</h1>");
        System.out.println(this.makeBushuKanaKey(bushuKana));
        System.out.println("<p>\u90e8\u9996\u756a\u53f7\uff1a" + group.bushu().bushuNo + "</p>");
        System.out.print("<p>\u90e8\u9996\u5185\u753b\u6570\uff1a");
        for (Integer kaku : group.kanjiList.keySet()) {
            if (kaku != 100000) {
                System.out.printf("<a href=\"#DR%d.%d\">%d</a>\u3000", group.bushu().bushuNo, kaku, kaku);
                continue;
            }
            System.out.printf("<a href=\"#DR%d.%d\">\u4e0d\u660e</a>\u3000", group.bushu().bushuNo, kaku);
        }
        System.out.println("</p>");
        for (Integer kaku : group.kanjiList.keySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<h2 id=\"DR");
            sb.append(group.bushu().bushuNo);
            sb.append(".");
            sb.append(kaku);
            sb.append("\">");
            sb.append(bushuKanji);
            sb.append("\u3000");
            if (kaku != 100000) {
                sb.append(kaku);
                sb.append("\u753b");
            } else {
                sb.append("\u753b\u6570\u4e0d\u660e");
            }
            sb.append("</h2>");
            String[] stringArray = bushuKana.split("\u30fb");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                sb.append("<key type=\"\u8868\u8a18\">");
                sb.append(key);
                if (kaku != 100000) {
                    sb.append(kaku);
                    sb.append("\u753b</key>");
                } else {
                    sb.append("\u753b\u6570\u4e0d\u660e</key>");
                }
                ++n2;
            }
            sb.append("<p>");
            this.makeDKWLinkList(sb, group.kanjiList.getList(kaku));
            sb.append("</p>");
            System.out.println(sb.toString());
        }
        for (Integer kaku : group.kanjiList.keySet()) {
            for (DKWEntry entry : group.kanjiList.getList(kaku)) {
                this.output(group, entry, words);
            }
        }
    }

    private LinkedList<Integer> getSoukakuList(DKWEntry entry) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        String kakuTxt = this.dkw2kakuMap.get(entry.no);
        if (kakuTxt != null) {
            String[] stringArray = kakuTxt.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String k = stringArray[n2];
                list.add(Integer.parseInt(k));
                ++n2;
            }
        } else {
            for (String ucs : entry.ucsList) {
                String uni = ucs.length() == 4 ? "U+0" + ucs : "U+" + ucs;
                kakuTxt = this.uni2kakuMap.get(uni);
                if (kakuTxt == null) continue;
                String[] stringArray = kakuTxt.split(",");
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String k = stringArray[n3];
                    list.add(Integer.parseInt(k));
                    ++n3;
                }
            }
        }
        return list;
    }

    private void outputStrokes() {
        TreeMap data = new TreeMap();
        int kaku = 1;
        while (kaku <= 100) {
            data.put(kaku, new MultiTreeMap());
            ++kaku;
        }
        data.put(200000, new MultiTreeMap());
        for (BushGroup group : this.bushuGroupMap.values()) {
            int bushuNo = group.bushu().bushuNo;
            for (Integer kaku2 : group.kanjiList.keySet()) {
                for (DKWEntry entry : group.kanjiList.getList(kaku2)) {
                    LinkedList<Integer> soukakuList = this.getSoukakuList(entry);
                    if (soukakuList.size() > 0) {
                        Iterator iterator = soukakuList.iterator();
                        while (iterator.hasNext()) {
                            int soukaku = (Integer)iterator.next();
                            MultiTreeMap map = (MultiTreeMap)data.get(soukaku);
                            map.put(bushuNo, entry);
                        }
                        continue;
                    }
                    ((MultiTreeMap)data.get(200000)).put(bushuNo, entry);
                }
            }
        }
        LinkedList soukakuRevList = new LinkedList();
        soukakuRevList.addAll(data.keySet());
        Collections.reverse(soukakuRevList);
        System.out.println("<h1>\u7dcf\u753b\u6570\u7d22\u5f15</h1>");
        for (Integer soukaku : data.keySet()) {
            LinkedList<DKWEntry> list;
            MultiTreeMap map = (MultiTreeMap)data.get(soukaku);
            if (map.size() == 0) continue;
            String id = "SK" + soukaku;
            if (soukaku != 200000) {
                System.out.println("<h2 id=\"" + id + "\">" + soukaku + "\u753b</h2>");
            } else {
                System.out.println("<h2 id=\"" + id + "\">\u7dcf\u753b\u6570\u4e0d\u660e</h2>");
            }
            System.out.print("<p>");
            for (Integer bushuNo : map.keySet()) {
                list = map.getList(bushuNo);
                if (list == null) continue;
                BushGroup group = this.bushuGroupMap.get(bushuNo);
                System.out.printf("<a href=\"#SK%d.%s\">%s</a>\u3000", soukaku, bushuNo, this.bushuMenu(group));
            }
            System.out.println("</p>");
            for (Integer bushuNo : map.keySet()) {
                list = map.getList(bushuNo);
                if (list == null) continue;
                String subid = String.valueOf(id) + "." + bushuNo;
                BushGroup group = this.bushuGroupMap.get(bushuNo);
                if (soukaku != 200000) {
                    System.out.println("<h3 id =\"" + subid + "\">" + soukaku + "\u753b \u3000" + this.bushuMenu(group) + "</h3>");
                } else {
                    System.out.println("<h3 id =\"" + subid + "\">\u7dcf\u753b\u6570\u4e0d\u660e\u3000" + this.bushuMenu(group) + "</h3>");
                }
                StringBuilder sb = new StringBuilder();
                sb.append("<p>");
                this.makeDKWLinkList(sb, list);
                for (Integer k : soukakuRevList) {
                    if (k >= soukaku || ((MultiTreeMap)data.get(k)).size() <= 0) continue;
                    this.soukakuLink(sb, k);
                    break;
                }
                this.soukakuLink(sb, soukaku);
                for (Integer k : data.keySet()) {
                    if (k <= soukaku || ((MultiTreeMap)data.get(k)).size() <= 0) continue;
                    this.soukakuLink(sb, k);
                    break;
                }
                sb.append("</p>");
                System.out.println(sb.toString());
            }
        }
    }

    private void makeJikunKanaKeys(LinkedList<String> list, String jikun) {
        if (!jikun.contains("\uff08")) {
            list.add(jikun);
        } else {
            list.add(jikun.replaceAll("\uff08.+?\uff09", "").replace("\uff5c", ""));
            try {
                String kana = jikun.replaceAll("\uff5c([^\uff08\uff09]+)\uff08(.+?)\uff09", "$2");
                kana = kana.replaceAll("([^\uff08\uff09])\uff08(.+?)\uff09", "$2");
                list.add(kana);
            }
            catch (Exception e) {
                System.err.println(jikun);
                e.printStackTrace();
            }
        }
    }

    private String jikun2txt(String jikun) {
        return jikun.replaceAll("(\uff08.+?\uff09)", "<sub>$1</sub>").replace("\uff5c", "");
    }

    private void makeJikunDt(StringBuilder sb, String jikun, int n) {
        LinkedList<String> list = new LinkedList<String>();
        String[] stringArray = jikun.split("\u30fb");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String v = stringArray[n3];
            this.makeJikunKanaKeys(list, v);
            ++n3;
        }
        String dt = this.jikun2txt(jikun);
        sb.append("<dt noindex=\"1\" title=\"");
        sb.append(dt);
        sb.append(" ");
        sb.append(n);
        sb.append("\">");
        sb.append(dt);
        sb.append("</dt>");
        for (String key : list) {
            sb.append("<key type=\"\u304b\u306a\">");
            sb.append(key);
            sb.append("</key>");
        }
    }

    private void outputJikun() {
        System.out.println("<h1>\u5b57\u8a13\u7d22\u5f15</h1>");
        LinkedList<DKWEntry> list = new LinkedList<DKWEntry>();
        for (String jikun : this.jikun2dkwMap.keySet()) {
            list.clear();
            for (String no : this.jikun2dkwMap.getList(jikun)) {
                DKWEntry entry = this.dkwMap.get(no);
                if (entry != null) {
                    list.add(entry);
                    continue;
                }
                System.err.println("\u5b57\u8a13\uff1aDKWNO\u4e0d\u6b63\uff1a" + no);
                System.exit(1);
            }
            StringBuilder sb = new StringBuilder();
            this.makeJikunDt(sb, jikun, list.size());
            sb.append("<dd>");
            sb.append(list.size());
            sb.append("<p>");
            boolean withSoukaku = list.size() >= 30;
            this.makeDKWLinkList(sb, list, withSoukaku);
            sb.append("</p></dd>");
            System.out.println(sb.toString());
        }
    }

    private void soukakuLink(StringBuilder sb, int soukaku) {
        sb.append("\u3000\u3000<a href=\"#SK");
        sb.append(soukaku);
        sb.append("\">\u2192");
        if (soukaku != 200000) {
            sb.append(soukaku);
            sb.append("\u753b\u4e00\u89a7");
        } else {
            sb.append("\u7dcf\u753b\u6570\u4e0d\u660e\u4e00\u89a7");
        }
        sb.append("</a>");
    }

    private BushGroup getBushGroup(DKWEntry entry) {
        BushGroup group = this.bushuGroupMap.get(entry.bushuNo);
        if (group == null) {
            group = new BushGroup();
            this.bushuGroupMap.put(entry.bushuNo, group);
            if (entry.bushuKaku != 0) {
                System.err.println("\u90e8\u9996\u756a\u53f7\u4e0d\u6b63\uff1f\u3000" + entry.no + " DR" + entry.bushuNo + " DS" + entry.bushuKaku);
            }
        }
        return group;
    }

    private void checkPrevious(DKWEntry entry) {
        if (this.prevEntry != null && !entry.page.endsWith("?") && !this.prevEntry.page.endsWith("?") && entry.page.compareTo(this.prevEntry.page) < 0) {
            System.err.println("\u30da\u30fc\u30b8\u756a\u53f7\uff1f\t" + entry.no + " " + entry.page);
        }
        if (entry.no.compareTo("D48903.0") >= 0 || !entry.no.endsWith(".0")) {
            return;
        }
        if (this.prevEntry != null && entry.bushuKaku > 0 && entry.bushuKaku < this.prevEntry.bushuKaku && this.prevEntry.bushuKaku != 100000) {
            System.err.println("\u90e8\u9996\u5185\u753b\u6570\uff1f\t" + entry.no + " DS" + entry.bushuKaku);
        }
        this.prevEntry = entry;
    }

    private void loadDashPages() throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File("dash-pages.txt"));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        while ((line = br.readLine()) != null) {
            String[] v = line.split("[ \t]+");
            if (v.length < 2) continue;
            String no = v[0];
            String page = v[1];
            DKWEntry entry = this.dkwMap.get(no);
            if (entry != null) {
                entry.page = page;
                continue;
            }
            System.err.println("\u30c0\u30c3\u30b7\u30e5\u30da\u30fc\u30b8\uff1a" + no);
        }
        br.close();
    }

    private void load(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        BushGroup group = null;
        while ((line = br.readLine()) != null) {
            DKWEntry entry = new DKWEntry(this, line);
            if (this.dkwMap.containsKey(entry.no)) {
                System.err.println("\u89aa\u5b57\u756a\u53f7\u91cd\u8907\t" + line);
            }
            this.dkwMap.put(entry.no, entry);
            group = this.getBushGroup(entry);
            group.add(entry);
            this.checkPrevious(entry);
        }
        br.close();
        this.loadDashPages();
    }

    private void output(DKWWords words) {
        System.out.println("<html><body>");
        this.outputStrokes();
        for (BushGroup g : this.bushuGroupMap.values()) {
            this.output(g, words);
        }
        this.outputJikun();
        System.out.println("</body></html>");
    }

    private void outputJikunForCheck() {
        System.out.println("<html><body>");
        LinkedList<DKWEntry> list = new LinkedList<DKWEntry>();
        for (String jikun : this.jikun2dkwMap.keySet()) {
            list.clear();
            for (String no : this.jikun2dkwMap.getList(jikun)) {
                DKWEntry entry = this.dkwMap.get(no);
                if (entry != null) {
                    list.add(entry);
                    continue;
                }
                System.err.println("\u5b57\u8a13\uff1aDKWNO\u4e0d\u6b63\uff1a" + no);
                System.exit(1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<p>");
            sb.append(jikun);
            sb.append("\u3000");
            for (DKWEntry entry : list) {
                if (entry.ucsList.size() > 0) {
                    for (String ucs : entry.ucsList) {
                        sb.append("&#x");
                        sb.append(ucs);
                        sb.append(";");
                    }
                    sb.append(" ");
                    continue;
                }
                sb.append("\u25a0 ");
            }
            sb.append("</p>");
            System.out.println(sb.toString());
        }
        System.out.println("</body></html>");
    }

    public static void main(String[] args) throws Exception {
        String dkwName = args.length > 0 ? args[0] : "dkw2ucs.txt";
        String wordName = args.length > 1 ? args[1] : "dkw-words.txt";
        DKWWords words = new DKWWords(wordName);
        MakeDKWHtml app = new MakeDKWHtml();
        app.loadBushuKana("bushukana.txt");
        app.loadStrokes("ucs-strokes.txt");
        app.loadDKWStrokes("soukaku.txt");
        app.loadJikunSakuin("jikun-sakuin.txt");
        app.load(dkwName);
        app.output(words);
    }

    static /* synthetic */ MultiHashMap access$0(MakeDKWHtml makeDKWHtml) {
        return makeDKWHtml.uni2dkwMap;
    }

    static class BushGroup {
        final MultiTreeMap<Integer, DKWEntry> kanjiList = new MultiTreeMap();

        BushGroup() {
        }

        DKWEntry bushu() {
            return (DKWEntry)this.kanjiList.getList(0).getFirst();
        }

        void add(DKWEntry entry) {
            this.kanjiList.put(entry.bushuKaku, entry);
        }
    }

    /*
     * Exception performing whole class analysis.
     */
    class DKWEntry {
        final String no;
        String page;
        final int bushuNo;
        final int bushuKaku;
        final LinkedList<String> ucsList;
        String duplicateNo;
        String ids;
        String relNo;
        final LinkedList<String> otherUcsList;
        final LinkedList<String> otherInfo;
        final /* synthetic */ MakeDKWHtml this$0;

        /*
         * Unable to fully structure code
         */
        DKWEntry(MakeDKWHtml var1_1, String line) {
            this.this$0 = var1_1;
            super();
            this.ucsList = new LinkedList<E>();
            this.duplicateNo = "";
            this.ids = "";
            this.relNo = "";
            this.otherUcsList = new LinkedList<E>();
            this.otherInfo = new LinkedList<E>();
            v = line.trim().split(" ");
            if (v.length < 4) {
                System.err.println("*** " + line);
                System.exit(1);
            }
            this.no = v[0];
            this.bushuNo = Integer.parseInt(v[1].replaceFirst("DR0*", ""));
            s = v[2].replaceFirst("DS0*", "");
            this.bushuKaku = s.isEmpty() != false ? 0 : (s.equals("??") != false ? 100000 : Integer.parseInt(s));
            this.page = v[3];
            i = 4;
            while (i < v.length) {
                if (!v[i].startsWith("U+")) break;
                MakeDKWHtml.access$0(var1_1).put(v[i], this.no);
                this.ucsList.add(v[i].replaceFirst("U\\+0*", ""));
                ++i;
            }
            if (i == v.length) {
                return;
            }
            if (v[i].startsWith("D")) {
                this.duplicateNo = v[i];
                ++i;
            }
            if (i == v.length) {
                return;
            }
            if (v[i].equals("#")) {
                ++i;
            }
            if (i != v.length) ** GOTO lbl51
            return;
lbl-1000:
            // 1 sources

            {
                if (v[i].startsWith("D")) {
                    this.relNo = v[i];
                } else if (v[i].startsWith("U+")) {
                    this.otherUcsList.add(v[i].replaceFirst("U\\+0*", ""));
                } else if (v[i].startsWith("missing") || v[i].startsWith("removed") || v[i].startsWith("moved") || v[i].startsWith("changed") || v[i].startsWith("added") || v[i].startsWith("replaced")) {
                    this.otherInfo.add(v[i]);
                } else {
                    this.ids = v[i];
                }
                ++i;
lbl51:
                // 2 sources

                ** while (i < v.length)
            }
lbl52:
            // 1 sources

        }

        boolean isBushu() {
            return this.bushuKaku == 0;
        }
    }
}

