/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.daikanwa;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class MakeCharImages {
    private final Font font;
    private final File outDir;
    private static final Pattern UNICODE = Pattern.compile("U\\+0*([0-9A-F]+)");
    private final int WHITE = -1;
    private static final boolean OUTPUT_JIS = true;

    MakeCharImages(String[] args) {
        String fontname = args.length > 0 ? args[0] : "IPA\u660e\u671d";
        int fontsize = args.length > 1 ? Integer.parseInt(args[1]) : 50;
        this.font = new Font(fontname, 0, fontsize);
        this.outDir = new File(args.length > 2 ? args[2] : "i");
    }

    private Integer[] usedUnicode() throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File("dkw2ucs.txt"));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        TreeSet<Integer> set = new TreeSet<Integer>();
        while ((line = br.readLine()) != null) {
            Matcher m = UNICODE.matcher(line);
            while (m.find()) {
                int code = Integer.parseInt(m.group(1), 16);
                set.add(code);
            }
            int i = 0;
            while (i < line.length()) {
                int code = line.codePointAt(i);
                if (code >= 131072) {
                    set.add(code);
                    ++i;
                } else if (code >= 256) {
                    set.add(code);
                }
                ++i;
            }
        }
        br.close();
        System.err.println(String.valueOf(set.size()) + " chars");
        return set.toArray(new Integer[0]);
    }

    private BufferedImage stringToBufferedImage(String s) {
        BufferedImage img = new BufferedImage(1, 1, 12);
        Graphics g = img.getGraphics();
        g.setFont(this.font);
        FontRenderContext frc = g.getFontMetrics().getFontRenderContext();
        Rectangle2D rect = this.font.getStringBounds(s, frc);
        g.dispose();
        if (rect.getWidth() <= 0.0 || rect.getHeight() <= 0.0) {
            return null;
        }
        img = new BufferedImage((int)Math.ceil(rect.getWidth()), (int)Math.ceil(rect.getHeight()), 12);
        g = img.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        g.setColor(Color.black);
        g.setFont(this.font);
        FontMetrics fm = g.getFontMetrics();
        int x = 0;
        int y = fm.getAscent();
        g.drawString(s, x, y);
        g.dispose();
        return img;
    }

    private BufferedImage trim(BufferedImage bim) {
        int newWidth;
        int newHeight;
        int width = bim.getWidth();
        int height = bim.getHeight();
        int minY = 0;
        while (minY < height) {
            if (!this.isWhiteHorizon(bim, minY)) {
                if (minY >= 0) break;
                minY = 0;
                break;
            }
            ++minY;
        }
        int maxY = height - 1;
        while (maxY > minY) {
            if (!this.isWhiteHorizon(bim, maxY)) {
                if (maxY <= height) break;
                maxY = height;
                break;
            }
            --maxY;
        }
        int minX = 0;
        while (minX < width) {
            if (!this.isWhiteVertical(bim, minX)) {
                if (minX >= 0) break;
                minX = 0;
                break;
            }
            ++minX;
        }
        int maxX = width - 1;
        while (maxX > minX) {
            if (!this.isWhiteVertical(bim, maxX)) {
                if (maxX <= width) break;
                maxX = width;
                break;
            }
            --maxX;
        }
        if ((newHeight = maxY - minY) < this.font.getSize()) {
            if ((minY -= (this.font.getSize() - newHeight) / 2) < 0) {
                minY = 0;
            }
            if ((maxY = minY + this.font.getSize()) > bim.getHeight()) {
                maxY = bim.getHeight();
            }
        }
        if ((newWidth = maxX - minX) < this.font.getSize()) {
            if ((minX -= (this.font.getSize() - newWidth) / 2) < 0) {
                minX = 0;
            }
            if ((maxX = minX + this.font.getSize()) > bim.getWidth()) {
                maxX = bim.getWidth();
            }
        }
        return bim.getSubimage(minX, minY, maxX - minX, maxY - minY);
    }

    private boolean isWhiteHorizon(BufferedImage bim, int y) {
        int width = bim.getWidth();
        int x = 0;
        while (x < width) {
            if (bim.getRGB(x, y) != -1) {
                return false;
            }
            ++x;
        }
        return true;
    }

    private boolean isWhiteVertical(BufferedImage bim, int x) {
        int height = bim.getHeight();
        int y = 0;
        while (y < height) {
            if (bim.getRGB(x, y) != -1) {
                return false;
            }
            ++y;
        }
        return true;
    }

    private void output() throws Exception {
        this.outDir.mkdirs();
        Integer[] usedCodes = this.usedUnicode();
        int n = 0;
        int[] value = new int[1];
        Integer[] integerArray = usedCodes;
        int n2 = usedCodes.length;
        int n3 = 0;
        while (n3 < n2) {
            Integer code = integerArray[n3];
            if (this.font.canDisplay(code)) {
                value[0] = code;
                String s = new String(value, 0, 1);
                code.intValue();
                BufferedImage img = this.stringToBufferedImage(s);
                if (img != null) {
                    File outFile = new File(this.outDir, String.format("%05X.bmp", code));
                    if (!outFile.exists()) {
                        ImageIO.write((RenderedImage)this.trim(img), "bmp", outFile);
                        if (++n % 1000 == 0) {
                            System.out.print(String.valueOf(n) + " ");
                        }
                    }
                }
            }
            ++n3;
        }
        System.out.println();
        System.out.println(n);
    }

    public static void main(String[] args) throws Exception {
        MakeCharImages app = new MakeCharImages(args);
        app.output();
    }
}

