/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.daikanwa;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import zephyr.taishukan.daikanwa.Jukugo;
import zephyr.util.MultiHashMap;

public class DKWWords {
    private final MultiHashMap<String, Jukugo> jukugoMap = new MultiHashMap();

    DKWWords(String filename) throws Exception {
        this.load(filename);
    }

    private void load(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            Jukugo jukugo = new Jukugo(line);
            this.jukugoMap.put(jukugo.dwNo, jukugo);
        }
        br.close();
    }

    LinkedList<Jukugo> getJukugo(String dwNo) {
        return this.jukugoMap.getWithoutNull(dwNo);
    }
}

