/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.royalfrjp;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.obunsha.util.PDFIndex;
import zephyr.obunsha.util.RefEntry;

public class RoyalPDFRef
extends PDFIndex {
    private final HashMap<Integer, String> page2entMap = new HashMap();
    private static final Pattern APPENDIX = Pattern.compile("\\.pdf','APPENDIX'\\)\">p.([0-9]+)[^<>]+");

    @Override
    public void handleLine(String prefix, RefEntry entry) {
        int page = entry.start;
        int i = 0;
        while (page <= entry.end) {
            this.page2entMap.put(page, entry.jpgs[i]);
            ++page;
            ++i;
        }
    }

    private void appendRef(StringBuilder sb, int page) {
        String jpg = this.page2entMap.get(page);
        if (jpg != null) {
            sb.append(" <jpgref id=\"");
            sb.append(jpg);
            sb.append("\"/>");
        } else {
            System.err.println("\u30da\u30fc\u30b8\u756a\u53f7\u4e0d\u6b63\uff1a" + page);
        }
    }

    private String handleRef(String dd) {
        Matcher m = APPENDIX.matcher(dd);
        StringBuilder sb = null;
        int idx = 0;
        while (m.find()) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(dd.substring(idx, m.end()));
            int page = Integer.parseInt(m.group(1));
            if (page == 732 || page == 733) {
                this.appendRef(sb, 732);
                this.appendRef(sb, 733);
            } else {
                this.appendRef(sb, page);
            }
            idx = m.end();
        }
        if (sb == null) {
            return dd;
        }
        if (idx < dd.length()) {
            sb.append(dd.substring(idx));
        }
        return sb.toString();
    }

    String makeRef(String dd) {
        dd = this.handleRef(dd);
        return dd;
    }
}

