/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.petitroyal;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.HashMap;
import javax.imageio.ImageIO;
import zephyr.util.PDF2Jpeg;

public class PrefacePDF2Jpeg
extends PDF2Jpeg {
    private static final HashMap<String, String[]> DIV_MAP = new HashMap();

    static {
        DIV_MAP.put("preface-1.jpg", new String[]{"preface-1.jpg"});
        DIV_MAP.put("preface-2.jpg", new String[]{"preface-2.jpg", "usage-1.jpg"});
        DIV_MAP.put("preface-3.jpg", new String[]{"usage-2.jpg", "usage-3.jpg"});
        DIV_MAP.put("preface-4.jpg", new String[]{"usage-4.jpg"});
    }

    @Override
    protected void write(BufferedImage bim, String type, File outputfile) throws Exception {
        String orgname = outputfile.getName();
        String[] newnames = DIV_MAP.get(orgname);
        if (newnames == null) {
            ImageIO.write((RenderedImage)bim, this.OUTPUT_TYPE, outputfile);
            System.out.print(String.valueOf(outputfile.getName()) + " ");
        } else if (newnames.length == 1) {
            ImageIO.write((RenderedImage)bim, this.OUTPUT_TYPE, new File(outputfile.getParentFile(), newnames[0]));
            System.out.print(String.valueOf(newnames[0]) + " ");
        } else if (newnames.length > 1) {
            int partWidth = bim.getWidth() / newnames.length;
            int start = 0;
            int i = 0;
            while (i < newnames.length) {
                int w = partWidth;
                if (start + w > bim.getWidth()) {
                    w = bim.getWidth() - start;
                }
                BufferedImage partBim = bim.getSubimage(start, 0, w, bim.getHeight());
                partBim = this.trim(partBim);
                ImageIO.write((RenderedImage)partBim, this.OUTPUT_TYPE, new File(outputfile.getParentFile(), newnames[i]));
                System.out.print(String.valueOf(newnames[i]) + " ");
                ++i;
                start += partWidth;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: java PrefacePDF2Jpeg sample.pdf outDir [dpi] [startIdx] [outputPrefix]");
            return;
        }
        String pdfname = args[0];
        String outDir = args[1];
        int dpi = args.length > 2 ? Integer.parseInt(args[2]) : 200;
        int startIdx = args.length > 3 ? Integer.parseInt(args[3]) : -1;
        String outPrefix = args.length > 4 ? args[4] : null;
        PrefacePDF2Jpeg app = new PrefacePDF2Jpeg();
        app.convert(pdfname, outDir, outPrefix, startIdx, dpi);
    }
}

