/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.readers3;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;

public class ExtraKeys {
    private final HashMap<String, String> keyMap = new HashMap();

    public ExtraKeys(String filename) throws Exception {
        this.load(filename);
    }

    private String key(String dt, String post) {
        return String.valueOf(dt) + "###" + post;
    }

    private void load(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
            String[] v = line.split("\t");
            if (v.length < 3) {
                this.keyMap.put(this.key(v[0], v[1]), "");
                continue;
            }
            if (v.length > 3) {
                int i = 3;
                while (i < v.length) {
                    v[2] = String.valueOf(v[2]) + "\t" + v[i];
                    ++i;
                }
            }
            this.keyMap.put(this.key(v[0], v[1]), v[2]);
        }
        br.close();
        System.err.println("load " + this.keyMap.size() + " extra keys from " + filename);
    }

    public String[] keys(String dt, String post) {
        String v = this.keyMap.get(this.key(dt, post));
        if (v != null) {
            return v.split("\t");
        }
        return null;
    }
}

