/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kagakudoujin.kagakueigo;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import zephyr.kagakudoujin.kagakueigo.EntryData;

public class Util {
    public static final byte[] DELIM_ENTRY = new byte[]{1, 7, 5};
    public static final byte[] DELIM_K_ENTRY = new byte[]{1, 7, 4};
    public static final byte[] DELIM_VALUE = new byte[2];
    public static final byte[] DELIM_02 = new byte[]{2, 6};
    public static final byte[] DELIM_03 = new byte[]{3, 6};
    public static final byte[] DELIM_04 = new byte[]{4, 6};
    public static final byte[] DELIM_05 = new byte[]{5, 6};
    public static final byte[] DELIM_06 = new byte[]{6, 6};
    public static final byte[] DELIM_07 = new byte[]{7, 6};
    public static final byte[] DELIM_ENG_TRANS;
    public static final byte[] DELIM_EN_WORDS;
    public static final byte[] DELIM_JP_WORDS;
    public static final byte[] DELIM_REL_WORDS;

    static {
        byte[] byArray = new byte[4];
        byArray[2] = 6;
        byArray[3] = 6;
        DELIM_ENG_TRANS = byArray;
        DELIM_EN_WORDS = new byte[]{6, -1};
        DELIM_JP_WORDS = new byte[]{7, -1};
        DELIM_REL_WORDS = new byte[]{8, 6};
    }

    public static int findData(byte[] buffer, int start, int length, byte[] data) {
        int index = start;
        int last = length - data.length;
        while (index < last) {
            boolean bMatch = true;
            int i = 0;
            while (i < data.length) {
                if (data[i] != buffer[index + i]) {
                    bMatch = false;
                    break;
                }
                ++i;
            }
            if (bMatch) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static String getString(byte[] buffer, int start, int end) {
        byte[] data = Arrays.copyOfRange(buffer, start, end);
        try {
            return new String(data, "Windows-31J");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    public static EntryData getData(byte[] buffer, byte[] delim, int start) {
        int index = Util.findData(buffer, start, buffer.length, delim);
        if (index < 0) {
            return null;
        }
        byte len = buffer[index + delim.length];
        if (len <= 0) {
            return null;
        }
        start = index + delim.length + 1;
        int end = start + len;
        if (end > buffer.length) {
            return null;
        }
        return new EntryData(Util.getString(buffer, start, end), end);
    }

    public static String[] getDataList(byte[] buffer, byte[] delim, int start) {
        int index = Util.findData(buffer, start, buffer.length, delim);
        if (index < 0) {
            return null;
        }
        int n = buffer[index += delim.length];
        if (n <= 0) {
            return null;
        }
        String[] result = new String[n];
        start = index + 4;
        int i = 0;
        while (i < n) {
            byte len = buffer[start];
            int end = ++start + len;
            result[i] = Util.getString(buffer, start, end);
            start = end + 1;
            ++i;
        }
        return result;
    }

    public static String normalize(String txt) {
        txt = txt.replaceAll("\u25b2(.+?)\u25b2", "<sup>$1</sup>");
        txt = txt.replaceAll("\u25bc(.+?)\u25bc", "<sub>$1</sub>");
        txt = txt.replaceAll("<S>(.+?)</S>", "$1");
        txt = txt.replace("FT>", "B>");
        txt = txt.replaceAll("</?[RK]>", "");
        return txt;
    }
}

