/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kagakudoujin.kagakueigo;

import java.io.File;
import java.util.LinkedList;
import zephyr.kagakudoujin.kagakueigo.EntryData;
import zephyr.kagakudoujin.kagakueigo.FileLoader;
import zephyr.kagakudoujin.kagakueigo.Gaiji;
import zephyr.kagakudoujin.kagakueigo.Util;
import zephyr.kagakudoujin.kagakueigo2.Util2;
import zephyr.util.ZephyrUtil;

public class MakeEJHtml {
    private boolean makeJPkey = false;
    private boolean withWav = false;

    MakeEJHtml(String[] args) {
        int i = 1;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals("jpenkey")) {
                this.makeJPkey = true;
            } else if (arg.equals("wav")) {
                this.withWav = true;
            }
            ++i;
        }
    }

    private void parse(byte[] entry) {
        EntryData en = Util.getData(entry, Util.DELIM_03, 0);
        EntryData jp = Util.getData(entry, Util.DELIM_04, en.nextIndex);
        EntryData wavNo = Util.getData(entry, Util.DELIM_06, jp.nextIndex);
        EntryData hasWav = Util.getData(entry, Util.DELIM_07, jp.nextIndex);
        StringBuilder sb = new StringBuilder();
        sb.append("<dt>");
        sb.append(en.txt);
        sb.append("</dt>");
        sb.append(Util2.makeENKeys(en.txt));
        if (this.makeJPkey) {
            sb.append(Util2.makeKeys(jp.txt, en.txt));
        }
        sb.append("<dd>");
        if (wavNo != null && hasWav != null && this.withWav) {
            sb.append("<a href=\"voice/");
            sb.append(wavNo.txt);
            sb.append(".WAV\">\u767a\u97f3</a>");
        }
        sb.append("<p>");
        sb.append(jp.txt);
        sb.append("</p></dd>");
        String txt = sb.toString();
        txt = Util.normalize(txt);
        txt = Gaiji.convert(txt);
        System.out.println(txt);
    }

    private void load(File file) throws Exception {
        LinkedList<byte[]> entries = FileLoader.load(file, Util.DELIM_ENTRY);
        System.out.println("<html><body>");
        for (byte[] entry : entries) {
            this.parse(entry);
        }
        System.out.println("</body></html>");
    }

    public static void main(String[] args) throws Exception {
        String filename = args.length > 0 ? args[0] : "Dict\\yougosyu\\DBSite\\DATA\\@f02001.dat";
        MakeEJHtml app = new MakeEJHtml(args);
        File file = new File(filename);
        System.err.println(String.valueOf(file.getAbsolutePath()) + " \u304b\u3089\u53d6\u308a\u8fbc\u307f\u307e\u3059");
        ZephyrUtil.setShiftJisOuput();
        app.load(file);
    }
}

