/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.readers3;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import zephyr.kenkyusha.readers3.IrregularVerbs;
import zephyr.util.MultiHashMap;

public class Lemmatizer {
    private static final HashMap<String, String> postsMap = new LinkedHashMap<String, String>();
    private static final HashSet<String> lemmaSet;
    private static final String WORDNET_LEMMA_FILENAME = "wordnet-lemma.txt";
    private static final MultiHashMap<String, String> excMap;
    private static final String WORDNET_EXC_FILENAME = "wordnet-exc.txt";

    private static void loadLemma(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((string2 = bufferedReader.readLine()) != null) {
            String string3 = string2.replace('_', ' ');
            lemmaSet.add(string3);
        }
        bufferedReader.close();
        System.err.println("load " + lemmaSet.size() + " entries from " + string);
    }

    private static void loadExc(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray = string2.split(" ");
            if (stringArray.length != 2) continue;
            excMap.putUniq(stringArray[0], stringArray[1]);
        }
        bufferedReader.close();
        System.err.println("load " + excMap.size() + " entries from " + string);
    }

    private static LinkedList<String> makeWordList(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string);
        return linkedList;
    }

    public static LinkedList<String> lemma(String string) {
        LinkedList<String> linkedList = excMap.getList(string = string.toLowerCase());
        if (linkedList != null) {
            return linkedList;
        }
        for (Map.Entry<String, String> entry : postsMap.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            if (!string.endsWith(string2)) continue;
            String string4 = string.substring(0, string.length() - string2.length()) + string3;
            linkedList = excMap.getList(string4);
            if (linkedList != null) {
                return linkedList;
            }
            if (!lemmaSet.contains(string4)) continue;
            return Lemmatizer.makeWordList(string4);
        }
        return Lemmatizer.makeWordList(string);
    }

    private static void test(String string) {
        System.out.println(string + "\t" + Lemmatizer.lemma(string));
    }

    public static void main(String[] stringArray) throws Exception {
        Lemmatizer.test("drunken");
        Lemmatizer.test("walking");
        Lemmatizer.test("walk");
        Lemmatizer.test("cat");
        Lemmatizer.test("cats");
        Lemmatizer.test("Cats");
        Lemmatizer.test("best");
        Lemmatizer.test("gone");
        Lemmatizer.test("fast");
        Lemmatizer.test("faster");
        Lemmatizer.test("mentioned");
        Lemmatizer.test("mention");
        Lemmatizer.test("drink");
        Lemmatizer.test("drinks");
        Lemmatizer.test("drunk");
        Lemmatizer.test("drinking");
        Lemmatizer.test("good");
        Lemmatizer.test("better");
        Lemmatizer.test("best");
    }

    static {
        postsMap.put("s", "");
        postsMap.put("ses", "s");
        postsMap.put("ves", "f");
        postsMap.put("xes", "x");
        postsMap.put("zes", "z");
        postsMap.put("ches", "ch");
        postsMap.put("shes", "sh");
        postsMap.put("men", "man");
        postsMap.put("ies", "y");
        postsMap.put("s", "");
        postsMap.put("ies", "y");
        postsMap.put("es", "e");
        postsMap.put("es", "");
        postsMap.put("ed", "e");
        postsMap.put("ed", "");
        postsMap.put("ing", "e");
        postsMap.put("ing", "");
        postsMap.put("er", "");
        postsMap.put("est", "");
        postsMap.put("er", "e");
        postsMap.put("est", "e");
        lemmaSet = new HashSet();
        excMap = new MultiHashMap();
        try {
            Lemmatizer.loadLemma(WORDNET_LEMMA_FILENAME);
        }
        catch (Exception exception) {
            System.err.println("cannot load wordnet-lemma.txt");
        }
        try {
            Lemmatizer.loadExc(WORDNET_EXC_FILENAME);
        }
        catch (Exception exception) {
            System.err.println("cannot load wordnet-exc.txt");
        }
        int n = excMap.size();
        for (String[] stringArray : IrregularVerbs.TABLE) {
            String string = stringArray[0];
            for (int i = 1; i <= 2; ++i) {
                for (String string2 : stringArray[i].split("[^a-z]+")) {
                    if (string2.isEmpty()) continue;
                    excMap.putUniq(string2, string);
                }
            }
        }
        System.err.println(n + " -> " + excMap.size());
    }
}

