/*
 * Decompiled with CFR 0.152.
 */
package zephyr.iwanami.koujien;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.iwanami.koujien.DicBody;
import zephyr.iwanami.koujien.Util;
import zephyr.util.Counter;
import zephyr.util.DiffUtil;
import zephyr.util.EBWinMap;
import zephyr.util.MultiTreeMap;

public class MergeBody {
    private final DicBody koujien5;
    private final DicBody koujien6;
    private final EBWinMap gaijiMap;
    private static final Pattern A_HREF = Pattern.compile("<a href=\"(.+?)\">(.+?)</a>");
    private static final char A_START = '\ue000';
    private static final char A_END = '\ue001';
    private static final char SUB_START = '\ue002';
    private static final char SUB_END = '\ue003';
    private static final char SUP_START = '\ue004';
    private static final char SUP_END = '\ue005';
    private static final char BR = '\ue006';
    private static final char B_START = '\ue007';
    private static final char B_END = '\ue008';
    private final LinkedList<String> arefList = new LinkedList();
    private static final Pattern SUB = Pattern.compile("<sub>(.+?)</sub>");
    private static final Pattern KANADIFF = Pattern.compile("<b>\\{</b>5 [\u3042\u3044\u3046\u3048\u304a\u3064\u3084\u3086\u3088\u308f]<b>\\}</b><b>\\{</b>6 ([\u3041\u3043\u3045\u3047\u3049\u3063\u3083\u3085\u3087\u308e])<b>\\}</b>");
    private int kan56fix = 0;
    private int nSub = 0;
    private static final Pattern DIFF56 = Pattern.compile("<b>\\{</b>([56][+\\-]?) (.+?)<b>\\}</b>");
    private int diff6drop = 0;
    private int diff6add = 0;
    private int diff56change = 0;
    private int[] diffcnt = new int[2];
    private static final Pattern KANJI_KANA = Pattern.compile("[\\u3400-\\u9F00]<b>\\{</b>6[\\+\\-] [\u3041-\u3093]<b>\\}</b>[\u3041-\u3093]{1,2}");
    private final Counter<String> kanjiKanaCounter = new Counter();
    private int kanjiKanaAdd = 0;
    private static final Pattern BR_HREF_ADD = Pattern.compile("<b>\\{</b>6\\+ <br><a[^>]+>.+?</a><b>\\}</b>");
    private int brHrefAdd = 0;
    private int nHanZen = 0;
    private int nZenHan = 0;
    private final DiffUtil diff = new DiffUtil();
    private int ndd = 0;
    private int nddchanged = 0;
    private int nhitotsu = 0;
    private int nbar5 = 0;
    private int nbar6 = 0;

    public MergeBody() throws Exception {
        this.koujien5 = new DicBody("koujien5.html");
        this.koujien6 = new DicBody("koujien6.html");
        this.gaijiMap = new EBWinMap("KOJIEN-gaiji.txt");
    }

    private int findLemmaIdx(String string, ArrayList<String> arrayList, int n) {
        String string2 = arrayList.get(n);
        if (string2.equals(string)) {
            return n;
        }
        for (int i = 1; i < 1000; ++i) {
            int n2 = n + i;
            if (n2 < arrayList.size() && arrayList.get(n2).equals(string)) {
                return n2;
            }
            n2 = n - i;
            if (0 > n2 || !arrayList.get(n2).equals(string)) continue;
            return n2;
        }
        System.err.println("cannot find " + string + ", idx=" + n);
        return n;
    }

    private String normKana(String string) {
        return string.replace("\u2010", "");
    }

    private String normHyoki(String string) {
        if (string != null && string.startsWith("\u25cb")) {
            return string.substring(1);
        }
        return string;
    }

    private String dropKana(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '\u3041' && '\u30fe' >= c) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private String kanaDiff(String string, String string2, String string3) {
        if (string2.length() != string3.length()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string2.length(); ++i) {
            int n;
            char c;
            char c2 = string2.charAt(i);
            if (c2 == (c = string3.charAt(i))) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            if ((n = c2 - c) == 96) {
                stringBuilder.append(String.format("\u7247%c\u2192\u5e73%c", Character.valueOf(c2), Character.valueOf(c)));
                continue;
            }
            if (-n == 96) {
                stringBuilder.append(String.format("\u5e73%c\u2192\u7247%c", Character.valueOf(c2), Character.valueOf(c)));
                continue;
            }
            stringBuilder.append(String.format("%c(x%X)\u2192%c(x%X)", Character.valueOf(c2), (int)c2, Character.valueOf(c), (int)c));
        }
        if (string.matches("[\\x00-\\x7F]+")) {
            stringBuilder.append("\n\t\t##eng. " + string + " " + string2 + "\u2192" + string3 + " [" + stringBuilder.toString() + "]");
        }
        return stringBuilder.toString();
    }

    private String prepareDiff(String string) {
        this.arefList.clear();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < string.length()) {
            String string2 = string.substring(n);
            if (string2.startsWith("&#x")) {
                int n2 = Integer.parseInt(string.substring(n + 3, n + 7), 16);
                stringBuilder.append((char)n2);
                n += 8;
                continue;
            }
            if (string2.startsWith("<a ")) {
                Matcher matcher = A_HREF.matcher(string2);
                matcher.find();
                this.arefList.add(matcher.group(1));
                stringBuilder.append('\ue000');
                stringBuilder.append(matcher.group(2));
                stringBuilder.append('\ue001');
                n += matcher.end();
                continue;
            }
            if (string2.startsWith("<su")) {
                if (string.charAt(n + 3) == 'b') {
                    stringBuilder.append('\ue002');
                } else {
                    stringBuilder.append('\ue004');
                }
                n += 5;
                continue;
            }
            if (string2.startsWith("</su")) {
                if (string.charAt(n + 4) == 'b') {
                    stringBuilder.append('\ue003');
                } else {
                    stringBuilder.append('\ue005');
                }
                n += 6;
                continue;
            }
            if (string2.startsWith("<br>")) {
                stringBuilder.append('\ue006');
                n += 4;
                continue;
            }
            if (string2.startsWith("<b>")) {
                stringBuilder.append('\ue007');
                n += 3;
                continue;
            }
            if (string2.startsWith("</b>")) {
                stringBuilder.append('\ue008');
                n += 4;
                continue;
            }
            stringBuilder.append(string.charAt(n));
            ++n;
        }
        return stringBuilder.toString();
    }

    private String afterDiff(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block11: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\ue000': {
                    stringBuilder.append("<a href=\"");
                    stringBuilder.append(this.arefList.poll());
                    stringBuilder.append("\">");
                    continue block11;
                }
                case '\ue001': {
                    stringBuilder.append("</a>");
                    continue block11;
                }
                case '\ue002': {
                    stringBuilder.append("<sub>");
                    continue block11;
                }
                case '\ue003': {
                    stringBuilder.append("</sub>");
                    continue block11;
                }
                case '\ue004': {
                    stringBuilder.append("<sup>");
                    continue block11;
                }
                case '\ue005': {
                    stringBuilder.append("</sup>");
                    continue block11;
                }
                case '\ue006': {
                    stringBuilder.append("<br>");
                    continue block11;
                }
                case '\ue007': {
                    stringBuilder.append("<b>");
                    continue block11;
                }
                case '\ue008': {
                    stringBuilder.append("</b>");
                    continue block11;
                }
                default: {
                    if ('\ua000' <= c && c <= '\uf5ff') {
                        stringBuilder.append(String.format("&#x%X;", c));
                        continue block11;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private void fixKanaDiff1(StringBuilder stringBuilder, String string) {
        int n = 0;
        Matcher matcher = KANADIFF.matcher(string);
        while (matcher.find()) {
            if (n < matcher.start()) {
                stringBuilder.append(string.substring(n, matcher.start()));
            }
            stringBuilder.append(matcher.group(1));
            n = matcher.end();
            ++this.kan56fix;
        }
        if (n < string.length()) {
            stringBuilder.append(string.substring(n));
        }
    }

    private String dropDiffInSub(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        Matcher matcher = SUB.matcher(string);
        while (matcher.find()) {
            if (n < matcher.start(1)) {
                stringBuilder.append(string.substring(n, matcher.start(1)));
            }
            this.fixKanaDiff1(stringBuilder, matcher.group(1));
            n = matcher.end(1);
            ++this.nSub;
        }
        if (n < string.length()) {
            stringBuilder.append(string.substring(n));
        }
        return stringBuilder.toString();
    }

    private int[] diffCount(String string) {
        Matcher matcher = DIFF56.matcher(string);
        int n = 0;
        int n2 = 0;
        while (matcher.find()) {
            switch (matcher.group(1)) {
                case "6-": {
                    ++this.diff6drop;
                    ++n;
                    break;
                }
                case "6+": {
                    ++this.diff6add;
                    ++n;
                    break;
                }
                case "6": {
                    ++this.diff56change;
                    ++n;
                }
            }
            n2 += matcher.group(2).length();
        }
        this.diffcnt[0] = n;
        this.diffcnt[1] = n2;
        return this.diffcnt;
    }

    private int lineCount(String string) {
        string = string.replaceAll("<br>[&#x0-9A-F;]*<a [^>]+>.+?</a>", "");
        return string.split("<br>").length;
    }

    private int diffLineCount(String string, String string2) {
        return this.lineCount(string2) - this.lineCount(string);
    }

    private void kanjiKanaAddCount(String string) {
        Matcher matcher = KANJI_KANA.matcher(string);
        while (matcher.find()) {
            this.kanjiKanaCounter.add(matcher.group());
            ++this.kanjiKanaAdd;
        }
    }

    private void brHrefAddCount(String string) {
        Matcher matcher = BR_HREF_ADD.matcher(string);
        while (matcher.find()) {
            ++this.brHrefAdd;
        }
    }

    private String diffDD(String string, String string2) {
        Object object3;
        Object object2;
        ++this.ndd;
        if (string.equals(string2)) {
            return string;
        }
        String string3 = this.prepareDiff(string);
        String string4 = this.prepareDiff(string2);
        LinkedList<DiffUtil.Diff> linkedList = this.diff.diff_main(string3, string4);
        int n = 0;
        DiffUtil.Diff diff = null;
        while (n < linkedList.size()) {
            DiffUtil.Diff diff2 = linkedList.get(n);
            if (diff2.text.trim().isEmpty()) {
                linkedList.remove(n);
                continue;
            }
            if (diff2.text.equals("\u3064") && diff2.operation == DiffUtil.Operation.INSERT && n > 0 && diff.text.endsWith("\u4e00") && diff.operation == DiffUtil.Operation.EQUAL) {
                diff2.operation = DiffUtil.Operation.EQUAL;
                ++this.nhitotsu;
                ++n;
                continue;
            }
            if (diff2.operation == DiffUtil.Operation.INSERT && diff != null && diff.operation == DiffUtil.Operation.DELETE) {
                if (diff2.text.matches("[0-9]+") && diff2.text.length() == diff.text.length()) {
                    linkedList.remove(n - 1);
                    diff2.operation = DiffUtil.Operation.EQUAL;
                    continue;
                }
                if (diff.text.matches("[0-9]+") && diff2.text.length() == diff.text.length()) {
                    linkedList.remove(n - 1);
                    diff2.operation = DiffUtil.Operation.EQUAL;
                    continue;
                }
                if (diff2.text.matches("[\\- -~\u30ab]") && diff.text.matches("[\u2010\\uFF00-\\uFF5E\u30f5]")) {
                    linkedList.remove(n - 1);
                    diff2.operation = DiffUtil.Operation.EQUAL;
                    ++this.nHanZen;
                    continue;
                }
                if (diff.text.matches("[\\- -~]") && diff2.text.matches("[\u2010\\uFF00-\\uFF5E]")) {
                    linkedList.remove(n - 1);
                    diff2.operation = DiffUtil.Operation.EQUAL;
                    ++this.nZenHan;
                    continue;
                }
                if (diff2.text.matches("[\\uA000-\\uF5FF]") && diff.text.matches("[\\uA000-\\uF5FF]")) {
                    object2 = this.gaijiMap.replace(String.format("%04X", diff.text.charAt(0)));
                    object3 = this.gaijiMap.replace(String.format("%04X", diff2.text.charAt(0)));
                    if (object2 != null && ((String)object2).equals(object3)) {
                        linkedList.remove(n - 1);
                        diff2.operation = DiffUtil.Operation.EQUAL;
                        continue;
                    }
                }
                if (diff.text.equals("\u2015")) {
                    linkedList.remove(n - 1);
                    diff2.operation = DiffUtil.Operation.EQUAL;
                    ++this.nbar5;
                    continue;
                }
                if (diff2.text.equals("\u2015")) {
                    linkedList.remove(n);
                    diff.operation = DiffUtil.Operation.EQUAL;
                    ++this.nbar6;
                    continue;
                }
            }
            diff = diff2;
            ++n;
        }
        boolean bl = true;
        for (Object object3 : linkedList) {
            if (object3.operation == DiffUtil.Operation.EQUAL) continue;
            bl = false;
            break;
        }
        if (bl) {
            return string2;
        }
        object2 = new StringBuilder();
        object3 = null;
        for (int i = 0; i < linkedList.size(); ++i) {
            DiffUtil.Diff diff3 = linkedList.get(i);
            switch (diff3.operation) {
                case EQUAL: {
                    ((StringBuilder)object2).append(diff3.text);
                    break;
                }
                case DELETE: {
                    DiffUtil.Operation operation;
                    DiffUtil.Operation operation2 = operation = i < linkedList.size() - 1 ? linkedList.get((int)(i + 1)).operation : null;
                    if (operation == DiffUtil.Operation.INSERT) {
                        ((StringBuilder)object2).append("<b>{</b>5 ");
                    } else {
                        ((StringBuilder)object2).append("<b>{</b>6- ");
                    }
                    ((StringBuilder)object2).append(diff3.text);
                    ((StringBuilder)object2).append("<b>}</b>");
                    break;
                }
                case INSERT: {
                    if (object3 == DiffUtil.Operation.DELETE) {
                        ((StringBuilder)object2).append("<b>{</b>6 ");
                    } else {
                        ((StringBuilder)object2).append("<b>{</b>6+ ");
                    }
                    ((StringBuilder)object2).append(diff3.text);
                    ((StringBuilder)object2).append("<b>}</b>");
                }
            }
            object3 = diff3.operation;
        }
        String string5 = this.afterDiff(((StringBuilder)object2).toString());
        string5 = this.dropDiffInSub(string5);
        this.kanjiKanaAddCount(string5);
        this.brHrefAddCount(string5);
        return string5;
    }

    private int normlen(String string) {
        return string.replaceAll("<[^>]+>", "").length();
    }

    private void dumpKanjiKanaMap() {
        HashMap<String, Integer> hashMap = this.kanjiKanaCounter.map();
        MultiTreeMap<Integer, String> multiTreeMap = this.kanjiKanaCounter.sort();
        Counter<Character> counter = new Counter<Character>();
        for (String object : hashMap.keySet()) {
            counter.add(Character.valueOf(object.charAt(0)));
        }
        MultiTreeMap multiTreeMap2 = counter.sort();
        for (Integer n : multiTreeMap2.keySet()) {
            LinkedList linkedList = multiTreeMap2.getList(n);
            char c = ' ';
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Integer n2;
                char c2 = ((Character)iterator.next()).charValue();
                Iterator iterator2 = multiTreeMap.keySet().iterator();
                while (iterator2.hasNext() && (n2 = (Integer)iterator2.next()) >= 10) {
                    LinkedList linkedList2 = multiTreeMap.getList(n2);
                    for (String string : linkedList2) {
                        if (string.charAt(0) != c2 || c == c2) continue;
                        System.err.println(c2);
                        c = c2;
                        System.err.println("\t" + n2 + "\t" + string.replaceAll("<[^>]+>", ""));
                    }
                }
            }
        }
    }

    private void merge() throws IOException {
        System.out.println("<html><body>");
        ArrayList<String> arrayList = this.koujien5.getLemmas();
        ArrayList<String> arrayList2 = this.koujien6.getLemmas();
        ArrayList<String> arrayList3 = this.koujien5.getDD();
        ArrayList<String> arrayList4 = this.koujien6.getDD();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        HashSet<int[]> hashSet = new HashSet<int[]>();
        while (n < arrayList.size() && n2 < arrayList2.size()) {
            Object object;
            String string;
            String string2;
            Object object2;
            String string3 = arrayList.get(n);
            String string4 = arrayList2.get(n2);
            ++n3;
            if (!this.koujien6.hasLemma(string3)) {
                object2 = new Util.Lemma(string3);
                if (((Util.Lemma)object2).hyoki != null && ((Util.Lemma)object2).hyoki.startsWith("\u25cb") && (string2 = this.koujien6.getKana(string = ((Util.Lemma)object2).hyoki.substring(1))) != null) {
                    object = string2 + "\u3010" + string + "\u3011";
                    System.out.println("<dt>" + string3 + "</dt><dd><p>\u21926 " + (String)object + "</p><p>[5] " + arrayList3.get(n) + "</p></dd>");
                    hashSet.add((int[])object);
                    ++n;
                    continue;
                }
                if (this.koujien6.getHyoki(((Util.Lemma)object2).kana) == null && this.koujien6.getKana(((Util.Lemma)object2).hyoki) == null) {
                    System.out.println("<dt title=\"" + string3 + " \u25bc6\u7248\u524a\u9664\">" + string3 + "</dt><dd><p><b>6\u7248\u524a\u9664</b></p><p>" + arrayList3.get(n) + "</p></dd>");
                    ++n4;
                }
                ++n;
                continue;
            }
            if (!this.koujien5.hasLemma(string4)) {
                object2 = new Util.Lemma(string4);
                string = this.koujien5.getHyoki(((Util.Lemma)object2).kana);
                if (string != null) {
                    if (this.koujien6.getHyoki(((Util.Lemma)object2).kana) != null) {
                        System.out.println("<dt>" + string4 + "</dt><dd><p>" + string4 + "\u21905\u3010" + string + "\u3011</p><p>[6] " + arrayList4.get(n2) + "</p></dd>");
                    } else {
                        System.out.println("<dt title=\"" + string4 + " - 6\u7248\u8ffd\u52a0?\">" + string4 + "</dt><dd><p><b>6\u7248\u8ffd\u52a0?</b></p><p>" + arrayList4.get(n2) + "</p></dd>");
                    }
                } else {
                    string = this.koujien5.getKana(((Util.Lemma)object2).hyoki);
                    if (string != null) {
                        if (this.normKana(string).equals(this.normKana(((Util.Lemma)object2).kana))) {
                            System.out.println("<dt>" + string4 + "</dt><dd><p>\u21905\uff08" + string + "\uff09</p><p>[6] " + arrayList4.get(n2) + "</p></dd>");
                        } else {
                            System.out.println("<dt>" + string4 + "</dt><dd><p>\u21905\uff08" + string + "\uff09" + this.kanaDiff(((Util.Lemma)object2).hyoki, string, ((Util.Lemma)object2).kana) + "</p><p>[6] " + arrayList4.get(n2) + "</p></dd>");
                        }
                    } else if (!hashSet.contains(string4)) {
                        System.out.println("<dt title=\"" + string4 + " \u26056\u7248\u8ffd\u52a0\">" + string4 + "</dt><dd><p><b>6\u7248\u8ffd\u52a0</b></p><p>" + arrayList4.get(n2) + "</p></dd>");
                    }
                }
                ++n5;
                ++n2;
                continue;
            }
            object2 = arrayList3.get(n = this.findLemmaIdx(string4, arrayList, n));
            string2 = this.diffDD((String)object2, string = arrayList4.get(n2));
            object = this.diffCount(string2);
            if (object[0] > 0) {
                ++this.nddchanged;
                System.out.print("<dt>" + string4 + " *" + object[0]);
            } else {
                System.out.print("<dt>" + string4);
            }
            int n6 = this.diffLineCount((String)object2, string);
            if (n6 > 0) {
                System.out.print(" L+" + n6);
            } else if (n6 < 0) {
                System.out.print(" L" + n6);
            }
            System.out.print("</dt><dd>");
            int n7 = this.normlen((String)object2);
            int n8 = this.normlen(string);
            if (object[0] > 3 && 100 * object[1] / this.normlen(string) > 50) {
                System.out.println("<p>" + string2 + "</p>");
                System.out.println("<p>- - - - - -</p>");
                System.out.println("<p>[5] " + (String)object2 + "</p>");
                System.out.println("<p>[6] " + string + "</p></dd>");
            } else if (n7 > 100 && n7 > 2 * n8 || n8 > 100 && n8 > 2 * n7) {
                System.out.println("<p>[5] " + (String)object2 + "</p>");
                System.out.println("<p>[6] " + string + "</p></dd>");
            } else {
                System.out.println("<p>" + string2 + "</p></dd>");
            }
            ++n;
            ++n2;
        }
        System.out.println("</body></html>");
        System.err.println("made " + n3 + " lemmas, del6=" + n4 + ", add6=" + n5);
        System.err.println("ndd=" + this.ndd + ", nddchanged=" + this.nddchanged);
        System.err.println("diff6drop=" + this.diff6drop + ", diff6add=" + this.diff6add + ", diff56change=" + this.diff56change);
        System.err.println("nHanZen=" + this.nHanZen + ", nZenHan=" + this.nZenHan + ", nhitotsu=" + this.nhitotsu + ", nSub=" + this.nSub + ", kana56fix=" + this.kan56fix + ", kanjiKanaAdd=" + this.kanjiKanaAdd + ", nbar5=" + this.nbar5 + ", nbar6=" + this.nbar6 + ", brHrefAdd=" + this.brHrefAdd);
        this.dumpKanjiKanaMap();
    }

    public static void main(String[] stringArray) throws Exception {
        MergeBody mergeBody = new MergeBody();
        mergeBody.merge();
    }
}

