/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PDF2Jpeg {
    private static int TRIM_MARGIN = 10;
    private static final int WHITE = -1;

    private static void convert(String string, String string2, String string3, int n, int n2) throws Exception {
        File file;
        File file2 = new File(string);
        if (!file2.exists()) {
            System.err.println(string + " \u304c\u3042\u308a\u307e\u305b\u3093");
            return;
        }
        if (string3 == null) {
            string3 = file2.getName();
            string3 = string3.substring(0, string3.length() - 4);
        }
        if (!(file = new File(string2)).exists()) {
            file.mkdirs();
        }
        System.out.println(string + " \u5909\u63db\u958b\u59cb");
        PDDocument pDDocument = PDDocument.load((File)file2);
        PDFRenderer pDFRenderer = new PDFRenderer(pDDocument);
        int n3 = n;
        for (int i = 0; i < pDDocument.getNumberOfPages(); ++i) {
            BufferedImage bufferedImage = pDFRenderer.renderImageWithDPI(i, (float)n2, ImageType.RGB);
            String string4 = n < 0 && pDDocument.getNumberOfPages() <= 1 ? string3 + ".jpg" : string3 + n3 + ".jpg";
            File file3 = new File(file, string4);
            bufferedImage = PDF2Jpeg.trim(bufferedImage);
            ImageIO.write((RenderedImage)bufferedImage, "jpeg", file3);
            System.out.print(file3.getName() + " ");
            ++n3;
        }
        pDDocument.close();
        System.out.println();
        System.out.println(string + " \u5909\u63db\u7d42\u4e86");
    }

    private static BufferedImage trim(BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        for (n4 = 0; n4 < n6; ++n4) {
            if (PDF2Jpeg.isWhiteHorizon(bufferedImage, n4)) continue;
            if ((n4 -= TRIM_MARGIN) >= 0) break;
            n4 = 0;
            break;
        }
        for (n3 = n6 - 1; n3 > n4; --n3) {
            if (PDF2Jpeg.isWhiteHorizon(bufferedImage, n3)) continue;
            if ((n3 += TRIM_MARGIN) <= n6) break;
            n3 = n6;
            break;
        }
        for (n2 = 0; n2 < n5; ++n2) {
            if (PDF2Jpeg.isWhiteVertical(bufferedImage, n2)) continue;
            if ((n2 -= TRIM_MARGIN) >= 0) break;
            n2 = 0;
            break;
        }
        for (n = n5 - 1; n > n2; --n) {
            if (PDF2Jpeg.isWhiteVertical(bufferedImage, n)) continue;
            if ((n += TRIM_MARGIN) <= n5) break;
            n = n5;
            break;
        }
        return bufferedImage.getSubimage(n2, n4, n - n2, n3 - n4);
    }

    private static boolean isWhiteHorizon(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        for (int i = 0; i < n2; ++i) {
            if (bufferedImage.getRGB(i, n) == -1) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhiteVertical(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getHeight();
        for (int i = 0; i < n2; ++i) {
            if (bufferedImage.getRGB(n, i) == -1) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("Usage: java PDF2Jpeg sample.pdf outDir [dpi] [startIdx] [outputPrefix]");
            return;
        }
        System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
        String string = stringArray[0];
        String string2 = stringArray[1];
        int n = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : 200;
        int n2 = stringArray.length > 3 ? Integer.parseInt(stringArray[3]) : -1;
        String string3 = stringArray.length > 4 ? stringArray[4] : null;
        PDF2Jpeg.convert(string, string2, string3, n2, n);
    }
}

