/*
 * Decompiled with CFR 0.152.
 */
package zephyr.sanshusha.accessdejp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import zephyr.sanshusha.accessdejp.Util;

public class BinaryFile {
    private final InputStream in;
    private final BufferedInputStream bin;
    private int offset;

    BinaryFile(String string) throws Exception {
        this.in = new FileInputStream(new File(string));
        this.bin = new BufferedInputStream(this.in);
        this.offset = 0;
    }

    void read(byte[] byArray, int n) throws Exception {
        int n2 = this.bin.read(byArray, 0, n);
        if (n2 != n) {
            throw new Exception("read requested: " + n + "byte, read actually " + n2 + " byte");
        }
        this.offset += n2;
    }

    int readInt() throws Exception {
        byte[] byArray = new byte[4];
        this.read(byArray, 4);
        return Util.bytes2int(byArray);
    }

    void skip(int n) throws Exception {
        int n2 = n;
        while (n2 > 0) {
            n2 = (int)((long)n2 - this.bin.skip(n2));
        }
        this.offset += n;
    }

    int offset() {
        return this.offset;
    }
}

