/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.readers3;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MakeFullPlist {
    private static final Pattern PLIST = Pattern.compile("<key>[hz]([a-z0-9]+)</key><string>(.*?)</string>");
    private final HashMap<String, String> gaijiMap = new HashMap();

    private void loadPlist(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((string2 = bufferedReader.readLine()) != null) {
            Matcher matcher = PLIST.matcher(string2);
            if (!matcher.find()) continue;
            this.gaijiMap.put(matcher.group(1), matcher.group(2));
        }
        bufferedReader.close();
    }

    private int nextEBCode(int n) {
        if ((n & 0xFF) >= 126) {
            n &= 0xFFFFFF00;
            n += 289;
        } else {
            ++n;
        }
        return n;
    }

    private void output(String string, int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            String string2 = String.format("%x", n3);
            String string3 = this.gaijiMap.get(string2);
            if (string3 == null) {
                string3 = " ";
            }
            System.out.printf("<key>%s%s</key><string>%s</string>\n", string, string2, string3);
            n3 = this.nextEBCode(n3);
        }
    }

    private void output() {
        this.output("h", 41249, 43302);
        this.output("z", 45380, 47417);
    }

    public static void main(String[] stringArray) throws Exception {
        MakeFullPlist makeFullPlist = new MakeFullPlist();
        String string = stringArray.length > 0 ? stringArray[0] : "READERS3.plist";
        makeFullPlist.loadPlist(string);
        makeFullPlist.output();
    }
}

