<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/"><html><body><xsl:apply-templates /></body></html></xsl:template>

    <xsl:template match="dt">&#60;dt id="<xsl:value-of select="@id" />"&#62;<xsl:apply-templates/>&#60;/dt&#62;</xsl:template>
    <xsl:template match="dd">&#60;dd&#62;<xsl:apply-templates/>&#60;/dd&#62;</xsl:template>
    <xsl:template match="sup">&#60;sup&#62;<xsl:apply-templates/>&#60;/sup&#62;</xsl:template>
    <xsl:template match="b">&#60;b&#62;<xsl:apply-templates/>&#60;/b&#62;</xsl:template>
    <xsl:template match="i">&#60;i&#62;<xsl:apply-templates/>&#60;/i&#62;</xsl:template>
    <xsl:template match="td">&#60;p&#62;<xsl:apply-templates/>&#60;/p&#62;</xsl:template>
    <xsl:template match="key">&#60;key type="<xsl:value-of select="@type" />"&#62;<xsl:apply-templates/>&#60;/key&#62;</xsl:template>
    <xsl:template match="conju">【&#60;a href="conju.html#<xsl:apply-templates/>"&#62;活用表&#60;/a&#62;】 </xsl:template>
    
    <!-- See c:\Program Files\PetitRoyal\css\detaul.css -->
    <xsl:template match="span[@class = 'hak']/span[@class = 'skan']">&#60;sup&#62;<xsl:apply-templates/>&#60;/sup&#62;</xsl:template>
    <xsl:template match="span">
        <xsl:choose>
            <!--  NOTE: ykg タグは日本語訳抽出のために残す -->
            <xsl:when test="@class = 'ykg'">&#60;ykg&#62;<xsl:apply-templates/>&#60;/ykg&#62;</xsl:when>
            <xsl:when test="@class = 'dim'"> [<xsl:apply-templates/>] </xsl:when>
            <xsl:when test="@class = '' and @pf = 'start'"></xsl:when>
            <xsl:when test="@class = 'kkm'"> [<xsl:apply-templates/>] </xsl:when>
            <xsl:when test="@class = 'logo'"> [<xsl:apply-templates/>] </xsl:when>
            <xsl:when test="@class = 'dou'"> （<xsl:apply-templates/>） </xsl:when>
            <xsl:when test="@class = 'henk'"> （<xsl:apply-templates/>） </xsl:when>
            <xsl:when test="@class = 'hns'"> [&#60;b&#62;<xsl:apply-templates/>&#60;/b&#62;] </xsl:when>
            <xsl:when test="@class = 'hnk'">&#60;b&#62;━━&#60;/b&#62; <xsl:apply-templates/> </xsl:when>
            <xsl:when test="@class = 'eng'"> （<b><xsl:apply-templates/></b>） </xsl:when>
            <xsl:when test="@class = 'dbn'">&#60;b&#62;【<xsl:apply-templates/>】&#60;/b&#62; </xsl:when>
            <xsl:when test="@class = 'dbg'">&#60;b&#62;［ &#60;/b&#62;<xsl:apply-templates/>&#60;b&#62; ］&#60;/b&#62; </xsl:when>
            <xsl:when test="@class = 'kri'">&#60;indent val="2"&#62;&#60;b&#62;会話<xsl:text> </xsl:text><xsl:apply-templates/>&#60;/b&#62;&#60;indent val="1"&#62;</xsl:when>
            <xsl:when test="@class = 'has'"> ◇<xsl:apply-templates/></xsl:when>
            <xsl:when test="@class = 'kbn'">&#60;b&#62;【<xsl:apply-templates/>】&#60;/b&#62; </xsl:when>
            <xsl:when test="@class = 'vbn'"> 【<xsl:apply-templates/>】 </xsl:when>
            <xsl:when test="@class = 'skan'">&#60;i&#62;<xsl:apply-templates/>&#60;/i&#62;</xsl:when>
            <xsl:when test="@class = 'mid'">
            	<xsl:choose>
            		<xsl:when test="@rank = '00'">&#60;b&#62;<xsl:apply-templates/>&#60;/b&#62; </xsl:when>
            		<xsl:otherwise><xsl:apply-templates/></xsl:otherwise>
            	</xsl:choose>
            </xsl:when>
             <!--  -->
            <xsl:when test="@class = 'hat'"><xsl:value-of select="@pf" /><xsl:apply-templates/><xsl:value-of select="@sf" /></xsl:when>
            <xsl:when test="@class = 'hak'"> <xsl:apply-templates/><xsl:value-of select="@sf" /></xsl:when>
            <xsl:when test="@class = 'ggi'">&#60;b&#62;<xsl:apply-templates/>.&#60;/b&#62; </xsl:when>
            <xsl:when test="@class = 'sku'">&#60;b&#62;<xsl:apply-templates/>.&#60;/b&#62; </xsl:when>
            <xsl:when test="@class = 'gnk'">&#60;b&#62;<xsl:apply-templates/>.&#60;/b&#62; </xsl:when>
            <xsl:when test="@class = 'blockmark'">&#60;b&#62;［<xsl:apply-templates/>］&#60;/b&#62; </xsl:when>
            <xsl:when test="@class = 'bny'">〖<xsl:apply-templates/>〗 </xsl:when>
            <xsl:when test="@class = 'gok'">《<xsl:apply-templates/>》 </xsl:when>
            <xsl:when test="@class = 'hoj'">《<xsl:apply-templates/>》 </xsl:when>
            <xsl:when test="@class = 'gnt'">《<xsl:apply-templates/>》 </xsl:when>
            <xsl:when test="@class = 'zhk'">《<xsl:apply-templates/>》 </xsl:when>
            <xsl:when test="@class = 'stm'">《<xsl:apply-templates/>》 </xsl:when>
            <xsl:when test="@class = 'gos'">《<xsl:apply-templates/>》 </xsl:when>
            <xsl:when test="@class = 'bns'">《<xsl:apply-templates/>》 </xsl:when>
            <xsl:when test="@class = 'ggn'"> （＜<xsl:apply-templates/>） </xsl:when>
            <xsl:when test="@class = 'hse'"> （←<xsl:apply-templates/>） </xsl:when>
            <xsl:when test="@class = 'gng'"> （←<xsl:apply-templates/>） </xsl:when>
            <xsl:when test="@class = 'hgo'"> （★<xsl:apply-templates/>） </xsl:when>
            <xsl:when test="@class = 'doi'"> （=<xsl:apply-templates/>） </xsl:when>
            <xsl:when test="@class = 'hai'"> （⇔<xsl:apply-templates/>） </xsl:when>
            <xsl:when test="@class = 'tyk'"> （◇<xsl:apply-templates/>） </xsl:when>
            <xsl:when test="@class = 'ryk'"> （略：<xsl:apply-templates/>） </xsl:when>
            <xsl:when test="@class = 'jds'"> （助動：<xsl:apply-templates/>） </xsl:when>
            <xsl:when test="@class = 'bnk'"> （過分：<xsl:apply-templates/>） </xsl:when>
            <xsl:when test="@class = 'tyi'">[注意] <xsl:apply-templates/> </xsl:when>
            <xsl:when test="@class = 'snk'">[参考] <xsl:apply-templates/> </xsl:when>
            <xsl:when test="@class = 'sny'">⇒<xsl:apply-templates/> </xsl:when>
            <xsl:when test="@class = 'okr'"> ＝<xsl:apply-templates/> </xsl:when>
            <xsl:when test="@class = 'rsm'"></xsl:when>
            <xsl:when test="@class = 'rubi'">&#60;sub&#62;<xsl:apply-templates/>&#60;/sub&#62;</xsl:when>
            <xsl:when test="@class = 'yry'"><xsl:text> </xsl:text><xsl:apply-templates/></xsl:when>
            <xsl:when test="@class = 'msy'"><xsl:text> </xsl:text><xsl:apply-templates/></xsl:when>
            <xsl:otherwise><xsl:apply-templates/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="table">&#60;indent val="2"&#62;<xsl:apply-templates/>&#60;indent val="1"&#62;</xsl:template>

</xsl:stylesheet>
