/*
 * Decompiled with CFR 0.152.
 */
package zephyr.oxford.oed;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import zephyr.util.ZephyrUtil;

public class MakeBodyHtml {
    static final String ENTRY_DELIM = "======";

    private void fixLines(LinkedList<String> linkedList) {
        String string = linkedList.get(0);
        if (string.startsWith("Draft entry ") || string.startsWith("Additions ")) {
            String string2 = linkedList.get(2);
            linkedList.set(0, string2);
            linkedList.set(2, string);
        }
    }

    private void outLines(LinkedList<String> linkedList) {
        if (linkedList.size() < 3) {
            System.err.println("lines.size()=" + linkedList.size());
            return;
        }
        this.fixLines(linkedList);
        String string = linkedList.get(0);
        int n = string.indexOf(44);
        String string2 = n > 0 ? string.substring(0, n) : string;
        System.out.print("<dt title=\"");
        System.out.print(string);
        System.out.print("\">");
        System.out.print(string2);
        System.out.print("</dt><dd>");
        if (n > 0) {
            System.out.print("<p>");
            System.out.print(string.substring(n));
            System.out.println("</p>");
        } else {
            System.out.println("<br>");
        }
        for (int i = 1; i < linkedList.size(); ++i) {
            String string3 = linkedList.get(i).trim();
            if (string3.isEmpty()) {
                if (i <= 1) continue;
                System.out.println("<br><br>");
                continue;
            }
            System.out.println("<p>" + string3 + "</p>");
        }
        System.out.println("</dd>");
    }

    private void loadTxt(String[] stringArray) throws Exception {
        String string;
        InputStream inputStream = stringArray.length > 0 ? new FileInputStream(new File(stringArray[0])) : System.in;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        System.out.println("<html><body>");
        LinkedList<String> linkedList = new LinkedList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            if (string.equals(ENTRY_DELIM)) {
                this.outLines(linkedList);
                linkedList.clear();
                continue;
            }
            linkedList.add(string);
        }
        bufferedReader.close();
        if (!linkedList.isEmpty()) {
            this.outLines(linkedList);
        }
        System.out.println("</body></html>");
    }

    public static void main(String[] stringArray) {
        ZephyrUtil.setUTF8Ouput();
        MakeBodyHtml makeBodyHtml = new MakeBodyHtml();
        try {
            makeBodyHtml.loadTxt(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

