/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.readers3;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.moraleboost.mecab.Lattice;
import net.moraleboost.mecab.Node;
import net.moraleboost.mecab.impl.StandardTagger;
import zephyr.kenkyusha.readers3.Lemmatizer;
import zephyr.util.MultiTreeMap;
import zephyr.util.ZephyrUtil;

public class MakeYoureiHtml {
    private StandardTagger tagger = null;
    private Lattice lattice = null;
    private final MultiTreeMap<String, Yourei> youreiMap = new MultiTreeMap(new IgnoreCaseComp());
    private static final Pattern DT = Pattern.compile("<dt[^>]*>(.+?)</dt>");
    private static final Pattern YOUREI = Pattern.compile("<p>\u3000- ([^\u3000]+)(\u3000(.+?))?</p>");
    private static final Pattern IDIOM = Pattern.compile("<p([^>]*)>(<idiom/>|<idiomjp/>)\u3000*(.+?)</p>");
    private final HashSet<String> keySet = new HashSet();
    private final LinkedList<String> keyList = new LinkedList();
    private final ArrayList<String> jpWordList = new ArrayList();
    private static final int YOUREI_MAX_ENTRY = 300;

    private void mecabInit() {
        this.mecabFini();
        this.tagger = new StandardTagger("");
        this.lattice = this.tagger.createLattice();
    }

    private void mecabFini() {
        if (this.lattice != null) {
            this.lattice.destroy();
            this.lattice = null;
        }
        if (this.tagger != null) {
            this.tagger.destroy();
            this.tagger = null;
        }
    }

    private String dropMarks(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!bl) {
                if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '-' || c == ' ' || c == '\'') {
                    stringBuilder.append(c);
                    continue;
                }
                if (c == '<') {
                    bl = true;
                    continue;
                }
                stringBuilder.append(" ");
                continue;
            }
            if (!bl || c != '>') continue;
            bl = false;
        }
        return stringBuilder.toString().replaceAll(" +", " ").trim();
    }

    private void putYourei(String string, String string2, String string3) {
        this.keySet.clear();
        String string4 = this.dropMarks(string2);
        String[] stringArray = string4.split(" +");
        ArrayList<LinkedList<String>> arrayList = new ArrayList<LinkedList<String>>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(Lemmatizer.lemma(stringArray[i]));
        }
        Yourei yourei = new Yourei(string, string2, string3);
        for (int i = 0; i < stringArray.length; ++i) {
            this.keyList.clear();
            for (String string5 : (LinkedList)arrayList.get(i)) {
                if (i < stringArray.length - 2 && (stringArray[i + 1].equals("a") || stringArray[i + 1].equals("an") || stringArray[i + 1].equals("the"))) {
                    for (String string6 : (LinkedList)arrayList.get(i + 2)) {
                        this.keyList.add(string5 + " " + string6);
                    }
                    continue;
                }
                if (i < stringArray.length - 1) {
                    for (String string6 : (LinkedList)arrayList.get(i + 1)) {
                        this.keyList.add(string5 + " " + string6);
                    }
                    continue;
                }
                this.keyList.add(string5);
            }
            for (String string5 : this.keyList) {
                if (this.keySet.contains(string5)) continue;
                this.youreiMap.put(string5, yourei);
                this.keySet.add(string5);
            }
        }
        if (string3 != null) {
            Object object;
            this.jpWordList.clear();
            this.lattice.setSentence(ZephyrUtil.hex2uni(string3));
            this.tagger.parse(this.lattice);
            for (Node node = this.lattice.bosNode(); node != null; node = node.next()) {
                String string5;
                object = node.surface();
                string5 = node.feature();
                if (((String)object).isEmpty() || ((String)object).charAt(0) < '\u0100' || ((String)object).contains("<") || ((String)object).contains(">")) continue;
                if (!string5.startsWith("\u8a18\u53f7,") || ((String)object).equals("\u3002") || ((String)object).equals("\u3001")) {
                    // empty if block
                }
                this.jpWordList.add((String)object);
            }
            for (int i = 0; i < this.jpWordList.size(); ++i) {
                object = this.jpWordList.get(i);
                if (i < this.jpWordList.size() - 1) {
                    object = (String)object + this.jpWordList.get(i + 1);
                }
                if (this.keySet.contains(object)) continue;
                this.youreiMap.put((String)object, yourei);
                this.keySet.add((String)object);
            }
        }
    }

    private void outputYourei() {
        MultiTreeMap<String, Yourei> multiTreeMap = this.youreiMap;
        String string = "<dt title=\"\u25a0 ";
        for (String string2 : multiTreeMap.keySet()) {
            LinkedList linkedList = multiTreeMap.getList(string2);
            System.out.println(string + string2 + " " + linkedList.size() + "\">\u25a0 " + string2 + "</dt><dd>" + linkedList.size());
            int n = 0;
            for (Yourei yourei : linkedList) {
                String string3 = yourei.en.replace("href=\"#", "href=\"body.html#");
                if (yourei.jp != null) {
                    String string4 = yourei.jp.replace("href=\"#", "href=\"body.html#");
                    System.out.println("<p>[" + yourei.lemma + "] " + string3 + "\u3000" + string4 + "</p>");
                } else {
                    System.out.println("<p>[" + yourei.lemma + "] " + string3 + "</p>");
                }
                if (++n < 300) continue;
                System.out.println("....");
                System.err.println(string2 + "\t" + linkedList.size());
                break;
            }
            System.out.println("</dd>");
        }
    }

    private void output() {
        System.out.println("<html><body>");
        this.outputYourei();
        System.out.println("</body></html>");
    }

    private void parse(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        String string3 = "";
        String string4 = null;
        String string5 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            String string6;
            Matcher matcher = DT.matcher(string2);
            if (matcher.find()) {
                if (string4 != null) {
                    this.putYourei(string3, string4, string5);
                    ++n3;
                    string5 = null;
                    string4 = null;
                }
                string3 = matcher.group(1);
                string3 = string3.replaceAll("&#xb7;", "");
                string3 = ZephyrUtil.dropMarks(ZephyrUtil.hex2uni(string3));
                ++n;
                continue;
            }
            matcher = YOUREI.matcher(string2);
            if (matcher.find()) {
                if (string4 != null) {
                    this.putYourei(string3, string4, string5);
                    ++n3;
                    string5 = null;
                    string4 = null;
                }
                string6 = matcher.group(1);
                String string7 = matcher.group(3);
                this.putYourei(string3, string6, string7);
                ++n2;
                continue;
            }
            matcher = IDIOM.matcher(string2);
            if (matcher.find()) {
                string6 = matcher.group(2);
                if (string6.equals("<idiom/>")) {
                    if (string4 != null) {
                        this.putYourei(string3, string4, string5);
                        ++n3;
                    }
                    string4 = matcher.group(3);
                    string5 = null;
                    continue;
                }
                if (string4 == null) continue;
                if (string5 == null) {
                    string5 = matcher.group(3);
                    continue;
                }
                string5 = string5 + "<br>" + matcher.group(3);
                continue;
            }
            if (string4 == null) continue;
            if (string2.startsWith("<p>\u3000") && string2.endsWith("</p>")) {
                string6 = string2.substring(3, string2.length() - 4);
                if (string5 == null) {
                    string5 = string6;
                    continue;
                }
                string5 = string5 + "<br>" + string6;
                continue;
            }
            this.putYourei(string3, string4, string5);
            ++n3;
            string5 = null;
            string4 = null;
        }
        if (string4 != null) {
            this.putYourei(string3, string4, string5);
            ++n3;
            string5 = null;
            string4 = null;
        }
        bufferedReader.close();
        System.err.println(n + " \u4e3b\u898b\u51fa\u3057");
        System.err.println(n2 + " \u7528\u4f8b");
        System.err.println(n3 + " \u6210\u53e5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            ZephyrUtil.setUTF8Ouput();
            MakeYoureiHtml makeYoureiHtml = new MakeYoureiHtml();
            try {
                makeYoureiHtml.mecabInit();
                makeYoureiHtml.parse(stringArray[0]);
                makeYoureiHtml.output();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                makeYoureiHtml.mecabFini();
            }
        } else {
            System.err.println("Usage: java MakeYoureiHtml body.html");
        }
    }

    static class Yourei {
        final String lemma;
        final String en;
        final String jp;

        Yourei(String string, String string2, String string3) {
            this.lemma = string;
            this.en = string2;
            this.jp = string3;
        }
    }

    private class IgnoreCaseComp
    implements Comparator<String> {
        private IgnoreCaseComp() {
        }

        @Override
        public int compare(String string, String string2) {
            int n = string.compareToIgnoreCase(string2);
            if (n != 0) {
                return n;
            }
            return string.compareTo(string2);
        }
    }
}

