/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.UnescapeChars;
import zephyr.util.ZephyrUtil;

public class AppendLatinKeys {
    protected static int nKey = 0;
    public static final String SUPERPREFIX = "* ";
    public static final String DT_DD_REGEXP = "<dt[^>]+>(.+?)</dt>.*?(<dd>(.*)</dd>)";
    public static final Pattern DT_DD = Pattern.compile("<dt[^>]+>(.+?)</dt>.*?(<dd>(.*)</dd>)");
    static final String WORD_REGEXP = "(<b>)?([A-Za-z\u00c0-\u017e']{2,}+)";
    protected final Pattern WORD;
    private final String keyLang;

    protected String makeKey(String key) {
        if (key.startsWith(SUPERPREFIX)) {
            return key.substring(SUPERPREFIX.length());
        }
        return key;
    }

    protected String makeKeyTitle(String dt, String key) {
        return String.valueOf(key) + " - " + dt;
    }

    public String makeKeys(String dt, String dtKey, String type, Set<String> keySet) {
        StringBuffer sb = new StringBuffer();
        for (String key : keySet) {
            if (ZephyrUtil.makeKey(key).equals(dtKey)) continue;
            sb.append("<key type=\"");
            sb.append(type);
            sb.append("\" title=\"");
            sb.append(this.makeKeyTitle(dt, key));
            sb.append("\">");
            sb.append(this.makeKey(key));
            sb.append("</key>");
            ++nKey;
        }
        return sb.toString();
    }

    public Set<String> makeKeySet(String dt, String dd, Pattern pat) {
        Matcher m = pat.matcher(dd);
        TreeSet<String> keySet = new TreeSet<String>();
        while (m.find()) {
            String key = m.group(2);
            if (m.group(1) != null) {
                keySet.remove(key);
                keySet.add(SUPERPREFIX + key);
                continue;
            }
            if (keySet.contains(SUPERPREFIX + key)) continue;
            keySet.add(key);
        }
        return keySet;
    }

    public String makeKeys(String dt, String dd, Pattern pat, String type) {
        Set<String> keySet = this.makeKeySet(dt, dd, pat);
        if (!keySet.isEmpty()) {
            Matcher m = pat.matcher(dt);
            String dtKey = m.find() ? ZephyrUtil.makeKey(m.group(2)) : null;
            return this.makeKeys(dt, dtKey, type, keySet);
        }
        return "";
    }

    public int getKeyNum() {
        return nKey;
    }

    protected AppendLatinKeys(Pattern wordPat, String keyLang) {
        this.WORD = wordPat != null ? wordPat : Pattern.compile(WORD_REGEXP);
        this.keyLang = keyLang == null || keyLang.isEmpty() ? "" : String.valueOf(keyLang.trim()) + " ";
    }

    protected AppendLatinKeys(String keyLang) {
        this(null, keyLang);
    }

    public AppendLatinKeys() {
        this(null, "");
    }

    protected String makePlainText(String dd) {
        return dd;
    }

    protected String parse(String line, String type) {
        Matcher m = DT_DD.matcher(line = UnescapeChars.unescape(line));
        if (!m.find()) {
            return line;
        }
        String dt = m.group(1);
        String dd = m.group(3);
        String txt = this.makePlainText(dd);
        String keys = this.makeKeys(dt, txt, this.WORD, type);
        return String.valueOf(line.substring(0, m.start(2))) + keys + m.group(2);
    }

    public static String getKeyType(String key) {
        if (key.equals("\u8868\u8a18") || key.equals("\u6761\u4ef6")) {
            return key;
        }
        System.err.println("invalid keytype: " + key + ", must be \u8868\u8a18 or \u6761\u4ef6");
        System.exit(1);
        return null;
    }

    protected void appendKeys(String[] args) throws Exception {
        String line;
        InputStream in = !args[0].equals("-") ? new FileInputStream(new File(args[0])) : System.in;
        String type = AppendLatinKeys.getKeyType(args[1]);
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        while ((line = br.readLine()) != null) {
            System.out.println(this.parse(line, type));
        }
        br.close();
        if (nKey > 0) {
            System.err.println("append " + nKey + " extra " + this.keyLang + type + " keys");
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: java AppendLatinKeys utf8file.html [\u8868\u8a18|\u6761\u4ef6]");
            return;
        }
        ZephyrUtil.setUTF8Ouput();
        AppendLatinKeys app = new AppendLatinKeys();
        try {
            app.appendKeys(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

