/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.AppendLatinKeys;
import zephyr.util.ZephyrUtil;

public class AppendJPKeys
extends AppendLatinKeys {
    public static final String JPWORD_REGEXP = "(<b>)?([\u3041-\u30fa\u30fc-\u9fff][0-9\u3041-\u30fa\u30fc-\u9fff]*)";
    public static final Pattern JPWORD = Pattern.compile("(<b>)?([\u3041-\u30fa\u30fc-\u9fff][0-9\u3041-\u30fa\u30fc-\u9fff]*)");
    private static final String SENSE_REGEXP = "(<indent val=\"([0-9])\">)?<p>(.+?)</p>";
    private static final Pattern SENSE = Pattern.compile("(<indent val=\"([0-9])\">)?<p>(.+?)</p>");

    public static boolean isKataKana(char c) {
        return '\u30a1' <= c && c <= '\u30f6' || c == '\u30fc';
    }

    public static boolean isKana(char c) {
        return '\u3041' <= c && c <= '\u30fc';
    }

    public static char kata2hira(char c) {
        if (c != '\u30fc') {
            return (char)(c - 12449 + 12353);
        }
        return c;
    }

    public static String makeKana(String dt) {
        int i = 0;
        while (i < dt.length()) {
            if (!AppendJPKeys.isKataKana(dt.charAt(i))) {
                return null;
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < dt.length()) {
            sb.append(AppendJPKeys.kata2hira(dt.charAt(i2)));
            ++i2;
        }
        return sb.toString();
    }

    protected AppendJPKeys() {
        super(JPWORD, "Japanese");
    }

    public static String dropBracket(String line) {
        String[] regReps;
        String[] stringArray = regReps = new String[]{"\u300a(.+?)\u300b", "\u3014(.+?)\u3015", "\\((.+?)\\)", "\\[(.+?)\\]"};
        int n = regReps.length;
        int n2 = 0;
        while (n2 < n) {
            String rep = stringArray[n2];
            line = line.replaceAll(rep, " $1 ");
            ++n2;
        }
        return line;
    }

    @Override
    protected String makePlainText(String dd) {
        dd = AppendJPKeys.dropBracket(dd);
        Matcher m = SENSE.matcher(dd);
        String txt = "";
        int indent = 1;
        while (m.find()) {
            if (m.group(2) != null) {
                indent = Integer.parseInt(m.group(2));
            }
            if (indent > true) continue;
            txt = String.valueOf(txt) + m.group(3) + " ";
        }
        return txt;
    }

    @Override
    public String makeKeys(String dt, String dtKey, String type, Set<String> keySet) {
        String key = super.makeKeys(dt, dtKey, type, keySet);
        for (String k : keySet) {
            String kana = AppendJPKeys.makeKana(k);
            if (kana == null) continue;
            key = String.valueOf(key) + String.format("<key type=\"\u304b\u306a\" title=\"%s\">%s</key>", this.makeKeyTitle(dt, k), kana);
        }
        return key;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: java AppendJPKeys [body-lajputf8.html|-] [\u8868\u8a18|\u6761\u4ef6]");
            return;
        }
        ZephyrUtil.setUTF8Ouput();
        AppendJPKeys app = new AppendJPKeys();
        try {
            app.appendKeys(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

