/*
 * Decompiled with CFR 0.152.
 */
package zephyr.sanshusha.accessdejp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import zephyr.sanshusha.accessdejp.Util;

public class BinaryFile {
    private final InputStream in;
    private final BufferedInputStream bin;
    private int offset;

    BinaryFile(String filename) throws Exception {
        this.in = new FileInputStream(new File(filename));
        this.bin = new BufferedInputStream(this.in);
        this.offset = 0;
    }

    void read(byte[] data, int len) throws Exception {
        int readlen = this.bin.read(data, 0, len);
        if (readlen != len) {
            throw new Exception("read requested: " + len + "byte, read actually " + readlen + " byte");
        }
        this.offset += readlen;
    }

    int readInt() throws Exception {
        byte[] data = new byte[4];
        this.read(data, 4);
        return Util.bytes2int(data);
    }

    void skip(int len) throws Exception {
        int remain = len;
        while (remain > 0) {
            remain = (int)((long)remain - this.bin.skip(remain));
        }
        this.offset += len;
    }

    int offset() {
        return this.offset;
    }
}

