/*
 * Decompiled with CFR 0.152.
 */
package zephyr.oxford.oed;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import zephyr.util.ZephyrUtil;

public class MakeBodyHtml {
    static final String ENTRY_DELIM = "======";

    private void fixLines(LinkedList<String> lines) {
        String l0 = lines.get(0);
        if (l0.startsWith("Draft entry ") || l0.startsWith("Additions ")) {
            String l2 = lines.get(2);
            lines.set(0, l2);
            lines.set(2, l0);
        }
    }

    private void outLines(LinkedList<String> lines) {
        if (lines.size() < 3) {
            System.err.println("lines.size()=" + lines.size());
            return;
        }
        this.fixLines(lines);
        String line0 = lines.get(0);
        int idx = line0.indexOf(44);
        String head = idx > 0 ? line0.substring(0, idx) : line0;
        System.out.print("<dt title=\"");
        System.out.print(line0);
        System.out.print("\">");
        System.out.print(head);
        System.out.print("</dt><dd>");
        if (idx > 0) {
            System.out.print("<p>");
            System.out.print(line0.substring(idx));
            System.out.println("</p>");
        } else {
            System.out.println("<br>");
        }
        int i = 1;
        while (i < lines.size()) {
            String l = lines.get(i).trim();
            if (l.isEmpty()) {
                if (i > 1) {
                    System.out.println("<br><br>");
                }
            } else {
                System.out.println("<p>" + l + "</p>");
            }
            ++i;
        }
        System.out.println("</dd>");
    }

    private void loadTxt(String[] args) throws Exception {
        String line;
        InputStream in = args.length > 0 ? new FileInputStream(new File(args[0])) : System.in;
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        System.out.println("<html><body>");
        LinkedList<String> lines = new LinkedList<String>();
        while ((line = br.readLine()) != null) {
            if (line.equals(ENTRY_DELIM)) {
                this.outLines(lines);
                lines.clear();
                continue;
            }
            lines.add(line);
        }
        br.close();
        if (!lines.isEmpty()) {
            this.outLines(lines);
        }
        System.out.println("</body></html>");
    }

    public static void main(String[] args) {
        ZephyrUtil.setUTF8Ouput();
        MakeBodyHtml app = new MakeBodyHtml();
        try {
            app.loadTxt(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

