/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.royalfrjp;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import zephyr.util.ZephyrUtil;

public class MakeBodyHtml {
    private static final TransformerFactory tFactory = TransformerFactory.newInstance();
    private final Transformer transformer;
    private final StreamResult nullOut;
    private static final String[][] REP_A_00864 = new String[][]{{"<span class=\"setumei\">\uff3b\u5927\u7d71\u9818\u304c\u4e3b\u5bb0\u3057\u5927\u81e3\u306e\u307f\u3067\u69cb\u6210\uff3d</td>", "<span class=\"setumei\">\uff3b\u5927\u7d71\u9818\u304c\u4e3b\u5bb0\u3057\u5927\u81e3\u306e\u307f\u3067\u69cb\u6210\uff3d</span></td>"}, {"<span class=\"setumei\">\uff3b\u9996\u76f8\u304c\u4e3b\u5bb0\u3057\u526f\u5927\u81e3\u3092\u542b\u3080\u95a3\u50da\u69cb\u6210\u54e1\u5168\u54e1\u3067\u69cb\u6210\uff3d</td>", "<span class=\"setumei\">\uff3b\u9996\u76f8\u304c\u4e3b\u5bb0\u3057\u526f\u5927\u81e3\u3092\u542b\u3080\u95a3\u50da\u69cb\u6210\u54e1\u5168\u54e1\u3067\u69cb\u6210\uff3d</span></td>"}, {"<span class=\"setumei\">\uff3b\u5927\u7d71\u9818\u307e\u305f\u306f\u9996\u76f8\u304c\u4e3b\u5bb0\u3057\u95a2\u4fc2\u3059\u308b\u5927\u81e3\u53ca\u3073\u526f\u5927\u81e3\u3067\u69cb\u6210\uff3d</td>", "<span class=\"setumei\">\uff3b\u5927\u7d71\u9818\u307e\u305f\u306f\u9996\u76f8\u304c\u4e3b\u5bb0\u3057\u95a2\u4fc2\u3059\u308b\u5927\u81e3\u53ca\u3073\u526f\u5927\u81e3\u3067\u69cb\u6210\uff3d</span></td>"}, {"<span class=\"sansyo2\">\u21d2<span class=\"jump\" onClick=\"jump('R-01556','006')\">r&eacute;gion info </span></td>", "<span class=\"sansyo2\">\u21d2<span class=\"jump\" onClick=\"jump('R-01556','006')\">r&eacute;gion info </span></span></td>"}, {"<span class=\"sansyo2\">\u21d2<span class=\"jump\" onClick=\"jump('D-01819','005')\">d&eacute;partement info </span></td>", "<span class=\"sansyo2\">\u21d2<span class=\"jump\" onClick=\"jump('D-01819','005')\">d&eacute;partement info </span></span></td>"}, {"<span class=\"sansyo2\">\u21d2<span class=\"jump\" onClick=\"jump('N-01169','')\">Nouvelle-Cal&eacute;donie </span></td>", "<span class=\"sansyo2\">\u21d2<span class=\"jump\" onClick=\"jump('N-01169','')\">Nouvelle-Cal&eacute;donie </span></span></td>"}};
    private static final String[][] REP_C_01815 = new String[][]{{"<span class=\"setumei\">\uff3b\u30a2\u30d5\u30ea\u30ab\u4e2d\u592e\u90e8\u306e\u56fd\uff3d</span></span></td></tr>", "<span class=\"setumei\">\uff3b\u30a2\u30d5\u30ea\u30ab\u4e2d\u592e\u90e8\u306e\u56fd\uff3d</span></td></tr>"}};
    private static final String[][] REP_D_01318 = new String[][]{{"</span></td></tr></td></tr><tr id=\"sub_yourei_4\" class=\"block\">", "</span></td></tr><tr id=\"sub_yourei_4\" class=\"block\">"}};
    private static final String[][] REP_D_04007 = new String[][]{{"<sup>1<sup>", "<sup>1</sup>"}};
    private static final String[][] REP_H_01065 = new String[][]{{"</span><tr><td><span class=\"branch3\">", "</span></td></tr><tr><td><span class=\"branch3\">"}};
    private static final String[][] REP_H_01619 = new String[][]{{"<!--<input type=\"button\" value=\"\u6d3b\u7528\u8868\"  onClick=\"openVerbTable('H3836')\"/>--/>", "<!-- <input type=\"button\" value=\"\u6d3b\u7528\u8868\"  onClick=\"openVerbTable('H3836')\"> -->"}, {"<!--<input type=\"button\" value=\"\u6d3b\u7528\u8868\"  onClick=\"openVerbTable('H3836')\"/>-->", "<!-- <input type=\"button\" value=\"\u6d3b\u7528\u8868\"  onClick=\"openVerbTable('H3836')\"> -->"}, {"<!--<input type=\"button\" value=\"\u6d3b\u7528\u8868\"  onClick=\"openVerbTable('H3836')\">--/>", "<!-- <input type=\"button\" value=\"\u6d3b\u7528\u8868\"  onClick=\"openVerbTable('H3836')\"> -->"}, {"<!--<input type=\"button\" value=\"\u6d3b\u7528\u8868\"  onClick=\"openVerbTable('H3836')\">-->", "<!-- <input type=\"button\" value=\"\u6d3b\u7528\u8868\"  onClick=\"openVerbTable('H3836')\"> -->"}};
    private static final HashMap<String, String[][]> FIX_MAP = new HashMap();
    private static final HashMap<Character, String> hatuonMap;
    private static final String HATUON_START = "<span class=\"hatuon\">";
    private static final String SPAN_START = "<span ";
    private static final String SPAN_END = "</span>";
    private static final String HATUON_END = "</span>";
    private static final String PHONETIC_START = "<span class=\"phonetic_inLine\">";
    private static final String PHONETIC_END = "</span>";
    private static final HashMap<Character, String> gaijiMap;
    private static final String GAIJI_REGEXP = "<span class=\"gaiji\">(.+?)</span>";
    private static final Pattern GAIJI;
    private static final String CONJU_REGEXP = "onClick=\"openVerbTable\\('([^']+)'\\)\">";
    private static final Pattern CONJU;
    private final LinkedList<String> invalidItems = new LinkedList();
    private static final String MIDASI_REGEXP = "<body onLoad=\"init\\('([^']+)'\\)\">.*?<span class=\"midasi\">(.*?)</span>";
    private static final Pattern MIDASI;
    private static Pattern HTM;
    private int nLoaded = 0;

    static {
        FIX_MAP.put("a-00864.htm", REP_A_00864);
        FIX_MAP.put("c-01815.htm", REP_C_01815);
        FIX_MAP.put("d-01318.htm", REP_D_01318);
        FIX_MAP.put("d-04007.htm", REP_D_04007);
        FIX_MAP.put("h-01065.htm", REP_H_01065);
        FIX_MAP.put("h-01619.htm", REP_H_01619);
        hatuonMap = new HashMap();
        hatuonMap.put(Character.valueOf('+'), "\u0251");
        hatuonMap.put(Character.valueOf('#'), "\u025b");
        hatuonMap.put(Character.valueOf('%'), "\u0153");
        hatuonMap.put(Character.valueOf('?'), "\u0278");
        hatuonMap.put(Character.valueOf('$'), "\u0254");
        hatuonMap.put(Character.valueOf('\''), "\u0259");
        hatuonMap.put(Character.valueOf('M'), "\u0272");
        hatuonMap.put(Character.valueOf('G'), "\u025b\u0300");
        hatuonMap.put(Character.valueOf('_'), "\u0265");
        hatuonMap.put(Character.valueOf('0'), "\u0292");
        hatuonMap.put(Character.valueOf('1'), "a\u0303");
        hatuonMap.put(Character.valueOf('2'), "\u0251\u0303");
        hatuonMap.put(Character.valueOf('3'), "\u025b\u0303");
        hatuonMap.put(Character.valueOf('4'), "\u0254\u0303");
        hatuonMap.put(Character.valueOf('5'), "\u0153\u0303");
        hatuonMap.put(Character.valueOf('6'), "\u0283");
        hatuonMap.put(Character.valueOf('7'), "\u014b");
        hatuonMap.put(Character.valueOf('8'), "\u03b8");
        hatuonMap.put(Character.valueOf('9'), "\u00f0");
        gaijiMap = new HashMap();
        gaijiMap.put(Character.valueOf('\u4e9c'), "\u6798");
        gaijiMap.put(Character.valueOf('\u5516'), "\u75ca");
        gaijiMap.put(Character.valueOf('\u3061'), "\u05d0");
        gaijiMap.put(Character.valueOf('\u978d'), "\u84b4");
        gaijiMap.put(Character.valueOf('\u9022'), "\u7aa9");
        gaijiMap.put(Character.valueOf('\u63e1'), "\u9eac");
        gaijiMap.put(Character.valueOf('\u5a03'), "\u70bb");
        gaijiMap.put(Character.valueOf('\u963f'), "\u57f5");
        gaijiMap.put(Character.valueOf('\u54c0'), "\u7664");
        gaijiMap.put(Character.valueOf('\u611b'), "\u579c");
        gaijiMap.put(Character.valueOf('\u674f'), "\u7146");
        gaijiMap.put(Character.valueOf('\u6328'), "\u8484");
        gaijiMap.put(Character.valueOf('\u59f6'), "\u766d");
        gaijiMap.put(Character.valueOf('\u8475'), "\u7350");
        gaijiMap.put(Character.valueOf('\u831c'), "\u6410");
        gaijiMap.put(Character.valueOf('\u7a50'), "\u9ab6");
        gaijiMap.put(Character.valueOf('\u60aa'), "\u79b1");
        gaijiMap.put(Character.valueOf('\u3053'), "\u00a9");
        gaijiMap.put(Character.valueOf('\u6e25'), "\u76b6");
        gaijiMap.put(Character.valueOf('\u65ed'), "\u7c0e");
        gaijiMap.put(Character.valueOf('\u306f'), "<sup>1</sup>/<sub>2</sub>");
        gaijiMap.put(Character.valueOf('\u4ee5'), "\u9127");
        gaijiMap.put(Character.valueOf('\u8466'), "\u685b");
        gaijiMap.put(Character.valueOf('\u82a6'), "\u9846");
        gaijiMap.put(Character.valueOf('\u9bf5'), "\u8e70");
        gaijiMap.put(Character.valueOf('\u65a1'), "\u9c5d");
        gaijiMap.put(Character.valueOf('\u6271'), "(\u91d1+\u901a)");
        gaijiMap.put(Character.valueOf('\u6893'), "\u7cdd");
        gaijiMap.put(Character.valueOf('\u5b9b'), "\u9b10");
        gaijiMap.put(Character.valueOf('\u59d0'), "\u6677");
        gaijiMap.put(Character.valueOf('\u867b'), "\u55c9");
        gaijiMap.put(Character.valueOf('\u98f4'), "\u6a45");
        gaijiMap.put(Character.valueOf('\u7d62'), "\u9a38");
        gaijiMap.put(Character.valueOf('\u5727'), "\u9f95");
        gaijiMap.put(Character.valueOf('\u306e'), "<sup>1</sup>/<sub>3</sub>");
        gaijiMap.put(Character.valueOf('\u7dbe'), "\u6963");
        gaijiMap.put(Character.valueOf('\u9b8e'), "\u598d");
        gaijiMap.put(Character.valueOf('\u3042'), "\u261e");
        gaijiMap.put(Character.valueOf('\u6216'), "\u762d");
        gaijiMap.put(Character.valueOf('\u4f0a'), "\u9239");
        gaijiMap.put(Character.valueOf('\u7c9f'), "\u8dd7");
        gaijiMap.put(Character.valueOf('\u6697'), "\u58a9");
        gaijiMap.put(Character.valueOf('\u6848'), "\u7646");
        gaijiMap.put(Character.valueOf('\u5b89'), "\u7619");
        gaijiMap.put(Character.valueOf('\u5eb5'), "\u5608");
        gaijiMap.put(Character.valueOf('\u305b'), "\u03b9");
        gaijiMap.put(Character.valueOf('\u4f4d'), "\u82c6");
        gaijiMap.put(Character.valueOf('\u305d'), "\u5350");
        gaijiMap.put(Character.valueOf('\u95c7'), "\u8dd1");
        gaijiMap.put(Character.valueOf('\u305f'), "\u2123");
        gaijiMap.put(Character.valueOf('\u304f'), "\ue200");
        gaijiMap.put(Character.valueOf('\u304a'), "\ue201");
        gaijiMap.put(Character.valueOf('\u304b'), "\ue202");
        gaijiMap.put(Character.valueOf('\u304d'), "\ue203");
        gaijiMap.put(Character.valueOf('\u88b7'), "\ue204");
        gaijiMap.put(Character.valueOf('\u3044'), "\u221a3");
        gaijiMap.put(Character.valueOf('\u3046'), "<sup>3</sup>\u221a9");
        gaijiMap.put(Character.valueOf('\u3048'), "<sup>4</sup>\u221a10");
        GAIJI = Pattern.compile(GAIJI_REGEXP);
        CONJU = Pattern.compile(CONJU_REGEXP);
        MIDASI = Pattern.compile(MIDASI_REGEXP);
        HTM = Pattern.compile(".-([0-9]+)\\.htm");
    }

    public MakeBodyHtml() throws TransformerConfigurationException {
        this.transformer = tFactory.newTransformer(new StreamSource("items2html.xsl"));
        this.nullOut = new StreamResult(new ByteArrayOutputStream(0x100000));
    }

    private String fixItem(String item) {
        String[][] replaces = new String[][]{{"<hr>", "<hr/>"}, {"<a name=\"info1\">&nbsp;</a><span id=\"arrow_info1\" class=\"arrow\"  onClick=\"Display_block('info1')\">\u25bc</span></a>", "<a name=\"info1\">&nbsp;<span id=\"arrow_info1\" class=\"arrow\"  onClick=\"Display_block('info1')\">\u25bc</span></a>"}, {"<a name=\"yougo1\">&nbsp;</a><span id=\"arrow_yougo1\" class=\"arrow\"  onClick=\"Display_block('yougo1')\">\u25bc</span></a>", "<a name=\"yougo1\">&nbsp;<span id=\"arrow_yougo1\" class=\"arrow\"  onClick=\"Display_block('yougo1')\">\u25bc</span></a>"}, {"<a name=\"inyou1\">&nbsp;</a><span id=\"arrow_inyou1\" class=\"arrow\"  onClick=\"Display_block('inyou1')\">\u25bc</span></a>", "<a name=\"inyou1\">&nbsp;<span id=\"arrow_inyou1\" class=\"arrow\"  onClick=\"Display_block('inyou1')\">\u25bc</span></a>"}, {"<span class=\"gogen\">(<\u30ae\u30ea\u30b7\u30a2\u306e\u5730\u65b9Attique)</span>", "<span class=\"gogen\">(\uff1c\u30ae\u30ea\u30b7\u30a2\u306e\u5730\u65b9Attique)</span>"}, {"\uff1ca name=\"yourei_1\">", "<a name=\"yourei_1\">"}, {"<a name=\"kanren1\">&nbsp;</a><span id=\"arrow_kanren1\" class=\"arrow\"  onClick=\"Display_block('kanren1')\">\u25bc</span></a>", "<a name=\"kanren1\">&nbsp;<span id=\"arrow_kanren1\" class=\"arrow\"  onClick=\"Display_block('kanren1')\">\u25bc</span></a>"}, {"<span class=\"gogen\">(<it.)</span>", "<span class=\"gogen\">(\uff1cit.)</span>"}, {"<span class=\"gogen\">(<angl.)</span>", "<span class=\"gogen\">(\uff1cangl.)</span>"}, {"<span class=\"gogen\">(<\u6570\u5b66\u8005Hermite)</span>", "<span class=\"gogen\">(\uff1c\u6570\u5b66\u8005Hermite)</span>"}, {"<span class=\"gogen\">(<\u30a4\u30bf\u30ea\u30a2\u5317\u90e8\u306e\u5ddeLombardie)</span>", "<span class=\"gogen\">(\uff1c\u30a4\u30bf\u30ea\u30a2\u5317\u90e8\u306e\u5ddeLombardie)</span>"}, {"\uff1cspan ", SPAN_START}, {"\uff3b\u4f8b\uff1ah&eacute;mo\uff1ci>rragie</i>\u300c\u51fa\u8840\u300d\uff3d</span>", "\uff3b\u4f8b\uff1ah&eacute;mo<i>rragie</i>\u300c\u51fa\u8840\u300d\uff3d</span>"}, {"<span class=\"gogen\">(<gr.)</span>", "<span class=\"gogen\">(gr.)</span>"}, {"<tr id=\"sub_kanren1\" class=\"block\"><span class=\"tyuki\">(<span class=\"aster\"><td><table>\uff0a</span>", "<tr id=\"sub_kanren1\" class=\"block\"><td><table><span class=\"tyuki\">(<span class=\"aster\">\uff0a</span>"}, {"<span class=\"gogen\">(<\u30bf\u30a4\u738b\u56fd\u306e\u65e7\u79f0Siam)</span>", "<span class=\"gogen\">(\uff1c\u30bf\u30a4\u738b\u56fd\u306e\u65e7\u79f0Siam)</span>"}};
        int i = 0;
        while (i < replaces.length) {
            item = item.replace(replaces[i][0], replaces[i][1]);
            ++i;
        }
        String[][] replaceRegexp = new String[][]{{"(<input[^/<>]+?)>", "$1/>"}};
        int i2 = 0;
        while (i2 < replaceRegexp.length) {
            item = item.replaceAll(replaceRegexp[i2][0], replaceRegexp[i2][1]);
            ++i2;
        }
        return item;
    }

    private String fixSpecial(File file, String item) {
        String filename = file.getName().toLowerCase();
        String[][] replaces = FIX_MAP.get(filename);
        if (replaces == null) {
            return item;
        }
        int i = 0;
        while (i < replaces.length) {
            item = item.replace(replaces[i][0], replaces[i][1]);
            ++i;
        }
        return item;
    }

    private String fixHatuonChars(String hatuon) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < hatuon.length()) {
            char c = hatuon.charAt(i);
            String phon = hatuonMap.get(Character.valueOf(c));
            if (phon != null) {
                sb.append(phon);
            } else if ('a' <= c && c <= 'z') {
                sb.append(c);
            } else if (c == '<') {
                int i2 = hatuon.indexOf(62, i);
                if (i2 > 0) {
                    if (i2 + 2 < hatuon.length() && hatuon.charAt(i2 + 2) == '<') {
                        i2 = hatuon.indexOf(62, i2 + 2);
                    }
                    sb.append(hatuon.substring(i, i2 + 1));
                    i = i2;
                } else {
                    System.err.println("invalid hatuon: " + hatuon);
                }
            } else {
                switch (c) {
                    case ' ': 
                    case '(': 
                    case ')': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ';': 
                    case '~': {
                        sb.append(c);
                        break;
                    }
                    default: {
                        System.err.println("unknown " + c + " in " + hatuon);
                        System.exit(1);
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private int[] findHatuon(String item, int i) {
        int idx = item.indexOf(HATUON_START, i);
        if (idx >= 0) {
            int idx2 = item.indexOf("</span>", idx += HATUON_START.length());
            int idx3 = item.indexOf(SPAN_START, idx);
            if (idx3 > 0 && idx3 < idx2) {
                idx3 = item.indexOf("</span>", idx3);
                idx2 = item.indexOf("</span>", idx3 + "</span>".length());
            }
            return new int[]{idx, idx2};
        }
        idx = item.indexOf(PHONETIC_START, i);
        if (idx >= 0) {
            int idx2 = item.indexOf("</span>", idx += PHONETIC_START.length());
            return new int[]{idx, idx2};
        }
        return null;
    }

    private String fixHatuon(String item) {
        StringBuffer sb = new StringBuffer();
        int idx = 0;
        while (idx < item.length()) {
            int[] idxes = this.findHatuon(item, idx);
            if (idxes != null) {
                String hatuon = item.substring(idxes[0], idxes[1]);
                sb.append(item.substring(idx, idxes[0]));
                sb.append(this.fixHatuonChars(hatuon));
                idx = idxes[1];
                continue;
            }
            sb.append(item.substring(idx));
            break;
        }
        return sb.toString();
    }

    static void showGaiji() {
        TreeSet<String> set = new TreeSet<String>(gaijiMap.values());
        for (String s : set) {
            System.err.print(String.format("%s\t0x", s));
            int i = 0;
            while (i < s.length()) {
                System.err.print(String.format("%04X ", s.charAt(i)));
                ++i;
            }
            System.err.println();
        }
    }

    private String fixGaiji(String item) {
        StringBuffer sb = new StringBuffer();
        Matcher m = GAIJI.matcher(item);
        int idx = 0;
        while (m.find()) {
            sb.append(item.substring(idx, m.start()));
            String txt = m.group(1);
            int i = 0;
            while (i < txt.length()) {
                char c = txt.charAt(i);
                String gaiji = gaijiMap.get(Character.valueOf(c));
                if (gaiji != null && gaiji.length() > 0) {
                    if (gaiji.length() == 1) {
                        sb.append(String.format("<gaiji>%x</gaiji>", gaiji.charAt(0)));
                    } else {
                        sb.append(gaiji);
                    }
                } else {
                    System.err.println("unknown gaiji: " + c);
                    sb.append("<span class=\"gaiji\">");
                    sb.append(c);
                    sb.append("</span>");
                }
                ++i;
            }
            idx = m.end();
        }
        if (idx < item.length()) {
            sb.append(item.substring(idx));
        }
        return sb.toString();
    }

    private String getConjuId(File file) throws Exception {
        String line;
        String filename = file.getAbsolutePath().replace(".htm", "_head.htm");
        File headFile = new File(filename);
        if (!headFile.isFile()) {
            return "";
        }
        FileInputStream in = new FileInputStream(headFile);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "Windows-31J"));
        String id = null;
        while ((line = br.readLine()) != null) {
            Matcher m = CONJU.matcher(line);
            if (!m.find()) continue;
            id = m.group(1);
            break;
        }
        br.close();
        ((InputStream)in).close();
        return id;
    }

    private boolean checkItem(String dt, String dd) {
        String txt = "<?xml version=\"1.0\"?><!DOCTYPE Dummy PUBLIC \"Dummy\" \"dtd/Dummy.dtd\" [<!ENTITY % ISOCommon PUBLIC \"-//ISO//ISO Common//EN\" \"dtd/ISOCommon.dtd\" >%ISOCommon;]><royal>" + dt + dd + "</royal>";
        try {
            StreamSource in = new StreamSource(new ByteArrayInputStream(txt.getBytes("UTF-8")));
            this.transformer.transform(in, this.nullOut);
            return true;
        }
        catch (Exception e) {
            System.err.println("WARN: invalid item text found at \"" + dt + "\"");
            this.invalidItems.add(dt);
            this.invalidItems.add(dd);
            return false;
        }
    }

    private String appendMidasi(String item, String conjuId) {
        Matcher m = MIDASI.matcher(item);
        if (m.find()) {
            String dt = String.format("<dt id=\"%s\">%s</dt>", m.group(1), m.group(2));
            String dd = item.substring(m.start());
            if (conjuId != null) {
                dt = String.valueOf(dt) + "<conju>" + conjuId + "</conju>";
            }
            if (this.checkItem(dt, dd)) {
                return String.valueOf(item.substring(0, m.start())) + dt + dd;
            }
            return "";
        }
        return item;
    }

    private void loadOneItemPage(File file) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(file);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "Windows-31J"));
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("<body ")) break;
        }
        sb.append(line);
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            sb.append(line);
            if (line.startsWith("</body>")) break;
        }
        String conjuId = this.getConjuId(file);
        String item = this.fixItem(sb.toString());
        item = this.fixSpecial(file, item);
        item = this.fixHatuon(item);
        item = this.fixGaiji(item);
        item = this.appendMidasi(item, conjuId);
        if (file.getName().equals("r-02616.htm")) {
            item = item.replace("<dt id=\"R-02616\">retraiter</dt><body onLoad=\"init('R-02616')\">", "<dt id=\"R-02615\">retraiter</dt><body onLoad=\"init('R-02615')\">");
            item = item.replace("<span class=\"doui\">(=battre an retraite)</span><a name=\"page_top\"><span class=\"midasi\">retranchement</span></a>", "<span class=\"doui\">(=battre an retraite)</span></td></tr></table><hr/></body>" + System.getProperty("line.separator") + "<dt id=\"R-02616\">retranchement</dt><body onLoad=\"init('R-02616')\"><table><tr><td><a name=\"page_top\"><span class=\"midasi\">retranchement</span></a>");
        }
        System.out.println(item);
        br.close();
        ((InputStream)in).close();
    }

    private int maxFileId(File dir) throws Exception {
        int max = 0;
        String[] stringArray = dir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            int id;
            String file = stringArray[n2];
            Matcher m = HTM.matcher(file);
            if (m.find() && (id = Integer.parseInt(m.group(1))) > max) {
                max = id;
            }
            ++n2;
        }
        return max;
    }

    private void loadItemPages(String dirname, File dir) throws Exception {
        int n = this.maxFileId(dir);
        int i = 1;
        while (i <= n) {
            String filename = String.format("%s-%05d.htm", dirname, i);
            File file = new File(dir.getAbsolutePath(), filename);
            if (file.isFile()) {
                this.loadOneItemPage(file);
                ++this.nLoaded;
                if (this.nLoaded % 1000 == 0) {
                    System.err.print(".");
                }
            } else {
                System.err.println();
                System.err.println("WARN: cannot find " + filename + ", skip it!");
            }
            ++i;
        }
    }

    private void outHeader() throws Exception {
        System.out.println("<?xml version=\"1.0\"?>");
        System.out.println("<!DOCTYPE Dummy PUBLIC \"Dummy\" \"dtd/Dummy.dtd\" [");
        System.out.println("<!ENTITY % ISOCommon PUBLIC \"-//ISO//ISO Common//EN\" \"dtd/ISOCommon.dtd\" >");
        System.out.println("%ISOCommon;");
        System.out.println("]>");
        System.out.println("<royal>");
    }

    private void outTail() throws Exception {
        System.out.println("</royal>");
    }

    static void checkDirectory(File dir) {
        if (!dir.isDirectory()) {
            System.err.println("**************************");
            if (dir.exists()) {
                System.err.println("ERROR: " + dir + " is not a directory.");
            } else {
                System.err.println("ERROR: cannot find " + dir);
            }
            System.err.println("**************************");
            System.exit(1);
        }
    }

    private void loadItemPages(String path) throws Exception {
        File dir = new File(path);
        MakeBodyHtml.checkDirectory(dir);
        String dirname = dir.getName();
        this.outHeader();
        if (dirname.length() == 1) {
            this.loadItemPages(dirname, dir);
        } else {
            char c = 'a';
            while (c <= 'z') {
                System.err.print(c);
                dir = new File(path, Character.toString(c));
                dirname = dir.getName();
                this.loadItemPages(dirname, dir);
                c = (char)(c + '\u0001');
            }
        }
        this.outTail();
        System.err.println();
        System.err.println("done. " + this.nLoaded + " entries");
        if (!this.invalidItems.isEmpty()) {
            PrintWriter w = new PrintWriter(new File("erritems.txt"), "UTF-8");
            int i = 0;
            for (String t : this.invalidItems) {
                if (i % 2 == 0) {
                    w.println("===========================");
                }
                w.println(t);
                ++i;
            }
            w.flush();
            w.close();
            System.err.println("WARN: " + this.invalidItems.size() / 2 + " invalid entries found. See erritems.txt");
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            ZephyrUtil.setUTF8Ouput();
            try {
                MakeBodyHtml app = new MakeBodyHtml();
                app.loadItemPages(args[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Usage: java MakeBodyHtml <SOME_DIR>/royal/contents/fr/itempages{/[a-z]}");
        }
    }
}

