/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.petitroyal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import zephyr.util.UTF8toSJIS;
import zephyr.util.ZephyrUtil;

public class MakeBodyHtml {
    private static final TransformerFactory tFactory = TransformerFactory.newInstance();
    private final Transformer transformer;
    private final StreamResult nullOut;
    private final int version;
    private static final String[][] REPLACES_COMMON = new String[][]{{"\n", " "}, {"<br>", "<br/>"}, {"<span class='stm'>\u00e9\u306e<\u306e\u8a18\u53f7</span>", "<span class='stm'>\u00e9\u306e\u02ca\u306e\u8a18\u53f7</span>"}, {"<td colspan='3' class='kju'>\u25c6\u6bcd\u97f3\u307e\u305f\u306f\u7121\u97f3\u306e\uff48\u3067\u59cb\u307e\u308b\u7537\u6027\u5358\u6570\u540d\u8a5e\u306e\u524d\u3067\u306fcet\u3092\u7528\u3044\uff0c\u30ea\u30a8\u30be\u30f3\u3059\u308b</span></td>", "<td colspan='3' class='kju'>\u25c6\u6bcd\u97f3\u307e\u305f\u306f\u7121\u97f3\u306e\uff48\u3067\u59cb\u307e\u308b\u7537\u6027\u5358\u6570\u540d\u8a5e\u306e\u524d\u3067\u306fcet\u3092\u7528\u3044\uff0c\u30ea\u30a8\u30be\u30f3\u3059\u308b</td>"}, {"<span class='yri'>semelles <i>compensees<</i></span>", "<span class='yri'>semelles <i>compensees</i></span>"}, {"&copy;", "\u00a9"}, {"<b>\u4fa1\u5024</b>\u3092\u4e0b\u3052\u308b&</span>", "<b>\u4fa1\u5024</b>\u3092\u4e0b\u3052\u308b</span>"}, {"<table class='hyou'>  <tt>", "<table class='hyou'>  <tr>"}, {"desquelles</span></td></tr></td></tr></table></span></td></tr>", "desquelles</td></tr></table></span></td></tr>"}, {"<span class='yry'>\u7db4\u308a\u5b57\u8a18\u53f7</span> \u02ca  \u02cb \u02c6  \u0308 \u306a\u3069</span>", "<span class='yry'>\u7db4\u308a\u5b57\u8a18\u53f7</span> \u02ca  \u02cb \u02c6  \u0308 \u306a\u3069"}, {"<td>son <span class='phn'>s\u0254\u0303 \u30bd<span class='skan'>\u30f3</span></td>", "<td>son <span class='phn'>s\u0254\u0303 \u30bd</span><span class='skan'>\u30f3</span></td>"}, {"<span class='phn'>se-za-mi</span></span>  </td></tr></table></span></td></tr><tr><td>", "<span class='phn'>se-za-mi</span></td></tr></table></span></td></tr><tr><td>"}, {"<td>ton <span class='phn'>t\u0254\u0303 \u30c8<span class='skan'>\u30f3</span></td>", "<td>ton <span class='phn'>t\u0254\u0303 \u30c8</span><span class='skan'>\u30f3</span></td>"}, {"<span class='phn'>tut</span>\u3068\u306a\u308b</span><br />", "<span class='phn'>tut</span>\u3068\u306a\u308b</td></tr></table></span><br />"}, {"<span class='phn'>tuz</span>\u3068\u306a\u308b</span><br />\u25c6tous\u304c\u4ee3\u540d\u8a5e\u306e\u3068\u304d\u306f\u5e38\u306b<span class='phn'>tus</span>\u3068\u767a\u97f3\u3059\u308b</td></tr></table></span><span class='rsm'></span></td></tr>", "<span class='phn'>tuz</span>\u3068\u306a\u308b<br />\u25c6tous\u304c\u4ee3\u540d\u8a5e\u306e\u3068\u304d\u306f\u5e38\u306b<span class='phn'>tus</span>\u3068\u767a\u97f3\u3059\u308b</td></tr><span class='rsm'></span>"}, {"<td>un <span class='phn'>\u0153\u0303 \u30a2<span class='skan'>\u30f3</span></td>", "<td>un <span class='phn'>\u0153\u0303 \u30a2</span><span class='skan'>\u30f3</span></td>"}, {"<span class='ykg'>$\u6fc0\u3057\u3044\u82e6\u75db&</span>", "<span class='ykg'>\u6fc0\u3057\u3044\u82e6\u75db</span>"}};
    private static final String[][] REPLACES_20100831 = new String[][]{{"<span class='gng'>\u65b0\u3057\u3044\u91d8\u304c\u53e4\u3044\u91d8\u3092\u62bc\u3057\u51fa\u3059</span></td></tr>", "<span class='gng'>\u65b0\u3057\u3044\u91d8\u304c\u53e4\u3044\u91d8\u3092\u62bc\u3057\u51fa\u3059</span></td></tr></td></tr></table></td></tr>"}, {"\uff08\uff1d\u6d3b\u7528de<clinaison\uff09", "\uff08\uff1d\u6d3b\u7528declinaison\uff09"}};
    private static final int VERKEY_20100217 = 20100217;
    private static final int VERKEY_20100831 = 20100831;
    private static final long DBSIZE_20100217 = 182184960L;
    private static final long DBSIZE_20100831 = 0xADD0000L;
    private final LinkedList<String> invalidItems = new LinkedList();
    private static final String CONJU_HEADER_REGEXP = "id='conjuBtn' value='\u6d3b\u7528\u8868' onClick=\"showCTable\\('(.+?)'\\)\"";
    private static final Pattern CONJU_HEADER = Pattern.compile("id='conjuBtn' value='\u6d3b\u7528\u8868' onClick=\"showCTable\\('(.+?)'\\)\"");
    private final LinkedList<String> invConj = new LinkedList();
    private static final String MIDASI_REGEXP = "<td class='midasi' name='top'><span class='mid' id='[0-9]+'>(.+)</span>";
    private static final Pattern MIDASI = Pattern.compile("<td class='midasi' name='top'><span class='mid' id='[0-9]+'>(.+)</span>");
    private static final String[][] RANK_FIX = new String[21][2];
    private static final String ITEM_REGEXP = "<tr><td><span class=[\"']mid[\"'] rank=[\"']([0-9]+)[\"']>(.*)</td></tr>";
    private static final Pattern ITEM;

    static {
        MakeBodyHtml.RANK_FIX[20][0] = "<b>*** ";
        MakeBodyHtml.RANK_FIX[20][1] = "</b>";
        MakeBodyHtml.RANK_FIX[10][0] = "<b>** ";
        MakeBodyHtml.RANK_FIX[10][1] = "</b>";
        MakeBodyHtml.RANK_FIX[11][0] = "<b>* ";
        MakeBodyHtml.RANK_FIX[11][1] = "</b>";
        MakeBodyHtml.RANK_FIX[12][0] = "<b>";
        MakeBodyHtml.RANK_FIX[12][1] = "</b>";
        MakeBodyHtml.RANK_FIX[0][0] = "<b>";
        MakeBodyHtml.RANK_FIX[0][1] = "</b>";
        MakeBodyHtml.RANK_FIX[13][0] = "";
        MakeBodyHtml.RANK_FIX[13][1] = "";
        ITEM = Pattern.compile(ITEM_REGEXP);
    }

    MakeBodyHtml(String[] args) throws Exception {
        this.transformer = tFactory.newTransformer(new StreamSource("items2html.xsl"));
        this.nullOut = new StreamResult(new ByteArrayOutputStream(0x100000));
        this.version = this.checkVersion(args);
    }

    private int checkVersion(String[] args) throws Exception {
        File db = new File(args[0]);
        String ver = args.length >= 2 ? args[1] : "";
        System.err.println("\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba:" + db.length());
        if (db.length() == 182184960L || ver.equals(Integer.toString(20100217))) {
            System.err.println("2010/02/17\u7248\u30c7\u30fc\u30bf\u3068\u3057\u3066\u51e6\u7406\u3057\u307e\u3059");
            return 20100217;
        }
        if (db.length() == 0xADD0000L || ver.equals(Integer.toString(20100831))) {
            System.err.println("2010/08/31\u7248\u30c7\u30fc\u30bf\u3068\u3057\u3066\u51e6\u7406\u3057\u307e\u3059");
        } else {
            if (!ver.isEmpty()) {
                throw new Exception("\u6307\u5b9a\u3067\u304d\u308b\u306e\u306f 20100217, 20100831\u3060\u3051\u3067\u3059");
            }
            System.err.println("\u672a\u77e5\u306e\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba\u3067\u3059\u3002");
            System.err.println("http://sourceforge.jp/forum/forum.php?forum_id=28849 \u307e\u3067\u3054\u9023\u7d61\u304f\u3060\u3055\u3044\u3002");
            System.err.println("2010/08/31\u7248\u3068\u3057\u3066\u51e6\u7406\u3057\u307e\u3059\u3002");
        }
        return 20100831;
    }

    private String fixItem(String item, String[][] replaces) {
        int i = 0;
        while (i < replaces.length) {
            item = item.replace(replaces[i][0], replaces[i][1]);
            ++i;
        }
        return item;
    }

    private String fixItem(String item) {
        String result = this.fixItem(item, REPLACES_COMMON);
        if (this.version == 20100831) {
            result = this.fixItem(result, REPLACES_20100831);
        }
        return result;
    }

    private String checkItem(String dt, String dd) {
        String txt = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><html><body><dt>" + dt + "</dt><dd>" + dd + "</dd></body></html>";
        try {
            StreamSource in = new StreamSource(new ByteArrayInputStream(txt.getBytes("UTF-8")));
            this.transformer.transform(in, this.nullOut);
            return dd;
        }
        catch (Exception e) {
            System.err.println("WARN: invalid item text found at \"" + dt + "\"");
            this.invalidItems.add(dt);
            this.invalidItems.add(dd);
            return "<tr><td>*** invalid item text ***</td></tr>";
        }
    }

    private String conjuRef(String dt, String header) throws Exception {
        Matcher m = CONJU_HEADER.matcher(header);
        if (m.find()) {
            String id = m.group(1);
            if (id.matches("[A-Z][0-9]+")) {
                return "<conju>" + id + "</conju>";
            }
            String key = dt.replaceAll("<.+?>", "").replaceAll(",.*$", "");
            key = UTF8toSJIS.convert(key);
            this.invConj.add(key);
            return "";
        }
        return "";
    }

    private String getHead(String itemData) {
        String SPAN_END = "</span>";
        int i = itemData.startsWith("<span ") ? itemData.indexOf("</span>") + "</span>".length() : 0;
        if ((i = itemData.indexOf("</span>", i)) > 0) {
            return itemData.substring(0, i);
        }
        System.err.println("ERROR: cannot find head: " + itemData);
        return "###";
    }

    private String auxMidasi(String header) {
        String[] midasi;
        Matcher m = MIDASI.matcher(header);
        if (m.find() && (midasi = m.group(1).split(", *")).length > 1) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < midasi.length) {
                sb.append("<key type=\"\u8868\u8a18\">");
                sb.append(midasi[i]);
                sb.append("</key>");
                ++i;
            }
            return sb.toString();
        }
        return "";
    }

    public void loadItems(String dbName) throws Exception {
        Class.forName("org.sqlite.JDBC");
        Connection conn = DriverManager.getConnection("jdbc:sqlite:" + dbName);
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select id,header,html from items;");
        System.out.println("<html><body>");
        int nEntry = 0;
        while (rs.next()) {
            String id = rs.getString("id");
            String item = rs.getString("html");
            String header = rs.getString("header");
            Matcher m = ITEM.matcher(item);
            if (m.find()) {
                String t;
                int rank = Integer.parseInt(m.group(1));
                String dt = this.getHead(m.group(2));
                String dd = this.fixItem(item);
                int idx = (dd = this.checkItem(dt, dd)).indexOf(t = ">" + dt + "</span>");
                if (idx >= 0) {
                    dd = String.valueOf(dd.substring(0, idx)) + "></span>" + dd.substring(idx + t.length());
                }
                System.out.print("<dt id=\"");
                System.out.print(id);
                System.out.print("\">");
                System.out.print(RANK_FIX[rank][0]);
                System.out.print(dt);
                System.out.print(RANK_FIX[rank][1]);
                System.out.print("</dt>");
                System.out.print(this.auxMidasi(header));
                System.out.print("<dd>");
                System.out.print(this.conjuRef(dt, header));
                System.out.print(dd);
                System.out.println("</dd>");
                if (++nEntry % 1000 != 0) continue;
                System.err.print(".");
                continue;
            }
            System.err.println("ERROR: " + (String)item);
        }
        System.out.println("</body></html>");
        rs.close();
        conn.close();
        System.err.println();
        System.err.println("done. " + nEntry + " entries");
        if (!this.invConj.isEmpty()) {
            System.err.print("WARN: invalid conju id :");
            for (String dt : this.invConj) {
                System.err.print(" " + dt);
            }
            System.err.println();
        }
        if (!this.invalidItems.isEmpty()) {
            PrintWriter w = new PrintWriter(new File("erritems.txt"), "UTF-8");
            int i = 0;
            for (String t : this.invalidItems) {
                if (i % 2 == 0) {
                    w.println("===========================");
                }
                w.println(t);
                ++i;
            }
            w.flush();
            w.close();
            System.err.println("WARN: " + this.invalidItems.size() / 2 + " invalid entries found. See erritems.txt");
        }
    }

    static void checkDBFile(String dbName) {
        File f = new File(dbName);
        if (!f.isFile()) {
            System.err.println("**************************");
            System.err.println("ERROR: cannot find " + dbName);
            System.err.println("**************************");
            System.exit(1);
        }
        if (f.length() == 0L) {
            System.err.println("**************************");
            System.err.println("ERROR: invalid " + dbName + ", size=0");
            System.err.println("**************************");
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        String dbName = args.length == 0 ? "petit.sql" : args[0];
        MakeBodyHtml.checkDBFile(dbName);
        try {
            ZephyrUtil.setUTF8Ouput();
            MakeBodyHtml app = new MakeBodyHtml(args);
            app.loadItems(dbName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

