/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.readers3;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.kenkyusha.readers3.R3Gaiji;
import zephyr.util.ZephyrUtil;

public class MakeBodyHtml {
    private static final HashMap<Character, Character> zenhanMap = new HashMap();
    private static final TreeSet<Character> unknownHanSet = new TreeSet();
    private final R3Gaiji gaiji;
    private static final String RET;
    private static final HashMap<String, String> eb2htmlMap;
    private static final String EP_DT_START = "<1F09><0001><1F41><0160>";
    private static final String EP_ANKER = "<1F09><9999>";
    private static final int EPTAG_LEN;
    private final LinkedList<String> closeTags = new LinkedList();
    private String dtId = "";
    private final HashSet<String> posSet = new HashSet();
    public static final String IDIOM_EN = "<idiom/>";
    public static final String IDIOM_JP = "<idiomjp/>";
    private static final Pattern EP_REF;
    private static final Pattern SUBSECTION;
    private static final String DD_START = "<dd>";
    private static final Pattern SMCE_S;

    static {
        zenhanMap.put(Character.valueOf('\uff0e'), Character.valueOf('.'));
        zenhanMap.put(Character.valueOf('\uff0c'), Character.valueOf(','));
        zenhanMap.put(Character.valueOf('\u3000'), Character.valueOf(' '));
        zenhanMap.put(Character.valueOf('\uff08'), Character.valueOf('('));
        zenhanMap.put(Character.valueOf('\uff09'), Character.valueOf(')'));
        zenhanMap.put(Character.valueOf('\uff3b'), Character.valueOf('['));
        zenhanMap.put(Character.valueOf('\uff3d'), Character.valueOf(']'));
        zenhanMap.put(Character.valueOf('\uff01'), Character.valueOf('!'));
        zenhanMap.put(Character.valueOf('\uff1f'), Character.valueOf('?'));
        zenhanMap.put(Character.valueOf('\uff0b'), Character.valueOf('+'));
        zenhanMap.put(Character.valueOf('\uff0d'), Character.valueOf('-'));
        zenhanMap.put(Character.valueOf('\uff0a'), Character.valueOf('*'));
        zenhanMap.put(Character.valueOf('\uff0f'), Character.valueOf('/'));
        zenhanMap.put(Character.valueOf('\u2019'), Character.valueOf('\''));
        zenhanMap.put(Character.valueOf('\uff1a'), Character.valueOf(':'));
        zenhanMap.put(Character.valueOf('\uff1b'), Character.valueOf(';'));
        zenhanMap.put(Character.valueOf('\uff06'), Character.valueOf('&'));
        zenhanMap.put(Character.valueOf('\uff3e'), Character.valueOf('^'));
        zenhanMap.put(Character.valueOf('\uff5c'), Character.valueOf('|'));
        zenhanMap.put(Character.valueOf('\uff1d'), Character.valueOf('='));
        zenhanMap.put(Character.valueOf('\u30fb'), Character.valueOf('\u00b7'));
        String zenzen = "\u30fc\u300a\u300b\u2015\u3008\u3009\u25c6\u00b0\u21d2\u00b4\uff40\u2032\u2033\uffe0\u2026\u4e00\uff1c\uff1e\u00a7\u00a8\u00d7\u2191\u2193\u300c\u300d\uff5e\u2018\uffe3]";
        int i = 0;
        while (i < zenzen.length()) {
            char c = zenzen.charAt(i);
            zenhanMap.put(Character.valueOf(c), Character.valueOf(c));
            ++i;
        }
        RET = System.getProperty("line.separator");
        eb2htmlMap = new HashMap();
        eb2htmlMap.put("1F42", "{a}");
        eb2htmlMap.put("1F62", "{/a}");
        eb2htmlMap.put("1F06", "<sub>");
        eb2htmlMap.put("1F07", "</sub>");
        eb2htmlMap.put("1F0E", "<sup>");
        eb2htmlMap.put("1F0F", "</sup>");
        EPTAG_LEN = "<xxxx>".length();
        EP_REF = Pattern.compile("<1F62>\\[0*([0-9A-F]+):0([0-9A-F]+)\\]");
        SUBSECTION = Pattern.compile("<p>[\u3000 ]*(\u25ba(<i>[^<]+?</i>(, <i>[^<]+?</i>)*))");
        SMCE_S = Pattern.compile("\uff33\uff2d\uff23\uff1a\uff25([^\\[\\]]+?)\uff33\uff2d\uff23\uff1a\uff33");
    }

    MakeBodyHtml() throws Exception {
        this.gaiji = new R3Gaiji("GaijiMap.xml");
    }

    private static char zen2han(char c) {
        if ('\uff10' <= c && c <= '\uff19') {
            return (char)(48 + (c - 65296));
        }
        if ('\uff21' <= c && c <= '\uff3a') {
            return (char)(65 + (c - 65313));
        }
        if ('\uff41' <= c && c <= '\uff5a') {
            return (char)(97 + (c - 65345));
        }
        if (c <= '~') {
            return c;
        }
        Character han = zenhanMap.get(Character.valueOf(c));
        if (han != null) {
            return han.charValue();
        }
        unknownHanSet.add(Character.valueOf(c));
        return '#';
    }

    private String ep2html(String line, HashSet<String> refs) {
        String brRetP;
        String pos;
        boolean isRefered;
        StringBuilder sb = new StringBuilder();
        boolean bZenkaku = true;
        int i = line.indexOf(93);
        String[] v = line.substring(1, i).replace(" ", "0").split(":");
        if (v[1].equals("800")) {
            v[0] = String.format("%X", Integer.parseInt(v[0], 16) + 1);
            v[1] = "000";
        }
        if (!(isRefered = refs.contains(pos = String.valueOf(v[0]) + v[1])) && line.substring(++i).startsWith(EP_ANKER)) {
            return "";
        }
        boolean inDT = false;
        if (isRefered) {
            brRetP = "</p>" + RET + "<p id=\"" + pos + "\">";
            this.posSet.add(pos);
        } else {
            brRetP = "</p>" + RET + "<p>";
        }
        while (i < line.length()) {
            char c;
            block153: {
                String code;
                c = line.charAt(i);
                if (c != '<') break block153;
                switch (code = line.substring(i + 1, i + 5)) {
                    case "1FE0": {
                        String code2;
                        switch (code2 = line.substring(i + 7, i + 11)) {
                            case "0001": {
                                sb.append("<i>");
                                this.closeTags.addFirst("</i>");
                                break;
                            }
                            case "0000": 
                            case "0003": {
                                if (inDT) break;
                                sb.append("<b>");
                                this.closeTags.addFirst("</b>");
                            }
                        }
                        i += 2 * EPTAG_LEN;
                        break;
                    }
                    case "1F09": {
                        String code2;
                        String codeX = line.substring(i);
                        if (codeX.startsWith(EP_DT_START)) {
                            if (!this.closeTags.isEmpty()) {
                                System.err.println("missing closeTags before " + pos);
                            }
                            if (isRefered) {
                                sb.append("<dt id=\"" + pos + "\">");
                                isRefered = false;
                            } else {
                                sb.append("<dt>");
                            }
                            this.dtId = pos;
                            inDT = true;
                            i += EP_DT_START.length();
                            break;
                        }
                        switch (code2 = line.substring(i + 7, i + 11)) {
                            case "0003": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0004": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0005": {
                                sb.append(String.valueOf(brRetP) + "\u3000");
                                break;
                            }
                            case "0020": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0030": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0103": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0101": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0104": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0008": 
                            case "0028": 
                            case "0038": {
                                sb.append(String.valueOf(brRetP) + "\u3000- ");
                                break;
                            }
                            case "0009": 
                            case "0029": 
                            case "0039": {
                                sb.append("\u3000");
                                break;
                            }
                            case "0106": {
                                sb.append(String.valueOf(brRetP) + IDIOM_EN);
                                break;
                            }
                            case "0107": {
                                sb.append(String.valueOf(brRetP) + IDIOM_JP + "\u3000");
                                break;
                            }
                            default: {
                                System.err.println("Unknown 1F09 " + code2);
                            }
                            case "0002": 
                            case "0010": 
                            case "0013": 
                            case "0014": 
                            case "0015": 
                            case "0018": 
                            case "0019": 
                            case "0023": 
                            case "0024": 
                            case "0025": 
                            case "0033": 
                            case "0034": 
                            case "0035": 
                            case "0040": 
                            case "0100": 
                            case "0105": 
                            case "0109": 
                            case "0113": 
                            case "0115": 
                            case "0117": 
                            case "0119": 
                            case "0120": 
                            case "0127": 
                            case "0129": 
                            case "9999": 
                        }
                        i += 2 * EPTAG_LEN;
                        break;
                    }
                    case "1F61": {
                        if (inDT) {
                            sb.append("</dt><dd><p>");
                            inDT = false;
                        }
                        i += EPTAG_LEN;
                        break;
                    }
                    case "1F04": {
                        bZenkaku = false;
                        i += EPTAG_LEN;
                        break;
                    }
                    case "1F05": {
                        bZenkaku = true;
                        i += EPTAG_LEN;
                        break;
                    }
                    case "1FE1": {
                        for (String closeTag : this.closeTags) {
                            sb.append(closeTag);
                        }
                        this.closeTags.clear();
                        i += EPTAG_LEN;
                        break;
                    }
                    case "1F4A": {
                        sb.append("\u3000\u97f3\u58f0");
                        i += 3 * EPTAG_LEN;
                        i = line.indexOf(93, i);
                        i = line.indexOf(93, i + 1) + 1;
                        break;
                    }
                    default: {
                        if (code.compareTo("A121") >= 0 && code.compareTo("FE7E") <= 0) {
                            sb.append(this.gaiji.gaiji(code));
                        } else {
                            String tag = eb2htmlMap.get(code);
                            if (tag != null) {
                                sb.append(tag);
                            }
                        }
                        i += EPTAG_LEN;
                        break;
                    }
                }
                continue;
            }
            if (bZenkaku) {
                sb.append(c);
            } else {
                sb.append(MakeBodyHtml.zen2han(c));
            }
            ++i;
        }
        String l = sb.toString();
        if (inDT) {
            l = String.valueOf(l) + "</dt><dd><p>";
        }
        return l;
    }

    private HashSet<String> findRefs(String filename) throws Exception {
        String line;
        HashSet<String> refs = new HashSet<String>();
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "Windows-31J"));
        br.readLine();
        br.readLine();
        while ((line = br.readLine()) != null) {
            Matcher m = EP_REF.matcher(line);
            while (m.find()) {
                refs.add(String.valueOf(m.group(1)) + m.group(2));
            }
        }
        br.close();
        System.err.println("found " + refs.size() + " unique refs");
        return refs;
    }

    private String fixSMCES(String dd) {
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        Matcher m = SMCE_S.matcher(dd);
        while (m.find()) {
            if (idx < m.start()) {
                sb.append(dd.substring(idx, m.start()));
            }
            sb.append(m.group(1).toUpperCase());
            idx = m.end();
        }
        if (idx < dd.length()) {
            sb.append(dd.substring(idx));
        }
        return sb.toString();
    }

    private String normalize(String dd) {
        dd = dd.replaceAll("(<p[^>]*>)[\u3000 ]*(\\(<b>[0-9]+</b>\\))", "$1\u3000$2");
        dd = dd.replace("\u25ba", "</p><p>\u25ba");
        dd = dd.replaceAll("([^ \u3000])\u25c6", "$1\u3000\u25c6");
        dd = dd.replaceAll("(<p[^>]*>\u3000*<i>[a-z]+</i>(, *<i>[a-z]+</i>)*) *", "$1\u3000");
        dd = this.fixSMCES(dd);
        dd = dd.replaceAll("\\{a\\}([^\\{\\}]+?)\\{/a\\}\\[0*([0-9A-F]+):0([0-9A-F]+)\\]", "<a href=\"#$2$3\">$1</a>");
        dd = dd.replaceAll("[\u3000 ]+</p>", "</p>");
        if ((dd = dd.replaceAll("<p[^>]*></p>", "")).length() > 1000) {
            Matcher m = SUBSECTION.matcher(dd);
            StringBuilder dd2 = null;
            StringBuilder subToc = null;
            int idx = 0;
            int subIdx = 0;
            while (m.find()) {
                if (subToc == null) {
                    dd2 = new StringBuilder();
                    subToc = new StringBuilder();
                }
                if (idx < m.start()) {
                    dd2.append(dd.substring(idx, m.start()));
                }
                String subId = String.valueOf(this.dtId) + "." + ++subIdx;
                dd2.append("<p id=\"");
                dd2.append(subId);
                dd2.append("\">");
                dd2.append(m.group(1));
                if (subIdx >= 2) {
                    subToc.append("\u3000");
                }
                subToc.append("\u2192<a href=\"#");
                subToc.append(subId);
                subToc.append("\">");
                subToc.append(m.group(2));
                subToc.append("</a>");
                idx = m.end();
            }
            if (dd2 != null && subIdx >= 2) {
                if (idx < dd.length()) {
                    dd2.append(dd.substring(idx));
                }
                dd = dd2.toString();
                idx = dd.indexOf(DD_START) + DD_START.length();
                dd = String.valueOf(dd.substring(0, idx)) + "<p>" + subToc.toString().trim() + "</p>" + RET + dd.substring(idx).trim();
            }
        }
        return dd;
    }

    private void parse(String filename) throws Exception {
        String line;
        HashSet<String> refs = this.findRefs(filename);
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "Windows-31J"));
        br.readLine();
        br.readLine();
        StringBuilder sb = null;
        System.out.println("<html><body>");
        while ((line = br.readLine()) != null) {
            String html;
            if ((line = line.trim()).isEmpty() || (html = this.ep2html(line, refs)).isEmpty()) continue;
            if (sb == null) {
                sb = new StringBuilder();
            } else if (html.startsWith("<dt") && sb != null) {
                System.out.println(String.valueOf(this.normalize(sb.toString())) + "</p></dd>");
                sb = new StringBuilder();
            }
            sb.append(html);
        }
        br.close();
        if (sb != null) {
            System.out.println(String.valueOf(this.normalize(sb.toString())) + "</p></dd>");
        }
        System.out.println("</body></html>");
        if (!unknownHanSet.isEmpty()) {
            System.err.println("WARN: Unknown Hankaku characters");
            System.err.println(unknownHanSet.toString());
        }
        TreeSet<String> unknownPosSet = new TreeSet<String>();
        for (String refPos : refs) {
            if (this.posSet.contains(refPos)) continue;
            unknownPosSet.add(refPos);
        }
        if (!unknownPosSet.isEmpty()) {
            System.err.println("WARN: Unknown Pos: " + unknownPosSet.size());
            System.err.println(unknownPosSet.toString());
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            ZephyrUtil.setUTF8Ouput();
            MakeBodyHtml app = new MakeBodyHtml();
            try {
                app.parse(args[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Usage: java MakeBodyHtml SOME_DIR/readers3.txt");
        }
    }
}

