/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.readers3;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import zephyr.kenkyusha.readers3.IrregularVerbs;
import zephyr.util.MultiHashMap;

public class Lemmatizer {
    private static final HashMap<String, String> postsMap = new LinkedHashMap<String, String>();
    private static final HashSet<String> lemmaSet;
    private static final String WORDNET_LEMMA_FILENAME = "wordnet-lemma.txt";
    private static final MultiHashMap<String, String> excMap;
    private static final String WORDNET_EXC_FILENAME = "wordnet-exc.txt";

    static {
        postsMap.put("s", "");
        postsMap.put("ses", "s");
        postsMap.put("ves", "f");
        postsMap.put("xes", "x");
        postsMap.put("zes", "z");
        postsMap.put("ches", "ch");
        postsMap.put("shes", "sh");
        postsMap.put("men", "man");
        postsMap.put("ies", "y");
        postsMap.put("s", "");
        postsMap.put("ies", "y");
        postsMap.put("es", "e");
        postsMap.put("es", "");
        postsMap.put("ed", "e");
        postsMap.put("ed", "");
        postsMap.put("ing", "e");
        postsMap.put("ing", "");
        postsMap.put("er", "");
        postsMap.put("est", "");
        postsMap.put("er", "e");
        postsMap.put("est", "e");
        lemmaSet = new HashSet();
        excMap = new MultiHashMap();
        try {
            Lemmatizer.loadLemma(WORDNET_LEMMA_FILENAME);
        }
        catch (Exception e) {
            System.err.println("cannot load wordnet-lemma.txt");
        }
        try {
            Lemmatizer.loadExc(WORDNET_EXC_FILENAME);
        }
        catch (Exception e) {
            System.err.println("cannot load wordnet-exc.txt");
        }
        int nExc = excMap.size();
        String[][] stringArray = IrregularVerbs.TABLE;
        int n = IrregularVerbs.TABLE.length;
        int n2 = 0;
        while (n2 < n) {
            String[] verbs = stringArray[n2];
            String lemma = verbs[0];
            int i = 1;
            while (i <= 2) {
                String[] stringArray2 = verbs[i].split("[^a-z]+");
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String word = stringArray2[n4];
                    if (!word.isEmpty()) {
                        excMap.putUniq(word, lemma);
                    }
                    ++n4;
                }
                ++i;
            }
            ++n2;
        }
        System.err.println(String.valueOf(nExc) + " -> " + excMap.size());
    }

    private static void loadLemma(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((line = br.readLine()) != null) {
            String word = line.replace('_', ' ');
            lemmaSet.add(word);
        }
        br.close();
        System.err.println("load " + lemmaSet.size() + " entries from " + filename);
    }

    private static void loadExc(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((line = br.readLine()) != null) {
            String[] v = line.split(" ");
            if (v.length != 2) continue;
            excMap.putUniq(v[0], v[1]);
        }
        br.close();
        System.err.println("load " + excMap.size() + " entries from " + filename);
    }

    private static LinkedList<String> makeWordList(String word) {
        LinkedList<String> list = new LinkedList<String>();
        list.add(word);
        return list;
    }

    public static LinkedList<String> lemma(String word) {
        LinkedList<String> lemmaList = excMap.getList(word = word.toLowerCase());
        if (lemmaList != null) {
            return lemmaList;
        }
        for (Map.Entry<String, String> e : postsMap.entrySet()) {
            String post = e.getKey();
            String post2 = e.getValue();
            if (!word.endsWith(post)) continue;
            String word2 = String.valueOf(word.substring(0, word.length() - post.length())) + post2;
            lemmaList = excMap.getList(word2);
            if (lemmaList != null) {
                return lemmaList;
            }
            if (!lemmaSet.contains(word2)) continue;
            return Lemmatizer.makeWordList(word2);
        }
        return Lemmatizer.makeWordList(word);
    }

    private static void test(String word) {
        System.out.println(String.valueOf(word) + "\t" + Lemmatizer.lemma(word));
    }

    public static void main(String[] args) throws Exception {
        Lemmatizer.test("drunken");
        Lemmatizer.test("walking");
        Lemmatizer.test("walk");
        Lemmatizer.test("cat");
        Lemmatizer.test("cats");
        Lemmatizer.test("Cats");
        Lemmatizer.test("best");
        Lemmatizer.test("gone");
        Lemmatizer.test("fast");
        Lemmatizer.test("faster");
        Lemmatizer.test("mentioned");
        Lemmatizer.test("mention");
        Lemmatizer.test("drink");
        Lemmatizer.test("drinks");
        Lemmatizer.test("drunk");
        Lemmatizer.test("drinking");
        Lemmatizer.test("good");
        Lemmatizer.test("better");
        Lemmatizer.test("best");
    }
}

