/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class ZephyrUtil {
    static final HashMap<Character, String> uniChMap = new HashMap();
    public static final String SHIFT_JIS_CODE = "Windows-31J";

    public static String dropMarks(char c) {
        String string = uniChMap.get(Character.valueOf(c));
        if (string != null) {
            return string;
        }
        return Character.toString(c);
    }

    public static String dropMarks(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            String string2 = uniChMap.get(Character.valueOf(c));
            if (string2 != null) {
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String dropTailDigit(String string) {
        if (Character.isDigit(string.charAt(string.length() - 1))) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String hex2uni(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            int n2;
            char c = string.charAt(n);
            if (c == '&' && string.substring(n).startsWith("&#x") && (n2 = string.indexOf(59, n + 1)) > 0) {
                int n3 = Integer.parseInt(string.substring(n + 3, n2), 16);
                stringBuffer.append((char)n3);
                n = n2 + 1;
                continue;
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String makeKey(String string, boolean bl) {
        if (bl) {
            string = ZephyrUtil.dropTailDigit(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(ZephyrUtil.dropMarks(string.charAt(i)));
        }
        return stringBuffer.toString().toLowerCase();
    }

    public static String makeKey(String string) {
        return ZephyrUtil.makeKey(string, true);
    }

    public static void setShiftJisOuput() {
        try {
            PrintStream printStream = new PrintStream((OutputStream)System.out, true, SHIFT_JIS_CODE);
            System.setOut(printStream);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            System.exit(1);
        }
    }

    public static void setUTF8Ouput() {
        try {
            PrintStream printStream = new PrintStream((OutputStream)System.out, true, "UTF-8");
            System.setOut(printStream);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            System.exit(1);
        }
    }

    public static String sed(String string, String[][] stringArray, String[][] stringArray2) {
        int n;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                string = string.replace(stringArray[n][0], stringArray[n][1]);
            }
        }
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                string = string.replaceAll(stringArray2[n][0], stringArray2[n][1]);
            }
        }
        return string;
    }

    public static void unlimitXMLsize() {
        System.setProperty("jdk.xml.entityExpansionLimit", "0");
    }

    static {
        uniChMap.put(Character.valueOf('\u0100'), "A");
        uniChMap.put(Character.valueOf('\u0101'), "a");
        uniChMap.put(Character.valueOf('\u0102'), "A");
        uniChMap.put(Character.valueOf('\u0103'), "a");
        uniChMap.put(Character.valueOf('\u0103'), "a");
        uniChMap.put(Character.valueOf('\u0112'), "E");
        uniChMap.put(Character.valueOf('\u0113'), "e");
        uniChMap.put(Character.valueOf('\u0114'), "E");
        uniChMap.put(Character.valueOf('\u0115'), "e");
        uniChMap.put(Character.valueOf('\u012a'), "I");
        uniChMap.put(Character.valueOf('\u012b'), "i");
        uniChMap.put(Character.valueOf('\u012c'), "I");
        uniChMap.put(Character.valueOf('\u012d'), "i");
        uniChMap.put(Character.valueOf('\u014c'), "O");
        uniChMap.put(Character.valueOf('\u014d'), "o");
        uniChMap.put(Character.valueOf('\u014e'), "O");
        uniChMap.put(Character.valueOf('\u014f'), "o");
        uniChMap.put(Character.valueOf('\u016a'), "U");
        uniChMap.put(Character.valueOf('\u016b'), "u");
        uniChMap.put(Character.valueOf('\u016c'), "U");
        uniChMap.put(Character.valueOf('\u016d'), "u");
        uniChMap.put(Character.valueOf('\u0232'), "Y");
        uniChMap.put(Character.valueOf('\u0233'), "y");
        uniChMap.put(Character.valueOf('\u02d8'), "");
        uniChMap.put(Character.valueOf('\u00c0'), "A");
        uniChMap.put(Character.valueOf('\u00c1'), "A");
        uniChMap.put(Character.valueOf('\u00c2'), "A");
        uniChMap.put(Character.valueOf('\u00c3'), "A");
        uniChMap.put(Character.valueOf('\u00c4'), "A");
        uniChMap.put(Character.valueOf('\u00c6'), "AE");
        uniChMap.put(Character.valueOf('\u00c7'), "C");
        uniChMap.put(Character.valueOf('\u00c8'), "E");
        uniChMap.put(Character.valueOf('\u00c9'), "E");
        uniChMap.put(Character.valueOf('\u00ca'), "E");
        uniChMap.put(Character.valueOf('\u00cb'), "E");
        uniChMap.put(Character.valueOf('\u00cc'), "I");
        uniChMap.put(Character.valueOf('\u00cd'), "I");
        uniChMap.put(Character.valueOf('\u00cf'), "I");
        uniChMap.put(Character.valueOf('\u00ce'), "I");
        uniChMap.put(Character.valueOf('\u00d0'), "D");
        uniChMap.put(Character.valueOf('\u00d1'), "N");
        uniChMap.put(Character.valueOf('\u00d2'), "O");
        uniChMap.put(Character.valueOf('\u00d3'), "O");
        uniChMap.put(Character.valueOf('\u00d4'), "O");
        uniChMap.put(Character.valueOf('\u00d5'), "O");
        uniChMap.put(Character.valueOf('\u00d6'), "O");
        uniChMap.put(Character.valueOf('\u00d8'), "O");
        uniChMap.put(Character.valueOf('\u00d9'), "U");
        uniChMap.put(Character.valueOf('\u00da'), "U");
        uniChMap.put(Character.valueOf('\u00db'), "U");
        uniChMap.put(Character.valueOf('\u00dc'), "U");
        uniChMap.put(Character.valueOf('\u00dd'), "Y");
        uniChMap.put(Character.valueOf('\u00e0'), "a");
        uniChMap.put(Character.valueOf('\u00e1'), "a");
        uniChMap.put(Character.valueOf('\u00e2'), "a");
        uniChMap.put(Character.valueOf('\u00e3'), "a");
        uniChMap.put(Character.valueOf('\u00e4'), "a");
        uniChMap.put(Character.valueOf('\u00e5'), "a");
        uniChMap.put(Character.valueOf('\u00e6'), "ae");
        uniChMap.put(Character.valueOf('\u00e7'), "c");
        uniChMap.put(Character.valueOf('\u00e8'), "e");
        uniChMap.put(Character.valueOf('\u00e9'), "e");
        uniChMap.put(Character.valueOf('\u00ea'), "e");
        uniChMap.put(Character.valueOf('\u00eb'), "e");
        uniChMap.put(Character.valueOf('\u00ec'), "i");
        uniChMap.put(Character.valueOf('\u00ed'), "i");
        uniChMap.put(Character.valueOf('\u00ee'), "i");
        uniChMap.put(Character.valueOf('\u00ef'), "i");
        uniChMap.put(Character.valueOf('\u00f1'), "n");
        uniChMap.put(Character.valueOf('\u00f2'), "o");
        uniChMap.put(Character.valueOf('\u00f3'), "o");
        uniChMap.put(Character.valueOf('\u00f4'), "o");
        uniChMap.put(Character.valueOf('\u00f5'), "o");
        uniChMap.put(Character.valueOf('\u00f6'), "o");
        uniChMap.put(Character.valueOf('\u00f8'), "o");
        uniChMap.put(Character.valueOf('\u00f9'), "u");
        uniChMap.put(Character.valueOf('\u00fa'), "u");
        uniChMap.put(Character.valueOf('\u00fb'), "u");
        uniChMap.put(Character.valueOf('\u00fc'), "u");
        uniChMap.put(Character.valueOf('\u00fd'), "y");
        uniChMap.put(Character.valueOf('\u00ff'), "y");
    }
}

