/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusya.lajp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.ZephyrUtil;

public class MakeBodyHtml {
    static final String ENTRY_DELIM = "======";
    private final HashMap<String, Integer> bodyIdMap = new HashMap();
    private static final String NUM_REGEXP = "^([0-9]+|I+)[ \\.]";
    private static final Pattern NUM = Pattern.compile("^([0-9]+|I+)[ \\.]");
    private static final String REF_PREV = "\u2191";
    private static final String REF_NEXT = "\u2193";
    private static final String REF_REGEXP = "[\u21d2\uff1d] *(.+?)[\uff0e ()\u300b,]";
    private static final Pattern REF = Pattern.compile("[\u21d2\uff1d] *(.+?)[\uff0e ()\u300b,]");
    private static final String REFWORD_REGEXP = "[^/ ]+";
    private static final Pattern REFWORD = Pattern.compile("[^/ ]+");
    private static boolean CHECK_REF = false;
    private static final String PARA_REGEXP = "<p>(<b>)?.+?</p>";
    private static final Pattern PARA = Pattern.compile("<p>(<b>)?.+?</p>");

    private String makeHeadkey(String string) {
        int n = string.indexOf(44);
        if (n > 0) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf(32)) > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private void addBodyIdKey(String string, int n, boolean bl) {
        if (!this.bodyIdMap.containsKey(string)) {
            this.bodyIdMap.put(string, n);
        } else if (bl) {
            // empty if block
        }
    }

    private void loadHeadwords(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        int n = 0;
        boolean bl = true;
        while ((string2 = bufferedReader.readLine()) != null) {
            boolean bl2;
            String string3 = string2.trim();
            if (string3.isEmpty()) continue;
            if (string2.equals(ENTRY_DELIM)) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            String string4 = this.makeHeadkey(string3);
            this.addBodyIdKey(string4, n, true);
            String string5 = ZephyrUtil.makeKey(string4, false);
            boolean bl3 = bl2 = !string4.equals(string5);
            if (bl2) {
                this.addBodyIdKey(string5, n, false);
            }
            if (Character.isDigit(string4.charAt(string4.length() - 1))) {
                this.addBodyIdKey(string4.substring(0, string4.length() - 1), n, false);
                if (bl2) {
                    this.addBodyIdKey(string5.substring(0, string5.length() - 1), n, false);
                }
            }
            ++n;
            bl = false;
        }
        System.err.println("loaded " + n + " entries from " + string);
        bufferedReader.close();
        ((InputStream)fileInputStream).close();
    }

    private Integer getBodyId(String string) {
        Integer n = this.bodyIdMap.get(string);
        if (n != null) {
            return n;
        }
        if (Character.isDigit(string.charAt(string.length() - 1)) && (n = this.bodyIdMap.get(string.substring(0, string.length() - 1))) != null) {
            return n;
        }
        return null;
    }

    private void addKeyHyoki(StringBuffer stringBuffer, String string) {
        String[] stringArray = string.split(", *");
        if (stringArray.length > 1) {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (String string2 : stringArray) {
                String string3 = ZephyrUtil.makeKey(string2, true);
                if (treeSet.contains(string3)) continue;
                stringBuffer.append("<key type=\"\u8868\u8a18\">");
                stringBuffer.append(string3);
                stringBuffer.append("</key>");
                treeSet.add(string3);
            }
        }
    }

    private String fixNumbering(String string) {
        Matcher matcher = NUM.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = "";
            string3 = string3 + "<b>" + string2 + "</b>";
            if (!matcher.group().endsWith(" ")) {
                string3 = string3 + " ";
            }
            string3 = string3 + string.substring(matcher.end(1));
            return string3;
        }
        return string;
    }

    private String makeRefById(int n, String string) {
        return "<a href=\"#" + n + "\">" + string + "</a>";
    }

    private String fixRef(String string) {
        Matcher matcher = REF.matcher(string);
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2;
            Integer n2;
            if (n < matcher.start(1)) {
                stringBuffer.append(string.substring(n, matcher.start(1)));
            }
            if ((n2 = this.getBodyId(string2 = matcher.group(1))) != null) {
                stringBuffer.append(this.makeRefById(n2, string2));
            } else {
                stringBuffer.append(string2);
            }
            n = matcher.end(1);
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private String fixRefInBracket(String string, String string2, int n) {
        int n2;
        int n3 = string.indexOf(65339);
        if (n3 < 0) {
            return string;
        }
        if ((n2 = string.indexOf(65341, ++n3)) < 0) {
            System.err.println("ERROR: " + string);
        }
        String string3 = string.substring(n3, n2);
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = REFWORD.matcher(string3);
        int n4 = 0;
        while (matcher.find()) {
            String string4;
            if (n4 < matcher.start()) {
                stringBuffer.append(string3.substring(n4, matcher.start()));
            }
            if ((string4 = matcher.group()).equals(REF_PREV)) {
                stringBuffer.append(this.makeRefById(n - 1, REF_PREV));
            } else if (string4.equals(REF_NEXT)) {
                stringBuffer.append(this.makeRefById(n + 1, REF_NEXT));
            } else {
                Integer n5 = this.getBodyId(string4);
                if (n5 != null) {
                    stringBuffer.append(this.makeRefById(n5, string4));
                } else {
                    stringBuffer.append(string4);
                    if (CHECK_REF && !string4.startsWith("Gk") && !string4.startsWith("-") && !string4.startsWith("cf.") && string4.charAt(0) < '\u1000') {
                        System.err.println("WARN: cannot find refkey: " + string4 + " at " + string2);
                    }
                }
            }
            n4 = matcher.end();
        }
        if (n4 < string3.length()) {
            stringBuffer.append(string3.substring(n4));
        }
        return string.substring(0, n3) + stringBuffer.toString() + string.substring(n2);
    }

    private String fixIndent(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = PARA.matcher(string);
        int n = 0;
        int n2 = 1;
        boolean bl = false;
        while (matcher.find()) {
            int n3;
            if (n < matcher.start(0)) {
                stringBuffer.append(string.substring(n, matcher.start(0)));
            }
            if (!bl && matcher.group(1) != null) {
                bl = true;
            }
            if (n2 != (n3 = bl && matcher.group(1) == null ? 2 : 1)) {
                stringBuffer.append("<indent val=\"");
                stringBuffer.append(n3);
                stringBuffer.append("\">");
                n2 = n3;
            }
            stringBuffer.append(matcher.group(0));
            n = matcher.end(0);
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private String fixEntry(String string) {
        string = string.replaceFirst("</p><p>(\uff3b.+?\uff3d</p>)", " $1");
        string = this.fixIndent(string);
        return string;
    }

    private void loadTxt(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        System.out.println("<html><body>");
        int n = 0;
        int n2 = 0;
        String string3 = "";
        StringBuffer stringBuffer = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            String string4 = string2.trim();
            if (string4.isEmpty()) continue;
            if (string2.equals(ENTRY_DELIM)) {
                stringBuffer.append("</dd>");
                System.out.println(this.fixEntry(stringBuffer.toString()));
                stringBuffer = null;
                if (++n % 1000 != 0) continue;
                System.err.print(".");
                continue;
            }
            if (string2.charAt(0) != ' ') {
                stringBuffer = new StringBuffer();
                stringBuffer.append("<dt id=\"");
                stringBuffer.append(n);
                stringBuffer.append("\">");
                string3 = string4;
                stringBuffer.append(string3);
                stringBuffer.append("</dt>");
                this.addKeyHyoki(stringBuffer, string4);
                stringBuffer.append("<dd>");
                n2 = 0;
                continue;
            }
            String string5 = this.fixNumbering(string4);
            if (n2 < 2) {
                string5 = this.fixRefInBracket(string5, string3, n);
            }
            string5 = this.fixRef(string5);
            stringBuffer.append("<p>");
            stringBuffer.append(string5);
            stringBuffer.append("</p>");
            ++n2;
        }
        System.out.println("</body></html>");
        bufferedReader.close();
        ((InputStream)fileInputStream).close();
        System.err.println();
        System.err.println("done. " + n + " entries");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            ZephyrUtil.setUTF8Ouput();
            MakeBodyHtml makeBodyHtml = new MakeBodyHtml();
            try {
                makeBodyHtml.loadHeadwords(stringArray[0]);
                makeBodyHtml.loadTxt(stringArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("Usage: java MakeBodyHtml SOME_DIR/kenkyusya-lajp.txt");
        }
    }
}

