/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.royalfrjp;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.AppendJPKeys;
import zephyr.util.AppendLatinKeys;
import zephyr.util.ZephyrUtil;

public class SedBodyHtml {
    private static final String[][] REPLACES = new String[][]{{"&lt;", "<"}, {"&gt;", ">"}, {"&amp;amp;", "&"}, {"&amp;", "&"}, {"<b>\uff3b\u7528\u4f8b\uff3d</b>", "\uff3b\u7528\u4f8b\uff3d"}, {"((", "\u300a"}, {"))", "\u300b"}, {"&hellip;", "..."}, {"&rarr;", "\u2192"}, {"&larr;", "\u2190"}, {"&hArr;", "\u21d4"}, {"&rArr;", "\u21d2"}, {"&dagger;", "\u2020"}, {"&minus;", "-"}, {"&mdash;", "\u2015"}, {"\u2103&deg;C", "\u2103"}, {"&radic;", "\u221a"}};
    private static final String[][] REG_REPLACES = new String[][]{{"(<dt[^>]+>)(.+?)</dt><dd><p> *\\2 *", "$1$2</dt><dd><p>"}, {"<p> +", "<p>"}, {" +</p>", "</p>"}};
    private static final String JUMP_REGEXP = "<jump onClick=\"(.+?)\">(.+?)</jump>";
    private static final Pattern JUMP = Pattern.compile("<jump onClick=\"(.+?)\">(.+?)</jump>");
    private static final String WORDJUMP_REGEXP = "jump\\('([^']+)','[^']*'\\)";
    private static final Pattern WORDJUMP = Pattern.compile("jump\\('([^']+)','[^']*'\\)");
    private static final String PDFJUMP_REGEXP = "openNewWin\\('[\\./]+/([^/]+/(.+?)\\.pdf)','(.+?)'\\)";
    private static final Pattern PDFJUMP = Pattern.compile("openNewWin\\('[\\./]+/([^/]+/(.+?)\\.pdf)','(.+?)'\\)");
    private static final String YAKUGO_REGEXP = "<yakugo>(.+?)</yakugo>";
    private static final Pattern YAKUGO = Pattern.compile("<yakugo>(.+?)</yakugo>");
    private static final AppendLatinKeys LATKEY = new AppendLatinKeys();
    private static int nJPKey = 0;
    private static final String DT_DD_REGEXP = "<dt[^>]+>(.+?)</dt>(<dd>.*)";
    private static final Pattern DT_DD = Pattern.compile("<dt[^>]+>(.+?)</dt>(<dd>.*)");

    /*
     * Enabled aggressive block sorting
     */
    private static String fixJump(String line, boolean bZuhanJpg) {
        Matcher m = JUMP.matcher(line);
        int k = 0;
        StringBuffer sb = new StringBuffer();
        StringBuffer imgSb = new StringBuffer();
        while (m.find()) {
            Matcher m2;
            if (k < m.start()) {
                sb.append(line.substring(k, m.start()));
            }
            String onClick = m.group(1);
            String text = m.group(2);
            if (onClick.startsWith("jump")) {
                m2 = WORDJUMP.matcher(onClick);
                if (m2.find()) {
                    sb.append("<a href=\"#");
                    sb.append(m2.group(1));
                    sb.append("\">");
                    sb.append(text);
                    sb.append("</a>");
                } else {
                    System.err.println("INVALID JUMP1: " + onClick);
                }
            } else {
                m2 = PDFJUMP.matcher(onClick);
                if (m2.find()) {
                    String path = m2.group(1);
                    String file = m2.group(2);
                    String type = m2.group(3);
                    if (bZuhanJpg && type.equals("ZUHAN")) {
                        sb.append("\u3010");
                        sb.append(text);
                        sb.append("\u3011");
                        imgSb.append("<p><img src=\"");
                        imgSb.append(file);
                        imgSb.append(".jpg\"/></p>");
                    } else {
                        sb.append(text);
                        sb.append(" \u3010file:");
                        sb.append(path);
                        sb.append("\u3011");
                    }
                }
            }
            k = m.end();
        }
        if (k >= line.length()) return sb.toString();
        if (imgSb.length() <= 0) {
            sb.append(line.substring(k));
            return sb.toString();
        }
        int n = line.lastIndexOf("</dd>");
        if (n > 0) {
            sb.append(line.substring(k, n));
            sb.append(imgSb);
            sb.append("</dd>");
            return sb.toString();
        }
        System.err.println("INVALID LINE without </dd>");
        return line;
    }

    private static String makeJPKeys(String dt, String dd, String type) {
        Matcher m = YAKUGO.matcher(dd);
        TreeSet<String> keySet = new TreeSet<String>();
        while (m.find()) {
            Matcher m2 = AppendJPKeys.JPWORD.matcher(m.group(1));
            while (m2.find()) {
                keySet.add(m2.group(2));
            }
        }
        if (!keySet.isEmpty()) {
            nJPKey += keySet.size();
            Matcher m3 = AppendJPKeys.JPWORD.matcher(dt);
            String dtKey = m3.find() ? ZephyrUtil.makeKey(m3.group(2)) : null;
            return LATKEY.makeKeys(dt, dtKey, type, keySet);
        }
        return "";
    }

    private static String appendJPKeys(String line, String type) {
        Matcher m = DT_DD.matcher(line);
        if (!m.find()) {
            return line;
        }
        String dt = m.group(1);
        String dd = m.group(2);
        String jpKey = SedBodyHtml.makeJPKeys(dt, dd, type);
        dd = dd.replace("<yakugo>", "").replace("</yakugo>", "");
        return String.valueOf(line.substring(0, m.start(2))) + jpKey + dd;
    }

    private static String sed(String line, boolean bZuhanJpg) {
        line = ZephyrUtil.sed(line, REPLACES, REG_REPLACES);
        line = SedBodyHtml.fixJump(line, bZuhanJpg);
        return line;
    }

    private static void sed(String[] args) throws Exception {
        String line;
        InputStream in = System.in;
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        boolean bZuhanJpg = false;
        String keyType = "\u8868\u8a18";
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (a.equals("WithZuhan")) {
                bZuhanJpg = true;
            } else {
                keyType = AppendLatinKeys.getKeyType(a);
            }
            ++n2;
        }
        while ((line = br.readLine()) != null) {
            line = SedBodyHtml.sed(line, bZuhanJpg);
            line = SedBodyHtml.appendJPKeys(line, keyType);
            System.out.println(line);
        }
        if (nJPKey > 0) {
            System.err.println("append " + nJPKey + " extra Japanese " + keyType + " keys");
        }
    }

    public static void main(String[] args) {
        try {
            ZephyrUtil.setUTF8Ouput();
            SedBodyHtml.sed(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

