/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.petitroyal;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.obunsha.petitroyal.MakeBodyHtml;
import zephyr.util.ZephyrUtil;

public class MakeConjuHtml {
    private static final String CONJU_BODY_REGEXP = "<tr class=\"title_bar\">((<td class=\"title\">[^<]+</td> )+)</tr><tr class=\"data\">((<td>.*?</td> )+?)</tr>";
    private static final String CONJU_TABLES_REGEXP = "<table id='tbl?[1-5]'><caption>([^<]+)</caption>((<tr class=\"title_bar\">((<td class=\"title\">[^<]+</td> )+)</tr><tr class=\"data\">((<td>.*?</td> )+?)</tr>)+)";
    private static final String CONJU_TITLE_REGEXP = "<td class=\"title\">([^<]+)</td>";
    private static final String CONJU_DATA_REGEXP = "<td>(.*?)</td>";
    private static final Pattern CONJU_TABLES = Pattern.compile("<table id='tbl?[1-5]'><caption>([^<]+)</caption>((<tr class=\"title_bar\">((<td class=\"title\">[^<]+</td> )+)</tr><tr class=\"data\">((<td>.*?</td> )+?)</tr>)+)");
    private static final Pattern CONJU_BODY = Pattern.compile("<tr class=\"title_bar\">((<td class=\"title\">[^<]+</td> )+)</tr><tr class=\"data\">((<td>.*?</td> )+?)</tr>");
    private static final Pattern CONJU_TITLE = Pattern.compile("<td class=\"title\">([^<]+)</td>");
    private static final Pattern CONJU_DATA = Pattern.compile("<td>(.*?)</td>");

    private String[] getTexts(String txt, Pattern pat) {
        LinkedList<String> list = new LinkedList<String>();
        Matcher m = pat.matcher(txt);
        while (m.find()) {
            list.add(m.group(1));
        }
        return list.toArray(new String[0]);
    }

    private void conjuBodies(StringBuffer sb, String bodies) {
        Matcher m = CONJU_BODY.matcher(bodies);
        while (m.find()) {
            String[] data;
            String[] titles = this.getTexts(m.group(1), CONJU_TITLE);
            if (titles.length != (data = this.getTexts(m.group(3), CONJU_DATA)).length) {
                System.err.println("titles.lenght=" + titles.length + ", data.length=" + data.length);
                System.err.println(bodies);
                System.exit(1);
            }
            int i = 0;
            while (i < titles.length) {
                sb.append("<indent val=\"1\"><p>-- ");
                sb.append(titles[i]);
                sb.append(" --</p><indent val=\"2\"><p>");
                String d = data[i].endsWith("<br>") ? data[i].substring(0, data[i].length() - 4) : data[i];
                d = d.replace("<br>", " / ");
                sb.append(d);
                sb.append("</p>");
                ++i;
            }
        }
    }

    private String conjuHtml(String html) {
        StringBuffer sb = new StringBuffer();
        Matcher m = CONJU_TABLES.matcher(html);
        sb.append("<p> </p>");
        while (m.find()) {
            sb.append("<indent val=\"1\"><p><b>== ");
            sb.append(m.group(1));
            sb.append(" ==</b></p>");
            this.conjuBodies(sb, m.group(2));
        }
        return sb.toString();
    }

    public void loadConju(String dbName) throws Exception {
        Class.forName("org.sqlite.JDBC");
        Connection conn = DriverManager.getConnection("jdbc:sqlite:" + dbName);
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select conju_id,midasi,html from conju_items;");
        System.out.println("<html><body>");
        int nEntry = 0;
        while (rs.next()) {
            String conju_id = rs.getString("conju_id");
            String midashi = rs.getString("midasi");
            String html = rs.getString("html");
            System.out.print("<dt id=\"");
            System.out.print(conju_id);
            System.out.print("\">");
            System.out.print(midashi);
            System.out.print(" #</dt><dd>");
            System.out.print(this.conjuHtml(html));
            System.out.println("</dd>");
            if (++nEntry % 1000 != 0) continue;
            System.err.print(".");
        }
        System.out.println("</body></html>");
        rs.close();
        conn.close();
        System.err.println();
        System.err.println("done. " + nEntry + " entries");
    }

    public static void main(String[] args) {
        String dbName = args.length == 0 ? "petit.sql" : args[0];
        MakeBodyHtml.checkDBFile(dbName);
        MakeConjuHtml app = new MakeConjuHtml();
        try {
            ZephyrUtil.setUTF8Ouput();
            app.loadConju(dbName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

