/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusya.lajp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.AppendJPKeys;
import zephyr.util.MultiHashMap;
import zephyr.util.ZephyrUtil;

public class MakeJpLaBodyHtml {
    private final HashMap<String, Integer> latinIdMap = new HashMap();
    private static final String DT_ID_REGEXP = "<dt id=\"([0-9]+)\">(.+?)</dt>";
    private static final Pattern DT_ID = Pattern.compile("<dt id=\"([0-9]+)\">(.+?)</dt>");
    private static final String[] TAGNAMES = new String[]{"a", "href"};
    private static final String MIDASHI_START = "\u898b\u3060\u3057\u958b\u59cb";
    private static final String MIDASHI_END = "\u898b\u3060\u3057\u7d42\u4e86";
    private static final String ENTRY_DELIM = "======";
    private MultiHashMap<String, String> kanaMap = new MultiHashMap();
    private static final String NAKAGURO_HALF = "\uff65";
    private static final String NAKAGURO_FULL = "\u30fb";
    private final LinkedList<String> entries = new LinkedList();
    private final HashMap<String, Integer> dtIdMap = new HashMap();
    private static final String JPREF_REGEXP = "(\u21d2(.+?)\uff0e)|(\\(\uff1d(.+?)\\))";
    private static final Pattern JPREF = Pattern.compile("(\u21d2(.+?)\uff0e)|(\\(\uff1d(.+?)\\))");
    private static final String JPREFWORD_REGEXP = "([^, ]+)";
    private static final Pattern JPREFWORD = Pattern.compile("([^, ]+)");
    private static final String LAREF_REGEXP = "([a-zA-Z]+)";
    private static final Pattern LAREF = Pattern.compile("([a-zA-Z]+)");
    private static final String PARA_REGEXP = "<p>(.+?)</p>";
    private static final Pattern PARA = Pattern.compile("<p>(.+?)</p>");

    private void loadLAJPBody(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        int n = 0;
        while ((line = br.readLine()) != null) {
            Matcher m = DT_ID.matcher(line);
            if (!m.find()) continue;
            String dt = m.group(2);
            Integer id = Integer.parseInt(m.group(1));
            String[] stringArray = dt.split(", *");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String key = stringArray[n3];
                String key2 = ZephyrUtil.makeKey(ZephyrUtil.hex2uni(key), true).toLowerCase();
                if (!this.latinIdMap.containsKey(key2)) {
                    this.latinIdMap.put(key2, id);
                }
                ++n3;
            }
            ++n;
        }
        System.err.println("load " + n + " latin-japanese entries' id");
        String[] stringArray = TAGNAMES;
        int n4 = TAGNAMES.length;
        int n5 = 0;
        while (n5 < n4) {
            String t = stringArray[n5];
            this.latinIdMap.remove(t);
            ++n5;
        }
    }

    MakeJpLaBodyHtml() {
        this.kanaMap.put("\u5b89\u697d\u6b7b", "\u3042\u3093\u3089\u304f\u3057");
        this.kanaMap.put("\u5f15\u529b", "\u3044\u3093\u308a\u3087\u304f");
        this.kanaMap.put("\u904b\u547d", "\u3046\u3093\u3081\u3044");
        this.kanaMap.put("\u9060\u616e", "\u3048\u3093\u308a\u3087");
        this.kanaMap.put("\u9854\u6599", "\u304c\u3093\u308a\u3087\u3046");
        this.kanaMap.put("\u7de9\u548c", "\u304b\u3093\u308f");
        this.kanaMap.put("\u541f\u5473", "\u304e\u3093\u307f");
        this.kanaMap.put("\u91d1\u5229", "\u304d\u3093\u308a");
        this.kanaMap.put("\u8ecd\u670d", "\u3050\u3093\u3077\u304f");
        this.kanaMap.put("\u8a13\u7df4", "\u304f\u3093\u308c\u3093");
        this.kanaMap.put("\u6a29\u529b", "\u3051\u3093\u308a\u3087\u304f");
        this.kanaMap.put("\u8a00\u8ad6", "\u3052\u3093\u308d\u3093");
        this.kanaMap.put("\u5c71\u8108", "\u3055\u3093\u307f\u3083\u304f");
        this.kanaMap.put("\u4eba\u985e\u5b66", "\u3058\u3093\u308b\u3044\u304c\u304f");
        this.kanaMap.put("\u795e\u8a71", "\u3057\u3093\u308f");
        this.kanaMap.put("\u5bf8\u6cd5", "\u3059\u3093\u307d\u3046");
        this.kanaMap.put("\u5168\u529b", "\u305c\u3093\u308a\u3087\u304f");
        this.kanaMap.put("\u6d17\u7df4", "\u305b\u3093\u308c\u3093");
        this.kanaMap.put("\u5897\u5927", "\u305e\u3046\u3060\u3044");
        this.kanaMap.put("\u62c5\u4fdd", "\u305f\u3093\u307d");
        this.kanaMap.put("\u6696\u7089", "\u3060\u3093\u308d");
        this.kanaMap.put("\u9673\u5217", "\u3061\u3093\u308c\u3064");
        this.kanaMap.put("\u9023\u308c\u308b", "\u3064\u308c\u308b");
        this.kanaMap.put("\u5929\u6587\u5b66", "\u3066\u3093\u3082\u3093\u304c\u304f");
        this.kanaMap.put("\u96fb\u8a71", "\u3067\u3093\u308f");
        this.kanaMap.put("\u8caa\u6b32", "\u3069\u3093\u3088\u304f");
        this.kanaMap.put("\u96e3\u6c11", "\u306a\u3093\u307f\u3093");
        this.kanaMap.put("\u4efb\u547d", "\u306b\u3093\u3081\u3044");
        this.kanaMap.put("\u5e74\u9f62", "\u306d\u3093\u308c\u3044");
        this.kanaMap.put("\u53cd\u8ad6", "\u306f\u3093\u308d\u3093");
        this.kanaMap.put("\u8ca7\u4e4f", "\u3073\u3093\u307c\u3046");
        this.kanaMap.put("\u5206\u5225", "\u3075\u3093\u3079\u3064");
        this.kanaMap.put("\u5206\u88c2", "\u3076\u3093\u308c\u3064");
        this.kanaMap.put("\u5f01\u8ad6", "\u3079\u3093\u308d\u3093");
        this.kanaMap.put("\u4e07\u5e74\u7b46", "\u307e\u3093\u306d\u3093\u3072\u3064");
        this.kanaMap.put("\u6c11\u65cf", "\u307f\u3093\u305e\u304f");
        this.kanaMap.put("\u7fa4\u308c", "\u3080\u308c");
        this.kanaMap.put("\u7dbf\u5bc6", "\u3081\u3093\u307f\u3064");
        this.kanaMap.put("\u554f\u984c", "\u3082\u3093\u3060\u3044");
        this.kanaMap.put("\u548c\u3089\u3052\u308b", "\u3084\u308f\u3089\u3052\u308b");
        this.kanaMap.put("\u63fa\u308c\u308b", "\u3086\u308c\u308b");
        this.kanaMap.put("\u5f31\u308b", "\u3088\u308f\u308b");
        this.kanaMap.put("\u4e71\u7528", "\u3089\u3093\u3088\u3046");
        this.kanaMap.put("\u502b\u7406", "\u308a\u3093\u308a");
        this.kanaMap.put("\u9023\u7d61", "\u308c\u3093\u3089\u304f");
        this.kanaMap.put("\u8ad6\u7406", "\u308d\u3093\u308a");
        this.kanaMap.put("\u6e7e", "\u308f\u3093");
    }

    /*
     * Unable to fully structure code
     */
    private void loadMidashi(BufferedReader br) throws Exception {
        line = br.readLine();
        if ("\u898b\u3060\u3057\u958b\u59cb".equals(line)) ** GOTO lbl12
        throw new Exception("missing \u898b\u3060\u3057\u958b\u59cb");
        while (!line.equals("\u898b\u3060\u3057\u7d42\u4e86")) {
            words = line.trim().split("\t");
            if (words.length == 2) {
                this.kanaMap.put(words[0], words[1]);
                if (words[0].contains("\uff65")) {
                    this.kanaMap.put(words[0].replace("\uff65", "\u30fb"), words[1]);
                }
            }
lbl12:
            // 6 sources

            if ((line = br.readLine()) != null) continue;
        }
        System.err.println("load " + this.kanaMap.size() + " kana entries");
    }

    private void loadBody(BufferedReader br) throws Exception {
        String line;
        StringBuffer sb = new StringBuffer();
        int id = 0;
        while ((line = br.readLine()) != null) {
            if (line.trim().isEmpty()) continue;
            if (line.equals(ENTRY_DELIM)) {
                sb.append("</dd>");
                this.entries.add(sb.toString());
                sb = null;
                sb = new StringBuffer();
                continue;
            }
            if (line.charAt(0) != ' ') {
                String dt = line.trim();
                LinkedList kanaList = this.kanaMap.getWithoutNull(dt);
                sb.append("<dt id=\"");
                sb.append(id);
                if (!this.dtIdMap.containsKey(dt)) {
                    this.dtIdMap.put(dt, id);
                }
                ++id;
                sb.append("\">");
                sb.append(dt);
                for (String kana : kanaList) {
                    sb.append("\u3010");
                    sb.append(kana);
                    sb.append("\u3011");
                }
                sb.append("</dt>");
                if (kanaList.isEmpty()) {
                    String kana;
                    kana = AppendJPKeys.makeKana(dt);
                    if (kana != null) {
                        sb.append("<key type=\"\u304b\u306a\">");
                        sb.append(kana);
                        sb.append("</key>");
                    } else if (!AppendJPKeys.isKana(dt.charAt(0))) {
                        System.err.println("WARN: missing kana: " + dt);
                    }
                }
                sb.append("<dd>");
                continue;
            }
            sb.append("<p>");
            sb.append(line.trim());
            sb.append("</p>");
        }
    }

    private void appendJPref(StringBuffer sb, String refs) {
        Matcher m = JPREFWORD.matcher(refs);
        int idx = 0;
        while (m.find()) {
            String word;
            Integer id;
            if (idx < m.start(1)) {
                sb.append(refs.substring(idx, m.start(1)));
            }
            if ((id = this.dtIdMap.get(word = m.group(1))) != null) {
                sb.append(String.format("<a href=\"#%d\">%s</a>", id, word));
            } else {
                sb.append(word);
            }
            idx = m.end(1);
        }
        if (idx < refs.length()) {
            sb.append(refs.substring(idx));
        }
    }

    private String appendJPref(String line) {
        StringBuffer sb = new StringBuffer();
        Matcher m = JPREF.matcher(line);
        int idx = 0;
        while (m.find()) {
            int gno;
            int n = gno = m.group(1) != null ? 2 : 4;
            if (idx < m.start(gno)) {
                sb.append(line.substring(idx, m.start(gno)));
            }
            this.appendJPref(sb, m.group(gno));
            idx = m.end(gno);
        }
        if (idx < line.length()) {
            sb.append(line.substring(idx));
        }
        return sb.toString();
    }

    private void appendLArefPara(StringBuffer sb, String para) {
        Matcher m = LAREF.matcher(para);
        int idx = 0;
        while (m.find()) {
            String word;
            String key;
            Integer id;
            if (idx < m.start(1)) {
                sb.append(para.substring(idx, m.start(1)));
            }
            if ((id = this.latinIdMap.get(key = (word = m.group(1)).toLowerCase())) != null) {
                sb.append(String.format("<a href=\"body-lajp.html#%d\">%s</a>", id, word));
            } else {
                sb.append(word);
            }
            idx = m.end(1);
        }
        if (idx < para.length()) {
            sb.append(para.substring(idx));
        }
    }

    private String appendLAref(String line) {
        StringBuffer sb = new StringBuffer();
        Matcher m = PARA.matcher(line);
        int idx = 0;
        while (m.find()) {
            if (idx < m.start(1)) {
                sb.append(line.substring(idx, m.start(1)));
            }
            this.appendLArefPara(sb, m.group(1));
            idx = m.end(1);
        }
        if (idx < line.length()) {
            sb.append(line.substring(idx));
        }
        return sb.toString();
    }

    private void outBody() {
        for (String line : this.entries) {
            System.out.println(this.appendLAref(this.appendJPref(line)));
        }
        System.err.println("done. " + this.entries.size() + " entries");
    }

    private void loadTxt(String filename) throws Exception {
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        System.out.println("<html><body>");
        this.loadMidashi(br);
        this.loadBody(br);
        this.outBody();
        System.out.println("</body></html>");
    }

    public static void main(String[] args) {
        if (args.length >= 2) {
            MakeJpLaBodyHtml app = new MakeJpLaBodyHtml();
            try {
                ZephyrUtil.setShiftJisOuput();
                app.loadLAJPBody(args[1]);
                app.loadTxt(args[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Usage: java MakeJpLaBodyHtml kenkyusya-jpla.txt body-lajp.html");
        }
    }
}

