/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusya.lajp;

import estraier.Database;
import estraier.Document;
import java.util.List;
import zephyr.util.ZephyrUtil;

public class EstraierLoader {
    static final String ENTRY_DELIM = "======";

    private void load(String dbName) throws Exception {
        Database db = new Database();
        if (!db.open(dbName, 1)) {
            throw new Exception(db.err_msg(db.error()));
        }
        int docNum = db.doc_num();
        System.err.print("loading Latin-Japanese entries ");
        boolean inJpLa = true;
        int lajpNum = 0;
        int id = 1;
        while (id <= docNum) {
            block8: {
                List lines;
                block9: {
                    Document doc;
                    block7: {
                        doc = db.get_doc(id, 0);
                        if (doc != null) break block7;
                        System.err.println("cannot get id=" + id);
                        break block8;
                    }
                    lines = doc.texts();
                    if (!inJpLa) break block9;
                    char c = lines.get(0).toString().charAt(0);
                    if (c != 'A') break block8;
                    inJpLa = false;
                }
                for (Object l : lines) {
                    System.out.println(l.toString());
                }
                System.out.println(ENTRY_DELIM);
                if (++lajpNum % 1000 == 0) {
                    System.err.print('.');
                }
            }
            ++id;
        }
        db.close();
        System.err.println();
        System.err.println("done. " + lajpNum + " entries");
    }

    public static void main(String[] args) {
        ZephyrUtil.setUTF8Ouput();
        EstraierLoader app = new EstraierLoader();
        if (args.length > 0) {
            try {
                app.load(args[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Usage: java EstraierLoader SOME_DIR/index_E");
        }
    }
}

