using System;
using System.Reflection;
using System.Text;

namespace PrivateNUnitCore
{
	/// <summary>
	/// TestCaseGenerator ̊Tv̐łB
	/// </summary>
	public class TestCaseGenerator
	{
		private string fqdnClassName;
		private MethodInfo[] methodsToTest;

		public string FqdnClassName
		{
			get { return fqdnClassName; }
			set { fqdnClassName = value; }
		}

		public MethodInfo[] MethodsToTest
		{
			get { return methodsToTest; }
			set { methodsToTest = value; }
		}

		public TestCaseGenerator(string sqdnClassName, MethodInfo[] methodsToTest)
		{
			this.fqdnClassName = fqdnClassName;
			this.methodsToTest = methodsToTest;
		}

		public string Generate()
		{
			StringBuilder sb = new StringBuilder();
			foreach(MethodInfo method in methodsToTest)
			{
				if(method.IsStatic)
				{
					if(method.IsPublic)
					{
						sb.Append(GeneratePublicStatic(method));
					}
					else
					{
						sb.Append(GenerateNonPublicStatic(method));
					}
				}
				else
				{
					if(method.IsPublic)
					{
						sb.Append(GeneratePublicInstance(method));
					}
					else
					{
						sb.Append(GenerateNonPublicInstance(method));
					}
				}
			}
			return sb.ToString();
		}
		
		private string GenerateMethodHeader()
		{
			return null;//TODO
		}

		private string GenerateMethodFooter()
		{
			return null;//TODO
		}
		private string GeneratePublicStatic(MethodInfo method)
		{
			//TODO
			return null;
		}
		
		private string GenerateNonPublicStatic(MethodInfo method)
		{
			//TODO
			return null;
		}

		private string GeneratePublicInstance(MethodInfo method)
		{
			//TODO
			return null;
		}
		
		private string GenerateNonPublicInstance(MethodInfo method)
		{
			//TODO
			return null;
		}

	}
}
