using System;
using System.Reflection;

namespace PrivateNUnitCore
{
	/// <summary>
	/// ClassAnalyzer ̊Tv̐łB
	/// </summary>
	public class ClassAnalyzer
	{
		private string assemblyPath;
		private string fqdnClassName;

		public string AssemblyPath
		{
			get { return assemblyPath; }
			set { assemblyPath = value; }
		}

		public string FqdnClassName
		{
			get { return fqdnClassName; }
			set { fqdnClassName = value; }
		}

		public ClassAnalyzer(string assemblyPath, string fqdnClassName)
		{
			this.assemblyPath = assemblyPath;
			this.fqdnClassName = fqdnClassName;
		}

		public MethodInfo[] Analyze()
		{
			Assembly asm = Assembly.LoadFrom(assemblyPath);
			Type typeToTest = asm.GetType(fqdnClassName);

			return typeToTest.GetMethods(BindingFlags.Instance | BindingFlags.Static | BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.DeclaredOnly );

		}
		
	}
}
