/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tree;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletResponse;
import org.primefaces.component.tree.Tree;
import org.primefaces.component.tree.UITreeNode;
import org.primefaces.event.NodeCollapseEvent;
import org.primefaces.event.NodeExpandEvent;
import org.primefaces.event.NodeSelectEvent;
import org.primefaces.model.TreeExplorer;
import org.primefaces.model.TreeExplorerImpl;
import org.primefaces.model.TreeModel;
import org.primefaces.model.TreeNode;
import org.primefaces.model.TreeNodeEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.RendererUtils;

public class TreeRenderer
extends CoreRenderer
implements PartialRenderer {
    private TreeExplorer treeExplorer = new TreeExplorerImpl();

    public void decode(FacesContext facesContext, UIComponent component) {
        Tree tree = (Tree)component;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = tree.getClientId(facesContext);
        String rowKeyParam = clientId + "_rowKey";
        String actionParam = clientId + "_action";
        String selectionParam = clientId + "_selection";
        if (params.containsKey(clientId) && params.containsKey(rowKeyParam) && params.containsKey(actionParam)) {
            String rowKey = (String)params.get(rowKeyParam);
            String event = (String)params.get(actionParam);
            TreeNode root = (TreeNode)tree.getValue();
            TreeNode currentNode = this.treeExplorer.findTreeNode(rowKey, new TreeModel(root));
            switch (TreeNodeEvent.valueOf(event)) {
                case SELECT: {
                    tree.queueEvent(new NodeSelectEvent((UIComponent)tree, currentNode));
                    break;
                }
                case EXPAND: {
                    currentNode.setExpanded(true);
                    tree.queueEvent(new NodeExpandEvent((UIComponent)tree, currentNode));
                    break;
                }
                case COLLAPSE: {
                    currentNode.setExpanded(false);
                    tree.queueEvent(new NodeCollapseEvent((UIComponent)tree, currentNode));
                }
            }
        }
        if (params.containsKey(selectionParam)) {
            String selectedNodesValue = (String)params.get(selectionParam);
            if (selectedNodesValue.equals("")) {
                tree.setSelection(new TreeNode[0]);
            } else {
                String[] selectedRowKeys = selectedNodesValue.split(",");
                TreeNode[] selectedNodes = new TreeNode[selectedRowKeys.length];
                TreeModel model = new TreeModel((TreeNode)tree.getValue());
                for (int i = 0; i < selectedRowKeys.length; ++i) {
                    selectedNodes[i] = this.treeExplorer.findTreeNode(selectedRowKeys[i], model);
                    model.setRowIndex(-1);
                }
                tree.setSelection(selectedNodes);
            }
        }
    }

    public void encodePartially(FacesContext facesContext, UIComponent component) throws IOException {
        Tree tree = (Tree)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = tree.getClientId(facesContext);
        TreeNode root = (TreeNode)tree.getValue();
        String rowKey = (String)params.get(clientId + "_rowKey");
        TreeNode currentNode = this.treeExplorer.findTreeNode(rowKey, new TreeModel(root));
        int rowIndex = 0;
        ServletResponse response = (ServletResponse)facesContext.getExternalContext().getResponse();
        response.setContentType("text/xml");
        writer.write("<nodes>");
        for (TreeNode child : currentNode.getChildren()) {
            UITreeNode uiTreeNode = tree.getUITreeNodeByType(child.getType());
            facesContext.getExternalContext().getRequestMap().put(tree.getVar(), child.getData());
            writer.write("<node>");
            writer.write("<content>");
            RendererUtils.startCDATA(facesContext);
            this.renderChildren(facesContext, (UIComponent)uiTreeNode);
            RendererUtils.endCDATA(facesContext);
            writer.write("</content>");
            writer.write("<rowKey>" + rowKey + "." + rowIndex + "</rowKey>");
            writer.write("<isLeaf>" + child.isLeaf() + "</isLeaf>");
            if (uiTreeNode.getStyleClass() != null) {
                writer.write("<contentClass>" + uiTreeNode.getStyleClass() + "</contentClass>");
            }
            writer.write("</node>");
            ++rowIndex;
            facesContext.getExternalContext().getRequestMap().remove(tree.getVar());
        }
        writer.write("</nodes>");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Tree tree = (Tree)component;
        this.encodeScript(facesContext, tree);
        this.encodeMarkup(facesContext, tree);
    }

    protected void encodeScript(FacesContext facesContext, Tree tree) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = tree.getClientId(facesContext);
        String formClientId = null;
        String treeVar = this.createUniqueWidgetVar(facesContext, (UIComponent)tree);
        TreeNode root = (TreeNode)tree.getValue();
        UIComponent parentForm = ComponentUtils.findParentForm(facesContext, (UIComponent)tree);
        if (parentForm == null) {
            throw new FacesException("Tree:" + clientId + " needs to be enclosed in a form");
        }
        formClientId = parentForm.getClientId(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write(treeVar + " = new PrimeFaces.widget.TreeView('" + clientId + "', [\n");
        int rowIndex = 0;
        Iterator<TreeNode> iterator = root.getChildren().iterator();
        while (iterator.hasNext()) {
            this.encodeTreeNode(facesContext, tree, iterator.next(), String.valueOf(rowIndex));
            ++rowIndex;
            if (!iterator.hasNext()) continue;
            writer.write(",");
        }
        writer.write("],{\n");
        writer.write("dynamic:" + tree.isDynamic());
        if (tree.isDynamic()) {
            writer.write(",actionURL:'" + this.getActionURL(facesContext) + "'");
            writer.write(",formId:'" + formClientId + "'");
            writer.write(",cache:" + tree.isCache());
            if (tree.getUpdate() != null) {
                writer.write(",update:'" + ComponentUtils.findClientIds(facesContext, (UIComponent)tree, tree.getUpdate()) + "'");
            }
            if (tree.getOnselectStart() != null) {
                writer.write(",onselectStart:function(){" + tree.getOnselectStart() + ";}");
            }
            if (tree.getOnselectComplete() != null) {
                writer.write(",onselectComplete:function(){" + tree.getOnselectComplete() + ";}");
            }
        }
        if (tree.getOnNodeClick() != null) {
            writer.write(",onNodeClick:" + tree.getOnNodeClick());
        }
        if (tree.hasSelection()) {
            writer.write(",hasSelection:true");
            writer.write(",propagateHighlightDown:" + tree.isPropagateSelectionDown());
            writer.write(",propagateHighlightUp:" + tree.isPropagateSelectionDown());
        }
        writer.write("\n});\n");
        if (tree.getExpandAnim() != null) {
            writer.write(treeVar + ".setExpandAnim(YAHOO.widget.TVAnim." + tree.getExpandAnim() + ");\n");
        }
        if (tree.getCollapseAnim() != null) {
            writer.write(treeVar + ".setCollapseAnim(YAHOO.widget.TVAnim." + tree.getCollapseAnim() + ");\n");
        }
        writer.write(treeVar + ".render();\n");
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeTreeNode(FacesContext facesContext, Tree tree, TreeNode node, String rowKey) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        int rowIndex = 0;
        UITreeNode uiTreeNode = tree.getUITreeNodeByType(node.getType());
        if (!this.isPostBack() && tree.isExpanded()) {
            node.setExpanded(true);
        }
        facesContext.getExternalContext().getRequestMap().put(tree.getVar(), node.getData());
        writer.write("{html:'");
        this.renderChildren(facesContext, (UIComponent)uiTreeNode);
        facesContext.getExternalContext().getRequestMap().remove(tree.getVar());
        writer.write("',type:'html'");
        writer.write(",rowKey:'" + rowKey + "'");
        if (node.isLeaf()) {
            writer.write(",isLeaf:true");
        }
        if (uiTreeNode.getStyleClass() != null) {
            writer.write(",contentStyle:'" + uiTreeNode.getStyleClass() + "'");
        }
        if (node.isExpanded()) {
            writer.write(",expanded:true");
            if (tree.isDynamic()) {
                writer.write(",dynamicLoadComplete:true");
            }
        }
        if (node.isExpanded() || !tree.isDynamic()) {
            writer.write(",children:[");
            Iterator<TreeNode> iterator = node.getChildren().iterator();
            while (iterator.hasNext()) {
                String childRowKey = rowKey + "." + rowIndex;
                this.encodeTreeNode(facesContext, tree, iterator.next(), childRowKey);
                ++rowIndex;
                if (!iterator.hasNext()) continue;
                writer.write(",");
            }
            writer.write("]");
        }
        writer.write("}");
    }

    protected void encodeMarkup(FacesContext facesContext, Tree tree) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = tree.getClientId(facesContext);
        writer.startElement("div", (UIComponent)tree);
        writer.writeAttribute("id", (Object)clientId, null);
        if (tree.getStyle() != null) {
            writer.writeAttribute("style", (Object)tree.getStyle(), null);
        }
        if (tree.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)tree.getStyleClass(), null);
        }
        writer.startElement("div", (UIComponent)tree);
        writer.writeAttribute("id", (Object)(clientId + "_container"), null);
        if (tree.hasSelection()) {
            writer.writeAttribute("class", (Object)"ygtv-checkbox", null);
        }
        writer.endElement("div");
        if (tree.hasSelection()) {
            writer.startElement("input", null);
            writer.writeAttribute("id", (Object)(clientId + "_selection"), null);
            writer.writeAttribute("name", (Object)(clientId + "_selection"), null);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.endElement("input");
        }
        writer.endElement("div");
    }
}

