/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.hotkey;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.hotkey.Hotkey;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class HotkeyRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Hotkey hotkey;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey((hotkey = (Hotkey)component).getClientId(facesContext))) {
            hotkey.queueEvent((FacesEvent)new ActionEvent((UIComponent)hotkey));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Hotkey hotkey = (Hotkey)component;
        String clientId = hotkey.getClientId(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(document).bind('keydown', '" + hotkey.getBind() + "', function(){\n");
        if (hotkey.getHandler() == null) {
            String formClientId = null;
            UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)hotkey);
            if (form == null) {
                throw new FacesException("Hotkey:" + clientId + " needs to be enclosed in a form when using an hotkeyListener");
            }
            formClientId = ComponentUtils.findParentForm(facesContext, (UIComponent)hotkey).getClientId(facesContext);
            writer.write("PrimeFaces.ajax.AjaxRequest(");
            writer.write("'" + this.getActionURL(facesContext) + "'");
            writer.write(",{formId:'" + formClientId + "'");
            if (hotkey.isAsync()) {
                writer.write(",async:true");
            }
            if (hotkey.getOnstart() != null) {
                writer.write(",onstart:function(xhr){" + hotkey.getOnstart() + ";}");
            }
            if (hotkey.getOnerror() != null) {
                writer.write(",onerror:function(xhr, status, error){" + hotkey.getOnerror() + ";}");
            }
            if (hotkey.getOnsuccess() != null) {
                writer.write(",onsuccess:function(data, status, xhr, args){" + hotkey.getOnsuccess() + ";}");
            }
            if (hotkey.getOncomplete() != null) {
                writer.write(",oncomplete:function(xhr, status, args){" + hotkey.getOncomplete() + ";}");
            }
            writer.write(",global:" + hotkey.isGlobal());
            writer.write("},");
            writer.write("{'" + clientId + "':'" + clientId + "'");
            if (hotkey.getUpdate() != null) {
                writer.write(",'primefacesPartialUpdate':'" + ComponentUtils.findClientIds(facesContext, (UIComponent)hotkey, hotkey.getUpdate()) + "'");
            }
            if (hotkey.getProcess() != null) {
                writer.write(",'primefacesPartialProcess':'" + ComponentUtils.findClientIds(facesContext, (UIComponent)hotkey, hotkey.getProcess()) + "'");
            }
            writer.write("});");
        } else {
            writer.write(hotkey.getHandler() + ";");
        }
        writer.write("});");
        writer.endElement("script");
    }
}

