/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.calendar;

import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.el.ValueExpression;
import javax.el.MethodExpression;
import javax.faces.render.Renderer;
import java.io.IOException;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.resource.ResourceHolder;


public class Calendar extends UIInput {


	public static final String COMPONENT_TYPE = "org.primefaces.component.Calendar";
	public static final String COMPONENT_FAMILY = "org.primefaces.component";
	private static final String DEFAULT_RENDERER = "org.primefaces.component.CalendarRenderer";

	private java.lang.String _widgetVar;
	private java.lang.String _title;
	private java.lang.Object _mindate;
	private java.lang.Object _maxdate;
	private java.lang.String _selection;
	private java.lang.Integer _pages;
	private java.lang.Boolean _close;
	private java.lang.String _mode;
	private java.lang.String _pattern;
	private java.lang.Object _locale;
	private java.lang.Boolean _showWeekdays;
	private java.lang.String _monthFormat;
	private java.lang.String _weekdayFormat;
	private java.lang.Integer _startWeekday;
	private java.lang.String _popupIcon;
	private java.lang.Boolean _navigator;
	private java.lang.Object _pagedate;
	private java.lang.Object _timeZone;
	private java.lang.Boolean _showWeekHeader;
	private java.lang.Boolean _showWeekFooter;
	private java.lang.Boolean _readOnlyInputText;
	public Calendar() {
		setRendererType(DEFAULT_RENDERER);
		ResourceHolder resourceHolder = getResourceHolder();
		if(resourceHolder != null) {
			resourceHolder.addResource("/yui/container/assets/skins/sam/container.css");
			resourceHolder.addResource("/yui/calendar/assets/skins/sam/calendar.css");
			resourceHolder.addResource("/yui/utilities/utilities.js");
			resourceHolder.addResource("/yui/container/container-min.js");
			resourceHolder.addResource("/yui/calendar/calendar-min.js");
			resourceHolder.addResource("/primefaces/core/core.js");
			resourceHolder.addResource("/primefaces/calendar/calendar.js");
		}
	}

	public String getFamily() {
		return COMPONENT_FAMILY;
	}

	public java.lang.String getWidgetVar() {
		if(_widgetVar != null )
			return _widgetVar;

		ValueExpression ve = getValueExpression("widgetVar");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setWidgetVar(java.lang.String _widgetVar) {
		this._widgetVar = _widgetVar;
	}

	public java.lang.String getTitle() {
		if(_title != null )
			return _title;

		ValueExpression ve = getValueExpression("title");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setTitle(java.lang.String _title) {
		this._title = _title;
	}

	public java.lang.Object getMindate() {
		if(_mindate != null )
			return _mindate;

		ValueExpression ve = getValueExpression("mindate");
		return ve != null ? (java.lang.Object) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setMindate(java.lang.Object _mindate) {
		this._mindate = _mindate;
	}

	public java.lang.Object getMaxdate() {
		if(_maxdate != null )
			return _maxdate;

		ValueExpression ve = getValueExpression("maxdate");
		return ve != null ? (java.lang.Object) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setMaxdate(java.lang.Object _maxdate) {
		this._maxdate = _maxdate;
	}

	public java.lang.String getSelection() {
		if(_selection != null )
			return _selection;

		ValueExpression ve = getValueExpression("selection");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : "single";
	}
	public void setSelection(java.lang.String _selection) {
		this._selection = _selection;
	}

	public int getPages() {
		if(_pages != null )
			return _pages;

		ValueExpression ve = getValueExpression("pages");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 1;
	}
	public void setPages(int _pages) {
		this._pages = _pages;
	}

	public boolean isClose() {
		if(_close != null )
			return _close;

		ValueExpression ve = getValueExpression("close");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : true;
	}
	public void setClose(boolean _close) {
		this._close = _close;
	}

	public java.lang.String getMode() {
		if(_mode != null )
			return _mode;

		ValueExpression ve = getValueExpression("mode");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : "popup";
	}
	public void setMode(java.lang.String _mode) {
		this._mode = _mode;
	}

	public java.lang.String getPattern() {
		if(_pattern != null )
			return _pattern;

		ValueExpression ve = getValueExpression("pattern");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : "MM/dd/yyyy";
	}
	public void setPattern(java.lang.String _pattern) {
		this._pattern = _pattern;
	}

	public java.lang.Object getLocale() {
		if(_locale != null )
			return _locale;

		ValueExpression ve = getValueExpression("locale");
		return ve != null ? (java.lang.Object) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setLocale(java.lang.Object _locale) {
		this._locale = _locale;
	}

	public boolean isShowWeekdays() {
		if(_showWeekdays != null )
			return _showWeekdays;

		ValueExpression ve = getValueExpression("showWeekdays");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : true;
	}
	public void setShowWeekdays(boolean _showWeekdays) {
		this._showWeekdays = _showWeekdays;
	}

	public java.lang.String getMonthFormat() {
		if(_monthFormat != null )
			return _monthFormat;

		ValueExpression ve = getValueExpression("monthFormat");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setMonthFormat(java.lang.String _monthFormat) {
		this._monthFormat = _monthFormat;
	}

	public java.lang.String getWeekdayFormat() {
		if(_weekdayFormat != null )
			return _weekdayFormat;

		ValueExpression ve = getValueExpression("weekdayFormat");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setWeekdayFormat(java.lang.String _weekdayFormat) {
		this._weekdayFormat = _weekdayFormat;
	}

	public int getStartWeekday() {
		if(_startWeekday != null )
			return _startWeekday;

		ValueExpression ve = getValueExpression("startWeekday");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 0;
	}
	public void setStartWeekday(int _startWeekday) {
		this._startWeekday = _startWeekday;
	}

	public java.lang.String getPopupIcon() {
		if(_popupIcon != null )
			return _popupIcon;

		ValueExpression ve = getValueExpression("popupIcon");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setPopupIcon(java.lang.String _popupIcon) {
		this._popupIcon = _popupIcon;
	}

	public boolean isNavigator() {
		if(_navigator != null )
			return _navigator;

		ValueExpression ve = getValueExpression("navigator");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : true;
	}
	public void setNavigator(boolean _navigator) {
		this._navigator = _navigator;
	}

	public java.lang.Object getPagedate() {
		if(_pagedate != null )
			return _pagedate;

		ValueExpression ve = getValueExpression("pagedate");
		return ve != null ? (java.lang.Object) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setPagedate(java.lang.Object _pagedate) {
		this._pagedate = _pagedate;
	}

	public java.lang.Object getTimeZone() {
		if(_timeZone != null )
			return _timeZone;

		ValueExpression ve = getValueExpression("timeZone");
		return ve != null ? (java.lang.Object) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setTimeZone(java.lang.Object _timeZone) {
		this._timeZone = _timeZone;
	}

	public boolean isShowWeekHeader() {
		if(_showWeekHeader != null )
			return _showWeekHeader;

		ValueExpression ve = getValueExpression("showWeekHeader");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setShowWeekHeader(boolean _showWeekHeader) {
		this._showWeekHeader = _showWeekHeader;
	}

	public boolean isShowWeekFooter() {
		if(_showWeekFooter != null )
			return _showWeekFooter;

		ValueExpression ve = getValueExpression("showWeekFooter");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setShowWeekFooter(boolean _showWeekFooter) {
		this._showWeekFooter = _showWeekFooter;
	}

	public boolean isReadOnlyInputText() {
		if(_readOnlyInputText != null )
			return _readOnlyInputText;

		ValueExpression ve = getValueExpression("readOnlyInputText");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : true;
	}
	public void setReadOnlyInputText(boolean _readOnlyInputText) {
		this._readOnlyInputText = _readOnlyInputText;
	}

	private java.util.Locale appropriateLocale;
	private java.util.TimeZone appropriateTimeZone;
	
	java.util.Locale calculateLocale(FacesContext facesContext) {
		if(appropriateLocale == null) {
			Object userLocale = getLocale();
			if(userLocale != null) {
				if(userLocale instanceof String)
					appropriateLocale = new java.util.Locale((String) userLocale, "");
				else if(userLocale instanceof java.util.Locale)
					appropriateLocale = (java.util.Locale) userLocale;
				else
					throw new IllegalArgumentException("Type:" + userLocale.getClass() + " is not a valid locale type for calendar:" + this.getClientId(facesContext));
			} else {
				appropriateLocale = facesContext.getViewRoot().getLocale();
			}
		}
		
		return appropriateLocale;
	}
	
	java.util.TimeZone calculateTimeZone() {
		if(appropriateTimeZone == null) {
			Object usertimeZone = getTimeZone();
			if(usertimeZone != null) {
				if(usertimeZone instanceof String)
					appropriateTimeZone =  java.util.TimeZone.getTimeZone((String) usertimeZone);
				else if(usertimeZone instanceof java.util.TimeZone)
					appropriateTimeZone = (java.util.TimeZone) usertimeZone;
				else
					throw new IllegalArgumentException("TimeZone could be either String or java.util.TimeZone");
			} else {
				appropriateTimeZone = java.util.TimeZone.getDefault();
			}
		}
		
		return appropriateTimeZone;
	}

	protected FacesContext getFacesContext() {
		return FacesContext.getCurrentInstance();
	}
	public Object saveState(FacesContext context) {
		Object values[] = new Object[22];
		values[0] = super.saveState(context);
		values[1] = _widgetVar;
		values[2] = _title;
		values[3] = _mindate;
		values[4] = _maxdate;
		values[5] = _selection;
		values[6] = _pages;
		values[7] = _close;
		values[8] = _mode;
		values[9] = _pattern;
		values[10] = _locale;
		values[11] = _showWeekdays;
		values[12] = _monthFormat;
		values[13] = _weekdayFormat;
		values[14] = _startWeekday;
		values[15] = _popupIcon;
		values[16] = _navigator;
		values[17] = _pagedate;
		values[18] = _timeZone;
		values[19] = _showWeekHeader;
		values[20] = _showWeekFooter;
		values[21] = _readOnlyInputText;
		return ((Object) values);
	}
	public void restoreState(FacesContext context, Object state) {
		Object values[] = (Object[]) state;
		super.restoreState(context, values[0]);
		_widgetVar = (java.lang.String) values[1];
		_title = (java.lang.String) values[2];
		_mindate = (java.lang.Object) values[3];
		_maxdate = (java.lang.Object) values[4];
		_selection = (java.lang.String) values[5];
		_pages = (java.lang.Integer) values[6];
		_close = (java.lang.Boolean) values[7];
		_mode = (java.lang.String) values[8];
		_pattern = (java.lang.String) values[9];
		_locale = (java.lang.Object) values[10];
		_showWeekdays = (java.lang.Boolean) values[11];
		_monthFormat = (java.lang.String) values[12];
		_weekdayFormat = (java.lang.String) values[13];
		_startWeekday = (java.lang.Integer) values[14];
		_popupIcon = (java.lang.String) values[15];
		_navigator = (java.lang.Boolean) values[16];
		_pagedate = (java.lang.Object) values[17];
		_timeZone = (java.lang.Object) values[18];
		_showWeekHeader = (java.lang.Boolean) values[19];
		_showWeekFooter = (java.lang.Boolean) values[20];
		_readOnlyInputText = (java.lang.Boolean) values[21];
	}

	protected ResourceHolder getResourceHolder() {
		FacesContext facesContext = getFacesContext();
		if(facesContext == null)
			return null;

		ValueExpression ve = facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), "#{primeFacesResourceHolder}", ResourceHolder.class);

		return (ResourceHolder) ve.getValue(facesContext.getELContext());
	}
}