/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.lightbox;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.lightbox.LightBox;
import org.primefaces.renderkit.CoreRenderer;

public class LightBoxRenderer
extends CoreRenderer {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        LightBox lightBox = (LightBox)component;
        String clientId = lightBox.getClientId(facesContext);
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)lightBox);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write("var lightBoxTarget = PrimeFaces.escapeClientId('" + clientId + "')" + " + ' a';\n");
        writer.write(widgetVar + " = jQuery(lightBoxTarget).colorbox({");
        writer.write("transition:'" + lightBox.getTransition() + "'");
        this.encodeCFG(facesContext, lightBox);
        writer.write("});\n");
        writer.write("});\n");
        writer.endElement("script");
        writer.startElement("div", (UIComponent)lightBox);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (lightBox.getStyle() != null) {
            writer.writeAttribute("style", (Object)lightBox.getStyle(), null);
        }
        if (lightBox.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)lightBox.getStyleClass(), null);
        }
    }

    private void encodeCFG(FacesContext facesContext, LightBox lightBox) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = lightBox.getClientId(facesContext);
        if (lightBox.getSpeed() != 350) {
            writer.write(",speed:" + lightBox.getSpeed());
        }
        if (lightBox.getWidth() != null) {
            writer.write(",width:'" + lightBox.getWidth() + "'");
        }
        if (lightBox.getHeight() != null) {
            writer.write(",height:'" + lightBox.getHeight() + "'");
        }
        if (lightBox.isIframe()) {
            writer.write(",iframe:true");
        }
        if (lightBox.getFacet("inline") != null) {
            writer.write(",inline:true");
            writer.write(",href:'#" + clientId + "_inline'");
        }
        if (lightBox.getOpacity() != 0.85) {
            writer.write(",opacity:" + lightBox.getOpacity());
        }
        if (lightBox.isVisible()) {
            writer.write(",open:true");
        }
        if (lightBox.isSlideshow()) {
            writer.write(",slideshow:true");
            writer.write(",slideshowSpeed:" + lightBox.getSlideshowSpeed());
            if (lightBox.getSlideshowStartText() != null) {
                writer.write(",slideshowStart:'" + lightBox.getSlideshowStartText() + "'");
            }
            if (lightBox.getSlideshowStopText() != null) {
                writer.write(",slideshowStop:'" + lightBox.getSlideshowStopText() + "'");
            }
            if (!lightBox.isSlideshowAuto()) {
                writer.write(",slideshowAuto:false");
            }
        }
        if (!lightBox.isOverlayClose()) {
            writer.write(",overlayClose:false");
        }
        if (lightBox.getCurrentTemplate() != null) {
            writer.write(",current:'" + lightBox.getCurrentTemplate() + "'");
        }
        if (lightBox.isGroup()) {
            writer.write(",rel:'" + clientId + "'");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        LightBox lightBox = (LightBox)component;
        String clientId = lightBox.getClientId(facesContext);
        if (lightBox.getFacet("inline") != null) {
            writer.startElement("div", null);
            writer.writeAttribute("style", (Object)"display:none", null);
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(clientId + "_inline"), null);
            this.renderChild(facesContext, lightBox.getFacet("inline"));
            writer.endElement("div");
            writer.endElement("div");
        }
        writer.endElement("div");
    }
}

