/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.layout;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.layout.Layout;
import org.primefaces.component.layout.LayoutUnit;
import org.primefaces.event.LayoutUnitToggleEvent;
import org.primefaces.renderkit.CoreRenderer;

public class LayoutRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        String clientId;
        Layout layout = (Layout)component;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId = layout.getClientId(facesContext))) {
            String pane = (String)params.get("pane");
            String state = (String)params.get("state");
            layout.queueEvent(new LayoutUnitToggleEvent((UIComponent)layout, pane, state));
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Layout layout = (Layout)component;
        String clientId = layout.getClientId(facesContext);
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)layout);
        String targetElement = null;
        targetElement = layout.isFullPage() ? "body" : (layout.getParent() instanceof LayoutUnit ? layout.getParent().getClientId(facesContext) : layout.getClientId(facesContext));
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(document).ready(function() {\n");
        writer.write(var + " = new PrimeFaces.widget.Layout('" + targetElement + "', {");
        Iterator kids = layout.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!kid.isRendered() || !(kid instanceof LayoutUnit)) continue;
            LayoutUnit unit = (LayoutUnit)kid;
            String jqId = this.escapeJQId(unit.getClientId(facesContext));
            writer.write(unit.getPosition() + ": {");
            writer.write("paneSelector:'" + jqId + "'");
            if (!unit.isResizable()) {
                writer.write(",resizable:false");
            }
            if (!unit.isClosable()) {
                writer.write(",closable:false");
            }
            if (!unit.isSlidable()) {
                writer.write(",slidable:false");
            }
            if (unit.getSize() != null) {
                writer.write(",size:" + unit.getSize());
            }
            if (unit.getMinSize() != 50) {
                writer.write(",minSize:" + unit.getMinSize());
            }
            if (unit.getMaxSize() != 0) {
                writer.write(",maxSize:" + unit.getMaxSize());
            }
            if (unit.getSpacingOpen() != 6) {
                writer.write(",spacing_open:" + unit.getSpacingOpen());
            }
            if (unit.getSpacingClosed() != 6) {
                writer.write(",spacing_closed:" + unit.getSpacingClosed());
            }
            if (unit.isClosed()) {
                writer.write(",initClosed:true");
            }
            if (unit.getEffect() != null) {
                writer.write(",fxName:'" + unit.getEffect() + "'");
            }
            if (unit.getEffectSpeed() != null) {
                writer.write(",fxSpeed:'" + unit.getEffectSpeed() + "'");
            }
            if (unit.getTogglerLengthOpen() != null) {
                writer.write(",togglerLength_open:'" + unit.getTogglerLengthOpen() + "'");
            }
            if (unit.getTogglerLengthClosed() != null) {
                writer.write(",togglerLength_closed:'" + unit.getTogglerLengthClosed() + "'");
            }
            if (unit.getTogglerAlignOpen() != null) {
                writer.write(",togglerAlign_open:'" + unit.getTogglerAlignOpen() + "'");
            }
            if (unit.getTogglerAlignClosed() != null) {
                writer.write(",togglerAlign_closed:'" + unit.getTogglerAlignClosed() + "'");
            }
            if (unit.getTogglerTipOpen() != null) {
                writer.write(",togglerTip_open:'" + unit.getTogglerTipOpen() + "'");
            }
            if (unit.getTogglerTipClosed() != null) {
                writer.write(",togglerTip_closed:'" + unit.getTogglerTipClosed() + "'");
            }
            if (unit.getResizerTip() != null) {
                writer.write(",resizerTip:'" + unit.getResizerTip() + "'");
            }
            if (layout.getToggleListener() != null) {
                writer.write(",onclose:function(unit) {");
                writer.write("PrimeFaces.ajax.AjaxRequest('" + this.getActionURL(facesContext) + "',");
                writer.write("{}");
                writer.write(",{'" + clientId + "':'" + clientId + "'");
                writer.write(",'state':'close','pane':unit, 'primefacesPartialProcess':'" + clientId + "'});");
                writer.write("}");
                writer.write(",onopen:function(unit) {");
                writer.write("PrimeFaces.ajax.AjaxRequest('" + this.getActionURL(facesContext) + "',");
                writer.write("{}");
                writer.write(",{'" + clientId + "':'" + clientId + "'");
                writer.write(",'state':'open','pane':unit, 'primefacesPartialProcess':'" + clientId + "'});");
                writer.write("}");
            }
            writer.write("}");
            if (!kids.hasNext()) continue;
            writer.write(",");
        }
        writer.write("});});\n");
        writer.endElement("script");
        if (this.isElementLayout(layout)) {
            writer.startElement("div", (UIComponent)layout);
            writer.writeAttribute("id", (Object)layout.getClientId(facesContext), null);
            if (layout.getStyle() != null) {
                writer.writeAttribute("style", (Object)layout.getStyle(), null);
            }
            if (layout.getStyleClass() != null) {
                writer.writeAttribute("class", (Object)layout.getStyleClass(), null);
            }
        }
    }

    private String escapeJQId(String id) {
        return "#" + id.replaceAll(":", "\\\\\\\\:");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Layout layout = (Layout)component;
        if (this.isElementLayout(layout)) {
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.endElement("div");
        }
    }

    private boolean isElementLayout(Layout layout) {
        return !layout.isFullPage() && !(layout.getParent() instanceof LayoutUnit);
    }
}

