/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.idlemonitor;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.idlemonitor.IdleMonitor;
import org.primefaces.event.IdleEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class IdleMonitorRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        IdleMonitor monitor;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey((monitor = (IdleMonitor)component).getClientId(facesContext))) {
            monitor.queueEvent(new IdleEvent((UIComponent)monitor));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        IdleMonitor monitor = (IdleMonitor)component;
        String clientId = monitor.getClientId(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("new PrimeFaces.widget.IdleMonitor('" + clientId + "', {");
        writer.write("timeout:" + monitor.getTimeout());
        if (monitor.getIdleListener() != null) {
            UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)monitor);
            if (form == null) {
                throw new FacesException("UIAjax:" + clientId + " needs to be enclosed in a form when using an idleListener");
            }
            writer.write(",hasIdleListener:true");
            writer.write(",actionURL:'" + this.getActionURL(facesContext) + "'");
            writer.write(",formId:'" + form.getClientId(facesContext) + "'");
            writer.write(",update:'" + ComponentUtils.findClientIds(facesContext, (UIComponent)monitor, monitor.getUpdate()) + "'");
        }
        if (monitor.getOnidle() != null) {
            writer.write(",onidle: function() {" + monitor.getOnidle() + ";}");
        }
        if (monitor.getOnactive() != null) {
            writer.write(",onactive: function() {" + monitor.getOnactive() + ";}");
        }
        writer.write("});\n");
        writer.endElement("script");
    }
}

