/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.primefaces.model.StreamedContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicContentStreamer
implements PhaseListener {
    public static final String DYNAMIC_CONTENT_PARAM = "primefacesDynamicContent";
    public static final String CONTENT_TYPE_PARAM = "contentType";
    public static final String GRAPHIC_TEXT_PARAM = "primefacesGraphicText";
    private Logger logger = Logger.getLogger(DynamicContentStreamer.class.getName());

    public void beforePhase(PhaseEvent phaseEvent) {
        FacesContext facesContext = phaseEvent.getFacesContext();
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(DYNAMIC_CONTENT_PARAM)) {
            this.streamDynamicContent(facesContext, (String)params.get(DYNAMIC_CONTENT_PARAM));
        } else if (params.containsKey(GRAPHIC_TEXT_PARAM)) {
            this.streamGraphicText(facesContext, params);
        }
    }

    private void streamDynamicContent(FacesContext facesContext, String expression) {
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        ELContext elContext = facesContext.getELContext();
        ValueExpression ve = facesContext.getApplication().getExpressionFactory().createValueExpression(elContext, "#{" + expression + "}", StreamedContent.class);
        StreamedContent content = (StreamedContent)ve.getValue(elContext);
        if (content != null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Streaming image: {0}", ve.getExpressionString());
            }
            try {
                int length;
                response.setContentType(content.getContentType());
                byte[] buffer = new byte[2048];
                while ((length = content.getStream().read(buffer)) >= 0) {
                    response.getOutputStream().write(buffer, 0, length);
                }
                this.finalizeResponse(facesContext);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Exception in streaming image {0}", ve.getExpressionString());
            }
        }
    }

    private void streamGraphicText(FacesContext facesContext, Map<String, String> params) {
        try {
            HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
            String fontNameVal = params.get("fontname");
            String fontStyleVal = params.get("fontstyle");
            String fontSizeVal = params.get("fontsize");
            String graphicTextVal = params.get("graphictext");
            BufferedImage bufferedImg = this.createBufferedImage(fontNameVal, fontStyleVal, fontSizeVal, graphicTextVal);
            ServletOutputStream outputStream = response.getOutputStream();
            ImageIO.write((RenderedImage)bufferedImg, "jpg", (OutputStream)outputStream);
            this.finalizeResponse(facesContext);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "IOException in streaming graphic text image");
        }
    }

    private BufferedImage createBufferedImage(String fontNameVal, String fontStyleVal, String fontSizeVal, String graphicTextVal) {
        BufferedImage bufferedImg = new BufferedImage(1, 1, 1);
        Graphics2D g2 = bufferedImg.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int fontStyle = 0;
        if ("bold".equals(fontStyleVal)) {
            fontStyle = 1;
        }
        if ("italic".equals(fontStyleVal)) {
            fontStyle = 2;
        }
        Font font = new Font(fontNameVal, fontStyle, Integer.parseInt(fontSizeVal));
        FontRenderContext fc = g2.getFontRenderContext();
        Rectangle2D bounds = font.getStringBounds(graphicTextVal, fc);
        int width = (int)bounds.getWidth();
        int height = (int)bounds.getHeight();
        bufferedImg = new BufferedImage(width, height, 1);
        g2 = bufferedImg.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(font);
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, width, height);
        g2.setColor(Color.BLACK);
        g2.drawString(graphicTextVal, 0, (int)(-bounds.getY()));
        return bufferedImg;
    }

    private void finalizeResponse(FacesContext facesContext) throws IOException {
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        response.setStatus(200);
        response.getOutputStream().flush();
        facesContext.responseComplete();
    }

    public void afterPhase(PhaseEvent phaseEvent) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }
}

