/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.touch.component.rowitem;

import javax.faces.webapp.UIComponentELTag;
import javax.faces.component.UIComponent;

public class RowItemTag extends UIComponentELTag {

	private javax.el.ValueExpression _value;
	private javax.el.MethodExpression _actionListener;
	private javax.el.MethodExpression _action;
	private javax.el.ValueExpression _immediate;
	private javax.el.ValueExpression _view;
	private javax.el.ValueExpression _url;
	private javax.el.ValueExpression _update;

	public void release(){
		super.release();
		this._value = null;
		this._actionListener = null;
		this._action = null;
		this._immediate = null;
		this._view = null;
		this._url = null;
		this._update = null;
	}

	protected void setProperties(UIComponent comp){
		super.setProperties(comp);

		org.primefaces.touch.component.rowitem.RowItem component = null;
		try {
			component = (org.primefaces.touch.component.rowitem.RowItem) comp;
		} catch(ClassCastException cce) {
			throw new IllegalStateException("Component " + component.toString() + " not expected type.");
		}

		if(_value != null) {
			component.setValueExpression("value", _value);
		}
		if(_actionListener != null) {
			component.addActionListener(new javax.faces.event.MethodExpressionActionListener(_actionListener));
		}
		if(_action != null) {
			component.setActionExpression(_action);
		}
		if(_immediate != null) {
			component.setValueExpression("immediate", _immediate);
		}
		if(_view != null) {
			component.setValueExpression("view", _view);
		}
		if(_url != null) {
			component.setValueExpression("url", _url);
		}
		if(_update != null) {
			component.setValueExpression("update", _update);
		}
	}

	public String getComponentType() {
		return RowItem.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return "org.primefaces.touch.component.RowItemRenderer";
	}

	public void setValue(javax.el.ValueExpression expression){
		this._value = expression;
	}

	public void setActionListener(javax.el.MethodExpression expression){
		this._actionListener = expression;
	}

	public void setAction(javax.el.MethodExpression expression){
		this._action = expression;
	}

	public void setImmediate(javax.el.ValueExpression expression){
		this._immediate = expression;
	}

	public void setView(javax.el.ValueExpression expression){
		this._view = expression;
	}

	public void setUrl(javax.el.ValueExpression expression){
		this._url = expression;
	}

	public void setUpdate(javax.el.ValueExpression expression){
		this._update = expression;
	}

}