/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.menuitem;

import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.el.ValueExpression;
import javax.el.MethodExpression;
import javax.faces.render.Renderer;
import java.io.IOException;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.resource.ResourceHolder;


public class MenuItem extends UIComponentBase {


	public static final String COMPONENT_TYPE = "org.primefaces.component.MenuItem";
	public static final String COMPONENT_FAMILY = "org.primefaces.component";

	private java.lang.String _label;
	private java.lang.String _url;
	private java.lang.String _target;
	private java.lang.String _helpText;
	private java.lang.String _style;
	private java.lang.String _styleClass;
	private java.lang.String _onclick;
	public MenuItem() {
		setRendererType(null);
		ResourceHolder resourceHolder = getResourceHolder();
		if(resourceHolder != null) {
		}
	}

	public String getFamily() {
		return COMPONENT_FAMILY;
	}

	public java.lang.String getLabel() {
		if(_label != null )
			return _label;

		ValueExpression ve = getValueExpression("label");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setLabel(java.lang.String _label) {
		this._label = _label;
	}

	public java.lang.String getUrl() {
		if(_url != null )
			return _url;

		ValueExpression ve = getValueExpression("url");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setUrl(java.lang.String _url) {
		this._url = _url;
	}

	public java.lang.String getTarget() {
		if(_target != null )
			return _target;

		ValueExpression ve = getValueExpression("target");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setTarget(java.lang.String _target) {
		this._target = _target;
	}

	public java.lang.String getHelpText() {
		if(_helpText != null )
			return _helpText;

		ValueExpression ve = getValueExpression("helpText");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setHelpText(java.lang.String _helpText) {
		this._helpText = _helpText;
	}

	public java.lang.String getStyle() {
		if(_style != null )
			return _style;

		ValueExpression ve = getValueExpression("style");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setStyle(java.lang.String _style) {
		this._style = _style;
	}

	public java.lang.String getStyleClass() {
		if(_styleClass != null )
			return _styleClass;

		ValueExpression ve = getValueExpression("styleClass");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setStyleClass(java.lang.String _styleClass) {
		this._styleClass = _styleClass;
	}

	public java.lang.String getOnclick() {
		if(_onclick != null )
			return _onclick;

		ValueExpression ve = getValueExpression("onclick");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setOnclick(java.lang.String _onclick) {
		this._onclick = _onclick;
	}


	protected FacesContext getFacesContext() {
		return FacesContext.getCurrentInstance();
	}
	public Object saveState(FacesContext context) {
		Object values[] = new Object[8];
		values[0] = super.saveState(context);
		values[1] = _label;
		values[2] = _url;
		values[3] = _target;
		values[4] = _helpText;
		values[5] = _style;
		values[6] = _styleClass;
		values[7] = _onclick;
		return ((Object) values);
	}
	public void restoreState(FacesContext context, Object state) {
		Object values[] = (Object[]) state;
		super.restoreState(context, values[0]);
		_label = (java.lang.String) values[1];
		_url = (java.lang.String) values[2];
		_target = (java.lang.String) values[3];
		_helpText = (java.lang.String) values[4];
		_style = (java.lang.String) values[5];
		_styleClass = (java.lang.String) values[6];
		_onclick = (java.lang.String) values[7];
	}

	protected ResourceHolder getResourceHolder() {
		FacesContext facesContext = getFacesContext();
		if(facesContext == null)
			return null;

		ValueExpression ve = facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), "#{primeFacesResourceHolder}", ResourceHolder.class);

		return (ResourceHolder) ve.getValue(facesContext.getELContext());
	}
}