/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.accordionpanel;

import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.el.ValueExpression;
import javax.el.MethodExpression;
import javax.faces.render.Renderer;
import java.io.IOException;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.resource.ResourceHolder;


public class AccordionPanel extends UIPanel {


	public static final String COMPONENT_TYPE = "org.primefaces.component.AccordionPanel";
	public static final String COMPONENT_FAMILY = "org.primefaces.component";
	private static final String DEFAULT_RENDERER = "org.primefaces.component.AccordionPanelRenderer";

	private java.lang.String _widgetVar;
	private java.lang.String _activeIndex;
	private java.lang.String _style;
	private java.lang.String _styleClass;
	private java.lang.Boolean _multiple;
	private java.lang.Double _speed;
	private java.lang.Boolean _animate;
	private java.lang.Boolean _hover;
	private java.lang.Integer _hoverDelay;
	public AccordionPanel() {
		setRendererType(DEFAULT_RENDERER);
		ResourceHolder resourceHolder = getResourceHolder();
		if(resourceHolder != null) {
			resourceHolder.addResource("/yui/accordion/assets/skins/sam/accordionview.css");
			resourceHolder.addResource("/yui/utilities/utilities.js");
			resourceHolder.addResource("/yui/accordion/accordionview-min.js");
			resourceHolder.addResource("/primefaces/core/core.js");
			resourceHolder.addResource("/primefaces/accordion/accordion.js");
		}
	}

	public String getFamily() {
		return COMPONENT_FAMILY;
	}

	public java.lang.String getWidgetVar() {
		if(_widgetVar != null )
			return _widgetVar;

		ValueExpression ve = getValueExpression("widgetVar");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setWidgetVar(java.lang.String _widgetVar) {
		this._widgetVar = _widgetVar;
	}

	public java.lang.String getActiveIndex() {
		if(_activeIndex != null )
			return _activeIndex;

		ValueExpression ve = getValueExpression("activeIndex");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setActiveIndex(java.lang.String _activeIndex) {
		this._activeIndex = _activeIndex;
	}

	public java.lang.String getStyle() {
		if(_style != null )
			return _style;

		ValueExpression ve = getValueExpression("style");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setStyle(java.lang.String _style) {
		this._style = _style;
	}

	public java.lang.String getStyleClass() {
		if(_styleClass != null )
			return _styleClass;

		ValueExpression ve = getValueExpression("styleClass");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setStyleClass(java.lang.String _styleClass) {
		this._styleClass = _styleClass;
	}

	public boolean isMultiple() {
		if(_multiple != null )
			return _multiple;

		ValueExpression ve = getValueExpression("multiple");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setMultiple(boolean _multiple) {
		this._multiple = _multiple;
	}

	public double getSpeed() {
		if(_speed != null )
			return _speed;

		ValueExpression ve = getValueExpression("speed");
		return ve != null ? (java.lang.Double) ve.getValue(getFacesContext().getELContext())  : 0.5;
	}
	public void setSpeed(double _speed) {
		this._speed = _speed;
	}

	public boolean isAnimate() {
		if(_animate != null )
			return _animate;

		ValueExpression ve = getValueExpression("animate");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : true;
	}
	public void setAnimate(boolean _animate) {
		this._animate = _animate;
	}

	public boolean isHover() {
		if(_hover != null )
			return _hover;

		ValueExpression ve = getValueExpression("hover");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setHover(boolean _hover) {
		this._hover = _hover;
	}

	public int getHoverDelay() {
		if(_hoverDelay != null )
			return _hoverDelay;

		ValueExpression ve = getValueExpression("hoverDelay");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 500;
	}
	public void setHoverDelay(int _hoverDelay) {
		this._hoverDelay = _hoverDelay;
	}


	protected FacesContext getFacesContext() {
		return FacesContext.getCurrentInstance();
	}
	public Object saveState(FacesContext context) {
		Object values[] = new Object[10];
		values[0] = super.saveState(context);
		values[1] = _widgetVar;
		values[2] = _activeIndex;
		values[3] = _style;
		values[4] = _styleClass;
		values[5] = _multiple;
		values[6] = _speed;
		values[7] = _animate;
		values[8] = _hover;
		values[9] = _hoverDelay;
		return ((Object) values);
	}
	public void restoreState(FacesContext context, Object state) {
		Object values[] = (Object[]) state;
		super.restoreState(context, values[0]);
		_widgetVar = (java.lang.String) values[1];
		_activeIndex = (java.lang.String) values[2];
		_style = (java.lang.String) values[3];
		_styleClass = (java.lang.String) values[4];
		_multiple = (java.lang.Boolean) values[5];
		_speed = (java.lang.Double) values[6];
		_animate = (java.lang.Boolean) values[7];
		_hover = (java.lang.Boolean) values[8];
		_hoverDelay = (java.lang.Integer) values[9];
	}

	protected ResourceHolder getResourceHolder() {
		FacesContext facesContext = getFacesContext();
		if(facesContext == null)
			return null;

		ValueExpression ve = facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), "#{primeFacesResourceHolder}", ResourceHolder.class);

		return (ResourceHolder) ve.getValue(facesContext.getELContext());
	}
}