/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.schedule;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletResponse;
import org.primefaces.component.schedule.Schedule;
import org.primefaces.component.schedule.ScheduleEventDialog;
import org.primefaces.event.ScheduleDateSelectEvent;
import org.primefaces.event.ScheduleEntrySelectEvent;
import org.primefaces.model.ScheduleEvent;
import org.primefaces.model.ScheduleModel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleRenderer
extends CoreRenderer
implements PartialRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Schedule schedule = (Schedule)component;
        String clientId = schedule.getClientId(facesContext);
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String selectedEventParam = clientId + "_selectedEventId";
        String selectedDateParam = clientId + "_selectedDate";
        String movedEventParam = clientId + "_movedEventId";
        if (params.containsKey(schedule.getClientId(facesContext))) {
            if (params.containsKey(selectedEventParam)) {
                String eventId = (String)params.get(selectedEventParam);
                ScheduleModel model = (ScheduleModel)schedule.getValue();
                Object selectedEvent = model.getEvent(eventId);
                schedule.queueEvent(new ScheduleEntrySelectEvent((UIComponent)schedule, (ScheduleEvent)selectedEvent));
            } else if (params.containsKey(selectedDateParam)) {
                try {
                    String dateAsString = (String)params.get(selectedDateParam);
                    SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
                    schedule.queueEvent(new ScheduleDateSelectEvent(component, format.parse(dateAsString)));
                }
                catch (ParseException e) {
                    throw new FacesException("Cannot parse selected date", (Throwable)e);
                }
            } else if (params.containsKey(movedEventParam)) {
                String eventId = (String)params.get(movedEventParam);
                int dayDelta = Integer.valueOf((String)params.get("dayDelta"));
                ScheduleModel model = (ScheduleModel)schedule.getValue();
                Object movedEvent = model.getEvent(eventId);
                Calendar calendar = Calendar.getInstance();
                if (!params.containsKey("resized")) {
                    calendar.setTime(movedEvent.getStartDate());
                    calendar.roll(5, dayDelta);
                    movedEvent.getStartDate().setTime(calendar.getTimeInMillis());
                }
                calendar = Calendar.getInstance();
                calendar.setTime(movedEvent.getEndDate());
                calendar.roll(5, dayDelta);
                movedEvent.getEndDate().setTime(calendar.getTimeInMillis());
                facesContext.renderResponse();
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Schedule schedule = (Schedule)component;
        this.encodeScript(facesContext, schedule);
        this.encodeMarkup(facesContext, schedule);
    }

    @Override
    public void encodePartially(FacesContext facesContext, UIComponent component) throws IOException {
        Schedule schedule = (Schedule)component;
        String clientId = schedule.getClientId(facesContext);
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String selectedEventParam = clientId + "_selectedEventId";
        String selectedDateParam = clientId + "_selectedDate";
        String startDateParam = clientId + "_start";
        String endDateParam = clientId + "_end";
        if (params.containsKey(selectedEventParam) || params.containsKey(selectedDateParam)) {
            this.renderChildren(facesContext, (UIComponent)schedule.getEventDialog());
        } else {
            ScheduleModel model = (ScheduleModel)schedule.getValue();
            if (model.isLazy()) {
                try {
                    SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
                    Date startDate = format.parse((String)params.get(startDateParam));
                    Date endDate = format.parse((String)params.get(endDateParam));
                    model.fetchEvents(startDate, endDate);
                }
                catch (ParseException e) {
                    throw new FacesException("Cannot parse date", (Throwable)e);
                }
            }
            this.encodeEventsAsJSON(facesContext, model);
        }
    }

    private void encodeEventsAsJSON(FacesContext facesContext, ScheduleModel<ScheduleEvent> model) throws IOException {
        ServletResponse response = (ServletResponse)facesContext.getExternalContext().getResponse();
        response.setContentType("application/json");
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.write("{");
        writer.write("\"events\" : [");
        Iterator<ScheduleEvent> iterator = model.getEvents().iterator();
        while (iterator.hasNext()) {
            ScheduleEvent event = iterator.next();
            writer.write("{");
            writer.write("\"id\": \"" + event.getId() + "\"");
            writer.write(",\"title\": \"" + event.getTitle() + "\"");
            writer.write(",\"start\": " + event.getStartDate().getTime());
            writer.write(",\"end\": " + event.getEndDate().getTime());
            writer.write(",\"allDay\":" + event.isAllDay());
            if (event.getStyleClass() != null) {
                writer.write(",\"className\":\"" + event.getStyleClass() + "\"");
            }
            writer.write("}");
            if (!iterator.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]}");
    }

    private void encodeScript(FacesContext facesContext, Schedule schedule) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = schedule.getClientId(facesContext);
        String scheduleVar = this.createUniqueWidgetVar(facesContext, (UIComponent)schedule);
        UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)schedule);
        if (form == null) {
            throw new FacesException("Schedule : \"" + clientId + "\" must be inside a form element");
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write(scheduleVar + " = new PrimeFaces.widget.Schedule('" + clientId + "'");
        writer.write(",{");
        writer.write("defaultView:'" + schedule.getView() + "'");
        writer.write(",language:'" + schedule.calculateLocale(facesContext).getLanguage() + "'");
        writer.write(",formId:'" + form.getClientId(facesContext) + "'");
        writer.write(",url:'" + this.getActionURL(facesContext) + "'");
        if (schedule.getInitialDate() != null) {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)schedule.getInitialDate());
            writer.write(",year: " + c.get(1));
            writer.write(",month: " + c.get(2));
            writer.write(",date: " + c.get(5));
        }
        if (schedule.getAspectRatio() != null) {
            writer.write(",aspectRatio: '" + schedule.getAspectRatio() + "'");
        }
        if (schedule.isTheme()) {
            writer.write(",theme:true");
        }
        if (!schedule.isShowWeekends()) {
            writer.write(",weekends:false");
        }
        if (schedule.isEditable()) {
            writer.write(",editable:true");
        }
        if (schedule.getEventDialog() != null) {
            writer.write(",hasEventDialog:true");
        }
        if (!schedule.isDraggable()) {
            writer.write(",disableDragging:true");
        }
        if (!schedule.isResizable()) {
            writer.write(",disableResizing:true");
        }
        writer.write(",header: {left: 'prev,next today', center: 'title', right: 'month,agendaWeek,agendaDay'}");
        writer.write("});});\n");
        writer.endElement("script");
    }

    private void encodeMarkup(FacesContext facesContext, Schedule schedule) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = schedule.getClientId(facesContext);
        ScheduleEventDialog dialog = schedule.getEventDialog();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (schedule.getStyle() != null) {
            writer.writeAttribute("style", (Object)schedule.getStyle(), "style");
        }
        if (schedule.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)schedule.getStyleClass(), "style");
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_container"), null);
        writer.endElement("div");
        if (dialog != null) {
            this.encodeDialogMarkup(facesContext, schedule, dialog);
        }
        writer.endElement("div");
    }

    private void encodeDialogMarkup(FacesContext facesContext, Schedule schedule, ScheduleEventDialog dialog) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = schedule.getClientId(facesContext);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_dialogContainer"), null);
        if (dialog.getHeader() != null) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"hd", null);
            writer.write(dialog.getHeader());
            writer.endElement("div");
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_dialogContainer_bd"), null);
        writer.writeAttribute("class", (Object)"bd", null);
        this.renderChildren(facesContext, (UIComponent)dialog);
        writer.endElement("div");
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

