/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.commandlink;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.commandbutton.CommandButton;
import org.primefaces.component.commandlink.CommandLink;
import org.primefaces.component.confirmdialog.ConfirmDialog;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class CommandLinkRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        boolean isSubmitted;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String submittedValue = (String)params.get(component.getClientId(facesContext) + "_submit");
        boolean bl = isSubmitted = submittedValue != null && submittedValue.equals("true");
        if (isSubmitted) {
            component.queueEvent((FacesEvent)new ActionEvent(component));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        CommandLink commandLink = (CommandLink)component;
        this.encodeScript(facesContext, commandLink);
        this.encodeMarkup(facesContext, commandLink);
    }

    private void encodeScript(FacesContext facesContext, CommandLink commandLink) throws IOException {
        ConfirmDialog confirmDialog = this.getConfirmation(commandLink);
        if (confirmDialog != null) {
            ResponseWriter writer = facesContext.getResponseWriter();
            String clientId = commandLink.getClientId(facesContext);
            String confirmVar = this.createUniqueWidgetVar(facesContext, (UIComponent)commandLink);
            writer.startElement("script", (UIComponent)commandLink);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
            String confirmDialogCFGVar = confirmVar + "_cfg";
            this.writeConfirmDialogCFGVariable(facesContext, confirmDialog, confirmDialogCFGVar);
            writer.write(confirmVar + " = new YAHOO.widget.SimpleDialog(\"" + clientId + "_confirmation\", " + confirmDialogCFGVar + ");\n");
            writer.write(confirmVar + ".render();");
            writer.write("});");
            writer.endElement("script");
        }
    }

    private void encodeMarkup(FacesContext facesContext, CommandLink link) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = link.getClientId(facesContext);
        ConfirmDialog confirmDialog = this.getConfirmation(link);
        String confirmVar = this.createUniqueWidgetVar(facesContext, (UIComponent)link);
        UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)link);
        if (form == null) {
            throw new FacesException("Commandlink \"" + clientId + "\" must be inside a form element");
        }
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.startElement("a", (UIComponent)link);
        writer.writeAttribute("href", (Object)"javascript:void(0);", null);
        if (link.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)link.getStyleClass(), null);
        }
        if (confirmDialog != null) {
            writer.writeAttribute("onclick", (Object)(confirmVar + ".show();"), null);
        }
        String onclick = null;
        String formClientId = form.getClientId(facesContext);
        String request = link.isAjax() ? this.getAjaxRequest(facesContext, link, formClientId) : this.getNonAjaxRequest(facesContext, link, formClientId);
        String string = onclick = link.getOnclick() != null ? link.getOnclick() + ";" + request : request;
        if (confirmDialog == null) {
            writer.writeAttribute("onclick", (Object)onclick, "onclick");
        } else {
            onclick = confirmVar + ".hide();" + onclick;
        }
        this.renderPassThruAttributes(facesContext, (UIComponent)link, HTML.LINK_ATTRS, HTML.CLICK_EVENT);
        if (link.getValue() != null) {
            writer.write(link.getValue().toString());
        } else {
            this.renderChildren(facesContext, (UIComponent)link);
        }
        writer.endElement("a");
        if (confirmDialog != null) {
            this.encodeConfirmDialogMarkup(facesContext, link, confirmDialog, onclick, confirmVar);
        }
        writer.endElement("span");
    }

    private String getAjaxRequest(FacesContext facesContext, CommandLink link, String formClientId) {
        String clientId = link.getClientId(facesContext);
        StringBuilder req = new StringBuilder();
        req.append("PrimeFaces.ajax.AjaxRequest('");
        req.append(this.getActionURL(facesContext));
        req.append("',{");
        req.append("formId:'");
        req.append(formClientId);
        req.append("'");
        if (link.isAsync()) {
            req.append(",async:true");
        }
        if (link.getOnstart() != null) {
            req.append(",onstart:function(xhr){" + link.getOnstart() + ";}");
        }
        if (link.getOnerror() != null) {
            req.append(",onerror:function(xhr, status, error){" + link.getOnerror() + ";}");
        }
        if (link.getOnsuccess() != null) {
            req.append(",onsuccess:function(data, status, xhr, args){" + link.getOnsuccess() + ";}");
        }
        if (link.getOncomplete() != null) {
            req.append(",oncomplete:function(xhr, status, args){" + link.getOncomplete() + ";}");
        }
        req.append(",global:" + link.isGlobal());
        req.append("},{");
        req.append("'" + clientId + "_submit" + "'");
        req.append(":");
        req.append("'true'");
        if (link.getUpdate() != null) {
            req.append(",'primefacesPartialUpdate':");
            req.append("'" + ComponentUtils.findClientIds(facesContext, (UIComponent)link, link.getUpdate()) + "'");
        }
        if (link.getProcess() != null) {
            req.append(",'primefacesPartialProcess':");
            req.append("'" + ComponentUtils.findClientIds(facesContext, (UIComponent)link, link.getProcess()) + "'");
        }
        for (UIComponent component : link.getChildren()) {
            if (!(component instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)component;
            req.append(",");
            req.append("'" + parameter.getName() + "'");
            req.append(":");
            req.append("'" + parameter.getValue() + "'");
        }
        req.append("});");
        req.append("return false;");
        return req.toString();
    }

    private String getNonAjaxRequest(FacesContext facesContext, CommandLink link, String formClientId) {
        String clientId = link.getClientId(facesContext);
        HashMap<String, Object> params = new HashMap<String, Object>();
        boolean isPartialProcess = link.getProcess() != null;
        for (UIComponent component : link.getChildren()) {
            if (!(component instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)component;
            params.put(parameter.getName(), parameter.getValue());
        }
        StringBuffer request = new StringBuffer();
        request.append("PrimeFaces.addSubmitParam('" + clientId + "', {'" + clientId + "_submit':'true'");
        if (!params.isEmpty() || isPartialProcess) {
            if (isPartialProcess) {
                request.append(",primefacesPartialProcess:'" + ComponentUtils.findClientIds(facesContext, (UIComponent)link, link.getProcess()) + "'");
            }
            if (!params.isEmpty()) {
                for (String paramName : params.keySet()) {
                    Object paramValue = params.get(paramName);
                    String toSend = paramValue != null ? paramValue.toString() : "";
                    request.append(",'" + paramName + "':'" + toSend + "'");
                }
            }
        }
        request.append("});");
        request.append("jQuery(PrimeFaces.escapeClientId('" + formClientId + "')).submit();");
        return request.toString();
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    protected void encodeConfirmDialogMarkup(FacesContext facesContext, CommandLink link, ConfirmDialog confirmDialog, String onclick, String confirmVar) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = link.getClientId(facesContext);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_confirmation"), null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"hd", null);
        if (confirmDialog.getHeader() != null) {
            writer.write(confirmDialog.getHeader());
        }
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"bd", null);
        if (confirmDialog.getMessage() != null) {
            writer.write(confirmDialog.getMessage());
        }
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ft", null);
        this.encodeConfirmButtonMarkup(facesContext, null, clientId + "_link", confirmDialog.getYesLabel(), onclick);
        this.encodeConfirmButtonMarkup(facesContext, null, clientId + "_noButton", confirmDialog.getNoLabel(), confirmVar + ".hide();return false;");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeConfirmButtonMarkup(FacesContext facesContext, CommandButton button, String id, String label, String onclick) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"submit", null);
        if (label != null) {
            writer.writeAttribute("value", (Object)label, null);
        }
        if (onclick != null) {
            writer.writeAttribute("onclick", (Object)onclick, null);
        }
        writer.endElement("input");
    }

    private void writeConfirmDialogCFGVariable(FacesContext facesContext, ConfirmDialog dialog, String cfgVariable) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.write("var " + cfgVariable + " = {\n");
        writer.write("visible: false");
        writer.write(",icon: YAHOO.widget.SimpleDialog.ICON_" + dialog.getSeverity().toUpperCase());
        if (dialog.getWidth() != null) {
            writer.write(",width:'" + dialog.getWidth() + "'");
        }
        if (dialog.getHeight() != null) {
            writer.write(",height:'" + dialog.getHeight() + "'");
        }
        if (!dialog.isDraggable()) {
            writer.write(",draggable: false");
        }
        if (dialog.getUnderlay() != null && !dialog.getUnderlay().equalsIgnoreCase("shadow")) {
            writer.write(",underlay: '" + dialog.getUnderlay() + "'");
        }
        if (dialog.isFixedCenter()) {
            writer.write(",fixedcenter: true");
        }
        if (!dialog.isClose()) {
            writer.write(",close: false");
        }
        if (dialog.isConstrainToViewport()) {
            writer.write(",constraintoviewport: true");
        }
        if (dialog.getX() != -1) {
            writer.write(",x:" + dialog.getX());
        }
        if (dialog.getY() != -1) {
            writer.write(",y:" + dialog.getY());
        }
        if (dialog.isModal()) {
            writer.write(",modal: true");
        }
        if (dialog.getEffect() != null) {
            writer.write(",effect:{effect:YAHOO.widget.ContainerEffect." + dialog.getEffect().toUpperCase() + ", duration: " + dialog.getEffectDuration() + "}");
        }
        writer.write("};\n");
    }

    private ConfirmDialog getConfirmation(CommandLink link) {
        List kids = link.getChildren();
        for (UIComponent kid : kids) {
            if (!(kid instanceof ConfirmDialog)) continue;
            return (ConfirmDialog)kid;
        }
        return null;
    }
}

